/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsClusterViewTableModel;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsVswitchViewTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.Neighbor;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelRefreshDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIAddRemoteDiscoveryPortalDialog;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsTableHeader;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsTablePanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrPanel;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SrISCSIRemoteDiscoveryPortalsShowDialog
extends SrOKCancelRefreshDialog {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_DISCOVERY_PORTALS_SHOW_DIALOG_SPECIFIC_TITLE);
    private static final String ADD = "Add";
    private final int MAX_DISCOVERY_PORTALS_TO_CONFIGURE = 200;
    private int m_dialogView = 0;
    private SrTreeNode m_treeNode = null;
    private boolean m_isVswitchView = false;
    private SrISCSIRemoteDiscoveryPortalsTablePanel m_remoteDiscoveryPortalsTablePanel = null;
    private SrISCSIAddRemoteDiscoveryPortalDialog m_addPortalDialog = null;

    public SrISCSIRemoteDiscoveryPortalsShowDialog(JFrame owner, SrTreeNode treeNode, int dialogView) {
        super(owner, "", SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_treeNode = treeNode;
        this.m_dialogView = dialogView;
        if (this.m_dialogView == 1) {
            this.m_isVswitchView = true;
        }
        this.setDialogTitle();
        this.initDialogPanels();
        this.initDialogLayout();
        this.setSizeAndMoveToCenter(650, 400);
        this.startRefreshTimer(REFRESH_DELAY);
        this.pack();
        AddAction myOKAction = new AddAction();
        this.setOKAction(myOKAction);
    }

    protected Collection<SrFuture<Void>> refresh() {
        ArrayList<VSwitchNode> vswitchesToRefresh = new ArrayList<VSwitchNode>();
        if (this.m_isVswitchView) {
            vswitchesToRefresh.add((VSwitchNode)this.m_treeNode);
        } else {
            ClusterNode clusterNode = (ClusterNode)this.m_treeNode;
            List<VSwitchNode> clusterVswitches = clusterNode.getClusterVSwitches();
            vswitchesToRefresh.addAll(clusterVswitches);
        }
        return Collections.singleton(SrISCSIRemoteDiscoveryPortalsManager.getInstance().refreshRemoteDiscoveryPortalsTable(vswitchesToRefresh));
    }

    private void setDialogTitle() {
        String title = "";
        switch (this.m_dialogView) {
            case 0: {
                title = ClientLoader.CLUSTER_DISPLAY_STRING + " " + ((ClusterNode)this.m_treeNode).getAlias();
                break;
            }
            case 1: {
                title = ClientLoader.VSWITCH_DISPLAY_STRING + " " + ((VSwitchNode)this.m_treeNode).getName();
                break;
            }
            case 2: {
                title = "Target " + (TargetNode)this.m_treeNode;
            }
        }
        this.setTitle(title + " - " + DIALOG_SPECIFIC_TITLE);
    }

    private void initDialogPanels() {
        this.createISCSIRemoteDiscoveryPortalsTablePanel();
    }

    private void createISCSIRemoteDiscoveryPortalsTablePanel() {
        this.m_remoteDiscoveryPortalsTablePanel = this.m_isVswitchView ? new SrISCSIRemoteDiscoveryPortalsTablePanel((JFrame)this.getOwner(), this, new SrISCSIRemoteDiscoveryPortalsVswitchViewTableModel(new SrDefaultTableColumns(SrISCSIRemoteDiscoveryPortalsTableHeader.getColumnNames()), (VSwitchNode)this.m_treeNode), (VSwitchNode)this.m_treeNode) : new SrISCSIRemoteDiscoveryPortalsTablePanel((JFrame)this.getOwner(), this, new SrISCSIRemoteDiscoveryPortalsClusterViewTableModel(new SrDefaultTableColumns(SrISCSIRemoteDiscoveryPortalsTableHeader.getColumnNames()), (ClusterNode)this.m_treeNode), null);
    }

    @Override
    protected void setCancelButtonText() {
        this.btnCancel.setText(CLOSE);
    }

    @Override
    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.btnCancel);
    }

    @Override
    protected Collection<SrFuture<Void>> doOnRefresh() {
        return this.refresh();
    }

    @Override
    public void removeListeners() {
        this.m_remoteDiscoveryPortalsTablePanel.getModel().removeListeners();
    }

    @Override
    public void addListeners() {
        this.m_remoteDiscoveryPortalsTablePanel.getModel().addListeners();
    }

    @Override
    public void doOnCancel() {
    }

    private void initDialogLayout() {
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)this.m_remoteDiscoveryPortalsTablePanel, "North");
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
    }

    private class AddAction
    extends SrClientAction<Void, Void> {
        public AddAction() {
            super(SrLicenseTreePath.GENERAL_PATH);
            SrISCSIRemoteDiscoveryPortalsShowDialog.this.myIsShouldDispose = false;
            this.setName(SrISCSIRemoteDiscoveryPortalsShowDialog.ADD);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            final ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SrISCSIRemoteDiscoveryPortalsShowDialog.this.m_addPortalDialog = new SrISCSIAddRemoteDiscoveryPortalDialog((JDialog)SrISCSIRemoteDiscoveryPortalsShowDialog.this, ((SiteNode)clusterNode.getParent()).getAlias(), clusterNode);
                    SrISCSIRemoteDiscoveryPortalsShowDialog.this.m_addPortalDialog.show();
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            List<Neighbor> neighbors;
            boolean setAddEnabled = false;
            if (SrISCSIRemoteDiscoveryPortalsShowDialog.this.m_remoteDiscoveryPortalsTablePanel.getModel().getRowCount() == 200) {
                return "Cannot configure more than 200 discovery portals";
            }
            if (SrISCSIRemoteDiscoveryPortalsShowDialog.this.m_isVswitchView && ((neighbors = ((VSwitchNode)SrISCSIRemoteDiscoveryPortalsShowDialog.this.m_treeNode).getNeighbors()) == null || neighbors.size() != 0)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.ISCSI_REMOTE_TARGET_DISCOVERY_PORTALS_CANT_ADD_TO_VS_WITH_NEIGHBOUR, ClientLoader.VSWITCH_DISPLAY_STRING);
            }
            return null;
        }
    }
}

