/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrIntegerTextField;

public class SrISCSIRemoteDiscoveryPortalPropertiesPanel
extends SrPropertyPanel
implements SrISCSIRemoteDiscoveryPortalsListener {
    public static final String KEY_IP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_REMOTE_DISCOVERY_PORTAL_PROPERTIES_PORTAL_IP);
    public static final String KEY_PORT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_REMOTE_DISCOVERY_PORTAL_PROPERTIES_PORTAL_PORT);
    public static final String KEY_PERIOD = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_REMOTE_DISCOVERY_PORTAL_PROPERTIES_PERIOD);
    protected VSwitchNode m_openedOnVSwitch;
    protected SrISCSIRemoteDiscoveryPortalNode m_currentPortalProperties;

    public SrISCSIRemoteDiscoveryPortalPropertiesPanel(String parentName, SrISCSIRemoteDiscoveryPortalNode portal, VSwitchNode openedOnVSwitch) {
        super(parentName, false, true, false);
        this.m_openedOnVSwitch = openedOnVSwitch;
        this.m_currentPortalProperties = portal;
        this.initFields();
        this.refreshPropertiesValues(this.m_currentPortalProperties);
        SrISCSIRemoteDiscoveryPortalsManager.getInstance().addISCSIRemoteDiscoveryPortalsListener(this);
    }

    protected VSwitchNode getOpenedOnVSwitch() {
        return this.m_openedOnVSwitch;
    }

    public void removeAsListener() {
        SrISCSIRemoteDiscoveryPortalsManager.getInstance().removeISCSIRemoteDiscoveryPortalsListener(this);
    }

    @Override
    public void iscsiRemoteDiscoveryPortalCreated(SrISCSIRemoteDiscoveryPortalEvent e) {
    }

    @Override
    public void iscsiRemoteDiscoveryPortalRemoved(SrISCSIRemoteDiscoveryPortalEvent e) {
    }

    @Override
    public void iscsiRemoteDiscoveryPortalChanged(SrISCSIRemoteDiscoveryPortalEvent e) {
        SrISCSIRemoteDiscoveryPortalNode nodeEvent = e.getISCSIRemoteDiscoveryPortalNode();
        if (((ISCSIRemotePortalDiscovery)nodeEvent.getStub()).equals(this.m_currentPortalProperties.getStub())) {
            this.refreshPropertiesValues(nodeEvent);
        }
    }

    protected void initFields() {
        SrIPTextField iptf = new SrIPTextField();
        iptf.setValue(this.m_currentPortalProperties.getIP());
        iptf.setEditable(false);
        this.addProperty(KEY_IP, (SrComponent)iptf);
        SrIntegerTextField inttf = new SrIntegerTextField();
        inttf.setValue(this.m_currentPortalProperties.getPort().toString());
        inttf.setEditable(false);
        this.addProperty(KEY_PORT, (SrComponent)inttf);
        inttf = new SrIntegerTextField();
        inttf.setEditable(false);
        this.addProperty(KEY_PERIOD, (SrComponent)inttf);
    }

    protected void refreshPropertiesValues(SrISCSIRemoteDiscoveryPortalNode node) {
        SrIntegerTextField inttf = (SrIntegerTextField)this.getProperty(KEY_PERIOD);
        inttf.setValue(node.getPeriod().toString());
    }
}

