/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorStatisticsNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorsStatisticsManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsTableModel;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsStatisticsListener;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsStatisticsRowSelectionEvent;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsStatisticsRowSelectionListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsTablePanel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SrISCSIRemoteInitiatorsStatisticChart
extends SrStatisticChart
implements ISCSIRemoteInitiatorsStatisticsListener,
ISCSIRemoteInitiatorsStatisticsRowSelectionListener {
    private static final String SERIES_OUT_CMDS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOVE_INITIATORS_STATISTICS_CHART_OUT_CMDS);
    private static final String SERIES_WRITTEN_MB = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOVE_INITIATORS_STATISTICS_CHART_WRITTEN_MB);
    private static final String SERIES_READ_MB = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOVE_INITIATORS_STATISTICS_CHART_READ_MB);
    private SrISCSIRemoteInitiatorsStatisticsTablePanel m_statTable;
    private ISCSIRemoteInitiatorStatisticsNode m_currentRemoteInitiator;

    public SrISCSIRemoteInitiatorsStatisticChart(SrISCSIRemoteInitiatorsStatisticsTablePanel statTable, int aPollingInterval) {
        super(aPollingInterval);
        this.addSeries(SERIES_OUT_CMDS);
        this.addSeries(SERIES_WRITTEN_MB);
        this.addSeries(SERIES_READ_MB);
        ISCSIRemoteInitiatorsStatisticsManager.getInstance().addISCSIRemoteInitiatorsStatisticsListener(this);
        this.m_statTable = statTable;
        this.m_statTable.addRemoteInitiatorsSelectionListener(this);
    }

    @Override
    public void iscsiRemoteInitiatorStatisticsCreated(StatisticsEvent e) {
    }

    @Override
    public void iscsiRemoteInitiatorStatisticsRemoved(StatisticsEvent e) {
        ISCSIRemoteInitiatorStatisticsNode statisticsNode = (ISCSIRemoteInitiatorStatisticsNode)e.getStatisticsNode();
        if (this.getItem2RatesMap().containsKey(statisticsNode)) {
            this.getItem2RatesMap().remove(statisticsNode);
        }
        if (this.m_currentRemoteInitiator != null && ((ISCSIRemoteInitiatorStatistics)statisticsNode.getStub()).equals(this.m_currentRemoteInitiator.getStub())) {
            if (this.m_statTable.getTable().getRowCount() > 0) {
                this.selectFirstRowStatistics();
            } else {
                this.getChartPanel().getChart().setTitle("");
                for (int i = 0; i < this.m_dataset.getSeriesCount(); ++i) {
                    this.m_dataset.getSeries(i).clear();
                }
            }
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        ISCSIRemoteInitiatorStatisticsNode statisticsNode = (ISCSIRemoteInitiatorStatisticsNode)e.getStatisticsNode();
        HashMap values = statisticsNode.getChangedValues();
        if (this.isFirstEvent()) {
            if (this.m_statTable.getTable().getRowCount() > 0) {
                this.selectFirstRowStatistics();
            }
            this.setFirstEvent(false);
        }
        List<HashMap> remoteInitiatorValues = null;
        if (!this.getItem2RatesMap().containsKey(statisticsNode)) {
            remoteInitiatorValues = new ArrayList();
            this.getItem2RatesMap().put(statisticsNode, remoteInitiatorValues);
        } else {
            remoteInitiatorValues = (List)this.getItem2RatesMap().get(statisticsNode);
        }
        remoteInitiatorValues.add(values);
        if (this.m_currentRemoteInitiator == null || ((ISCSIRemoteInitiatorStatistics)statisticsNode.getStub()).equals(this.m_currentRemoteInitiator.getStub())) {
            Date time = new Date();
            values.put("PointInTime", time);
            this.updateStatisticsChart(values);
            this.m_currentRemoteInitiator = statisticsNode;
        }
    }

    private void selectFirstRowStatistics() {
        ISCSIRemoteInitiatorStatisticsNode[] remoteInitiatorsNodes = ((SrISCSIRemoteInitiatorsStatisticsTableModel)this.m_statTable.getModel()).getRemoteInitiatorStatisticsNodes();
        this.remoteInitiatorStatisticsRowSelected(new ISCSIRemoteInitiatorsStatisticsRowSelectionEvent(this, remoteInitiatorsNodes[0]));
    }

    protected void finalize() throws Throwable {
        this.removeListeners();
        super.finalize();
    }

    @Override
    public void removeListeners() {
        ISCSIRemoteInitiatorsStatisticsManager.getInstance().removeISCSIRemoteInitiatorsStatisticsListener(this);
        this.m_statTable.removeRemoteInitiatorsSelectionListener(this);
    }

    @Override
    public void remoteInitiatorStatisticsRowSelected(ISCSIRemoteInitiatorsStatisticsRowSelectionEvent event) {
        ISCSIRemoteInitiatorStatisticsNode remoteInitiator = event.getRemoteInitiator();
        this.getChartPanel().getChart().setTitle(this.createChartTitle(remoteInitiator));
        this.m_currentRemoteInitiator = remoteInitiator;
        List data = null;
        data = this.getItem2RatesMap().containsKey(this.m_currentRemoteInitiator) ? (List)this.getItem2RatesMap().get(this.m_currentRemoteInitiator) : new ArrayList(0);
        this.switchItemChartDisplay(data);
    }

    @Override
    protected void updateStatisticsChart(HashMap newItem) {
        Date time = (Date)newItem.get("PointInTime");
        Long outCmds = (Long)newItem.get(ClientParameterCode.ISCSI_REMOTE_INITIATOR_OUT_CMDS_PER_SEC);
        Long writtenMB = (Long)newItem.get(ClientParameterCode.ISCSI_REMOTE_INITIATOR_WRITTEN_MB_PER_SEC);
        Long readMB = (Long)newItem.get(ClientParameterCode.ISCSI_REMOTE_INITIATOR_READ_MB_PER_SEC);
        if (outCmds != null) {
            this.setSeriesValue(SERIES_OUT_CMDS, time, outCmds);
        }
        if (writtenMB != null) {
            this.setSeriesValue(SERIES_WRITTEN_MB, time, writtenMB);
        }
        if (readMB != null) {
            this.setSeriesValue(SERIES_READ_MB, time, readMB);
        }
    }

    private String createChartTitle(ISCSIRemoteInitiatorStatisticsNode remoteInitiator) {
        StringBuffer sb = new StringBuffer();
        sb.append(remoteInitiator.getInitiatorName());
        sb.append(" <-> ");
        sb.append(remoteInitiator.getTargetAlias());
        return sb.toString();
    }
}

