/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorsStatisticsManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsClusterViewTableModel;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsTableModel;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsTargetViewTableModel;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsVswitchViewTableModel;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsStatisticsListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticsDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticChart;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsClusterViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsTablePanel;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsTargetViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.SrISCSIRemoteInitiatorsStatisticsVswitchViewTablePanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;

public class ISCSIRemoteInitiatorsStatisticsDialog
extends SrStatisticsDialog
implements ISCSIRemoteInitiatorsStatisticsListener {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_INITIATORS_STATISTICS_DIALOG_SPECIFIC_TITLE);

    public ISCSIRemoteInitiatorsStatisticsDialog(JFrame owner, SrTreeNode aTreeNode) {
        super(owner, "", null, aTreeNode);
        this.setDialogTitle(this.myTreeNode, DIALOG_SPECIFIC_TITLE);
        this.m_scrollChartPanel.setPreferredSize(new Dimension(this.m_scrollChartPanel.getPreferredSize().width, this.m_scrollChartPanel.getPreferredSize().height - 50));
        SrClientAction.waitAndInvokeController(this.activateDeactivateStatisticsUpdate(true), this);
        this.setSize(650, 700);
    }

    @Override
    public void addListeners() {
        ISCSIRemoteInitiatorsStatisticsManager.getInstance().addISCSIRemoteInitiatorsStatisticsListener(this);
    }

    @Override
    public void removeListeners() {
        ISCSIRemoteInitiatorsStatisticsManager.getInstance().removeISCSIRemoteInitiatorsStatisticsListener(this);
        if (this.m_statisticsTablePanel != null) {
            SrISCSIRemoteInitiatorsStatisticsTableModel model = (SrISCSIRemoteInitiatorsStatisticsTableModel)((SrISCSIRemoteInitiatorsStatisticsTablePanel)this.m_statisticsTablePanel).getModel();
            model.removeAllRows();
            model.removeListeners();
        }
        if (this.m_statisticChart != null) {
            ((SrISCSIRemoteInitiatorsStatisticChart)this.m_statisticChart).removeListeners();
        }
    }

    private Collection<SrFuture<Void>> activateDeactivateStatisticsUpdate(boolean mode) {
        if (this.myTreeNode instanceof ClusterNode) {
            return this.activateStatisticsInAllRemoteInitiatorsGroupNodes(mode);
        }
        if (this.myTreeNode instanceof VSwitchNode) {
            Set<SrFuture<Void>> retVal = Collections.singleton(StatisticsManager.activateDeactivateStatistics(((VSwitchNode)this.myTreeNode).getISCSIRemoteInitiatorsGroupNode(), mode));
            if (!mode) {
                ISCSIRemoteInitiatorsStatisticsManager.getInstance().clearStatisticNodeParamsList((VSwitchNode)this.myTreeNode);
            }
            return retVal;
        }
        if (this.myTreeNode instanceof TargetNode) {
            return this.activateStatisticsInTargetRemoteInitiatorsGroupNodes(mode);
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "Unsupported type for ISCSI remote initiators statistics dialog");
        return Collections.EMPTY_LIST;
    }

    private Collection<SrFuture<Void>> activateStatisticsInAllRemoteInitiatorsGroupNodes(boolean mode) {
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches((ClusterNode)this.myTreeNode);
        ArrayList<SrFuture<Void>> retVal = new ArrayList<SrFuture<Void>>(clusterVswitches.size());
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index);
            retVal.add(StatisticsManager.activateDeactivateStatistics(vswitchNode.getISCSIRemoteInitiatorsGroupNode(), mode));
            if (mode) continue;
            ISCSIRemoteInitiatorsStatisticsManager.getInstance().clearStatisticNodeParamsList(vswitchNode);
        }
        return retVal;
    }

    private Collection<SrFuture<Void>> activateStatisticsInTargetRemoteInitiatorsGroupNodes(boolean mode) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        ArrayList<SrFuture<Void>> retVal = new ArrayList<SrFuture<Void>>(clusterVswitches.size());
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            String vswitchName;
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index);
            String vswitchNameExposedOn = ((TargetNode)this.myTreeNode).getExposedOnVSwitchName();
            if (!vswitchNameExposedOn.equalsIgnoreCase(vswitchName = vswitchNode.getName())) continue;
            retVal.add(StatisticsManager.activateDeactivateStatistics(vswitchNode.getISCSIRemoteInitiatorsGroupNode(), mode));
            if (mode) break;
            ISCSIRemoteInitiatorsStatisticsManager.getInstance().clearStatisticNodeParamsList(vswitchNode);
            break;
        }
        return retVal;
    }

    @Override
    public void doOnCancel() {
        SrAction.waitAndInvokeController(this.activateDeactivateStatisticsUpdate(false), this);
    }

    @Override
    protected void initDialogPanels() {
    }

    private SrTablePanel createISCSIRemoteInitiatorsStatisticsTablePanel() {
        if (this.myTreeNode instanceof ClusterNode) {
            return new SrISCSIRemoteInitiatorsStatisticsClusterViewTablePanel(new SrISCSIRemoteInitiatorsStatisticsClusterViewTableModel((ClusterNode)this.myTreeNode));
        }
        if (this.myTreeNode instanceof VSwitchNode) {
            return new SrISCSIRemoteInitiatorsStatisticsVswitchViewTablePanel(new SrISCSIRemoteInitiatorsStatisticsVswitchViewTableModel((VSwitchNode)this.myTreeNode));
        }
        if (this.myTreeNode instanceof TargetNode) {
            return new SrISCSIRemoteInitiatorsStatisticsTargetViewTablePanel(new SrISCSIRemoteInitiatorsStatisticsTargetViewTableModel((TargetNode)this.myTreeNode));
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "Unsupported type for ISCSI remote initiators statistics dialog");
        return null;
    }

    @Override
    protected ChartPanel getStatisticsChartPanel() {
        int interval = 60;
        if (this.m_vswitchNode != null) {
            interval = this.m_vswitchNode.getStatisticsPollInterval();
        } else {
            Vector<ClusterNode> clusters = SystemRootNode.getInstance().getClusterNodes();
            if (clusters.isEmpty()) {
                throw new IllegalStateException("Statistics were requested but there are no clusters in the system");
            }
            VSwitchNode curVs = null;
            for (ClusterNode curCluster : clusters) {
                VSwitchNode[] vsArr = curCluster.getVSwitches();
                if (vsArr == null && vsArr.length <= 0) continue;
                curVs = vsArr[0];
                break;
            }
            if (curVs == null) {
                throw new IllegalStateException("Statistics were requested but there are no VSs in the system");
            }
            interval = curVs.getStatisticsPollInterval();
        }
        this.m_statisticChart = new SrISCSIRemoteInitiatorsStatisticChart((SrISCSIRemoteInitiatorsStatisticsTablePanel)this.m_statisticsTablePanel, interval);
        return this.m_statisticChart.packChartToPanel();
    }

    @Override
    protected SrPanel getStatisticsDetailsPanel() {
        return null;
    }

    @Override
    protected SrTablePanel getStatisticsExtendedTablePanel() {
        return null;
    }

    @Override
    protected SrTablePanel getStatisticsTablePanel() {
        SrTablePanel table = this.createISCSIRemoteInitiatorsStatisticsTablePanel();
        Dimension dim = table.getPreferredSize();
        table.setPreferredSize(new Dimension(700, dim.height / 2));
        return table;
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        this.setLastUpdateTime(new GregorianCalendar());
    }

    @Override
    public void iscsiRemoteInitiatorStatisticsCreated(StatisticsEvent e) {
    }

    @Override
    public void iscsiRemoteInitiatorStatisticsRemoved(StatisticsEvent e) {
    }
}

