/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.remoteinitiator.show;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.SrISCSIRemoteInitiatorsClusterViewTableModel;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.SrISCSIRemoteInitiatorsTargetViewTableModel;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.SrISCSIRemoteInitiatorsVswitchViewTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrCloseDialog;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.show.SrISCSIRemoteInitiatorsClusterViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.show.SrISCSIRemoteInitiatorsTargetViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.show.SrISCSIRemoteInitiatorsVswitchViewTablePanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class ISCSIRemoteInitiatorsShowDialog
extends SrCloseDialog {
    private int m_dialogView = 0;
    private SrTreeNode m_treeNode = null;
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_REMOTE_INITIATORS_SHOW_DIALOG_SPECIFIC_TITLE);
    private SrTablePanel m_remoteInitiatorsTablePanel;

    public ISCSIRemoteInitiatorsShowDialog(JFrame owner, SrTreeNode treeNode, int dialogView) {
        super(owner, "", SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_treeNode = treeNode;
        this.m_dialogView = dialogView;
        this.setDialogTitle();
        this.initDialogPanels();
        this.initDialogLayout();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ISCSIRemoteInitiatorsShowDialog.this.doOnCancel();
            }
        });
        this.pack();
    }

    @Override
    public void doOnCancel() {
    }

    private void setDialogTitle() {
        String title = "";
        switch (this.m_dialogView) {
            case 0: {
                title = ClientLoader.CLUSTER_DISPLAY_STRING + " " + ((ClusterNode)this.m_treeNode).getAlias();
                break;
            }
            case 1: {
                title = ClientLoader.VSWITCH_DISPLAY_STRING + " " + ((VSwitchNode)this.m_treeNode).getName();
                break;
            }
            case 2: {
                title = "Target " + (TargetNode)this.m_treeNode;
            }
        }
        this.setTitle(title + " - " + DIALOG_SPECIFIC_TITLE);
    }

    private void initDialogPanels() {
        this.createISCSIRemoteInitiatorsTablePanel();
    }

    private void createISCSIRemoteInitiatorsTablePanel() {
        switch (this.m_dialogView) {
            case 0: {
                this.m_remoteInitiatorsTablePanel = new SrISCSIRemoteInitiatorsClusterViewTablePanel(new SrISCSIRemoteInitiatorsClusterViewTableModel((ClusterNode)this.m_treeNode));
                break;
            }
            case 1: {
                this.m_remoteInitiatorsTablePanel = new SrISCSIRemoteInitiatorsVswitchViewTablePanel(new SrISCSIRemoteInitiatorsVswitchViewTableModel((VSwitchNode)this.m_treeNode));
                break;
            }
            case 2: {
                this.m_remoteInitiatorsTablePanel = new SrISCSIRemoteInitiatorsTargetViewTablePanel(new SrISCSIRemoteInitiatorsTargetViewTableModel((TargetNode)this.m_treeNode));
            }
        }
    }

    @Override
    public void removeListeners() {
        this.m_remoteInitiatorsTablePanel.getModel().removeListeners();
    }

    @Override
    public void addListeners() {
        this.m_remoteInitiatorsTablePanel.getModel().addListeners();
    }

    private void initDialogLayout() {
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)this.m_remoteInitiatorsTablePanel, "Center");
        super.initDialogLayout(mainPanel);
    }
}

