/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.instance;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.instance.ISCSIInstanceInfo;
import com.sanrad.nms.client.data.iscsi.instance.ISCSIInstancesManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.instance.ISCSIInstanceEvent;
import com.sanrad.nms.client.event.iscsi.instance.ISCSIInstancesListener;
import com.sanrad.nms.client.event.vswitch.VSwitchAdapter;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrCloseDialog;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.components.SrClientTextField;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.HashMap;
import javax.swing.JFrame;

public class ISCSIInstanceInfoDialog
extends SrCloseDialog
implements ISCSIInstancesListener {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INSTANCE_INFO_DIALOG_SPECIFIC_TITLE);
    private VSwitchNode m_vswitchNode;
    private SrClientLabel m_minVersionSupportedLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INSTANCE_INFO_DIALOG_MIN_VERSION_SUPPORTED));
    private SrClientLabel m_maxVersionSupportedLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INSTANCE_INFO_DIALOG_MAX_VERSION_SUPPORTED));
    private SrClientLabel m_numOfPortalsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INSTANCE_INFO_DIALOG_NUM_OF_PORTALS));
    private SrClientLabel m_numOfNodesLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INSTANCE_INFO_DIALOG_NUM_OF_NODES));
    private SrClientLabel m_numOfTargetsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INSTANCE_INFO_DIALOG_NUM_OF_NODES_BASIC_CAPABILITY));
    private SrClientLabel m_numOfSessionsLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INSTANCE_INFO_DIALOG_NUM_OF_SESSIONS));
    private SrTextField m_minVersionSupportedTextField = new SrTextField();
    private SrTextField m_maxVersionSupportedTextField = new SrTextField();
    private SrTextField m_numOfPortalsTextField = new SrTextField();
    private SrTextField m_numOfNodesTextField = new SrTextField();
    private SrClientTextField m_numOfTargetsTextField = new SrClientTextField();
    private SrTextField m_numOfSessionsTextField = new SrTextField();
    private VSwitchAdapter m_vSwitchListener = new VSwitchAdapter(){

        @Override
        public void vSwitchPropertiesChanged(VSwitchEvent e) {
            VSwitchNode vswitch = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
            if (vswitch.equals(ISCSIInstanceInfoDialog.this.m_vswitchNode)) {
                ISCSIInstanceInfoDialog.this.m_numOfTargetsTextField.setText(ISCSIInstanceInfoDialog.this.m_vswitchNode.getTargetCount().toString());
            }
        }
    };

    public ISCSIInstanceInfoDialog(JFrame owner, VSwitchNode vswitchNode) {
        super(owner, ClientLoader.VSWITCH_DISPLAY_STRING + " " + vswitchNode.getName() + ": " + DIALOG_SPECIFIC_TITLE, SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_vswitchNode = vswitchNode;
        this.initDialogComponents();
        this.initDialogLayout();
        SrLicenseTreePath initiatorPath = SrLicenseTreePath.INITIATOR_PATH;
        this.m_numOfTargetsLabel.addInvisibleLicensePaths(initiatorPath);
        this.m_numOfTargetsTextField.addInvisibleLicensePaths(initiatorPath);
        this.pack();
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void addListeners() {
        ISCSIInstancesManager.getInstance().addISCSIInstancesListener(this);
        VSwitchManager.getInstance().addVSwitchListener(this.m_vSwitchListener);
    }

    @Override
    public void removeListeners() {
        ISCSIInstancesManager.getInstance().removeISCSIInstancesListener(this);
        VSwitchManager.getInstance().removeVSwitchListener(this.m_vSwitchListener);
    }

    @Override
    public void iscsiInstanceChanged(ISCSIInstanceEvent e) {
        BigInteger newValBigInt;
        Integer newValInt;
        HashMap values = e.getValuesMap();
        Object newVal = values.get(ClientParameterCode.ISCSI_INSTANCE_MIN_VERSION_SUPPORTED);
        if (newVal != null) {
            newValInt = (Integer)newVal;
            this.m_minVersionSupportedTextField.setText(newValInt.toString());
        }
        if ((newVal = values.get(ClientParameterCode.ISCSI_INSTANCE_MAX_VERSION_SUPPORTED)) != null) {
            newValInt = (Integer)newVal;
            this.m_maxVersionSupportedTextField.setText(newValInt.toString());
        }
        if ((newVal = values.get(ClientParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS)) != null) {
            newValBigInt = (BigInteger)newVal;
            this.m_numOfPortalsTextField.setText(newValBigInt.toString());
        }
        if ((newVal = values.get(ClientParameterCode.ISCSI_INSTANCE_NUM_OF_NODES)) != null) {
            newValBigInt = (BigInteger)newVal;
            this.m_numOfNodesTextField.setText(newValBigInt.toString());
        }
        if ((newVal = values.get(ClientParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS)) != null) {
            newValBigInt = (BigInteger)newVal;
            this.m_numOfSessionsTextField.setText(newValBigInt.toString());
        }
    }

    private void initDialogComponents() {
        ISCSIInstanceInfo infoNode = (ISCSIInstanceInfo)this.m_vswitchNode.getISCSIInstanceInfos().elementAt(0);
        this.initTextField(this.m_minVersionSupportedTextField, infoNode.getMinVersionSupported().toString());
        this.initTextField(this.m_maxVersionSupportedTextField, infoNode.getMaxVersionSupported().toString());
        this.initTextField(this.m_numOfPortalsTextField, infoNode.getNumOfPortals().toString());
        this.initTextField(this.m_numOfNodesTextField, infoNode.getNumOfNodes().toString());
        this.initTextField(this.m_numOfTargetsTextField, this.m_vswitchNode.getTargetCount().toString());
        this.initTextField(this.m_numOfSessionsTextField, infoNode.getNumOfSessions().toString());
        String text1 = Utility.NO_VAL;
        String text2 = Utility.NO_VAL;
        if (infoNode.getLastFailureType() != null) {
            text1 = infoNode.getLastFailureType().toString();
            text2 = infoNode.getLastRemoteNodeName();
        }
    }

    private void initTextField(SrTextField textField, String text) {
        textField.setColumns(15);
        textField.setEditable(false);
        textField.setText(text);
    }

    private void initDialogLayout() {
        SrPanel panel = new SrPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int rowIndex = 0;
        c.weighty = 0.1;
        c.weightx = 0.5;
        c.anchor = 23;
        c.fill = 1;
        Insets leftInsets = new Insets(10, 10, 5, 5);
        Insets rightInsets = new Insets(10, 5, 5, 10);
        this.addGuiRow(panel, this.m_minVersionSupportedLabel, this.m_minVersionSupportedTextField, c, rowIndex++, leftInsets, rightInsets);
        leftInsets = new Insets(5, 10, 5, 5);
        rightInsets = new Insets(5, 5, 5, 10);
        this.addGuiRow(panel, this.m_maxVersionSupportedLabel, this.m_maxVersionSupportedTextField, c, rowIndex++, leftInsets, rightInsets);
        this.addGuiRow(panel, this.m_numOfPortalsLabel, this.m_numOfPortalsTextField, c, rowIndex++, leftInsets, rightInsets);
        this.addGuiRow(panel, this.m_numOfNodesLabel, this.m_numOfNodesTextField, c, rowIndex++, leftInsets, rightInsets);
        this.addGuiRow(panel, this.m_numOfTargetsLabel, this.m_numOfTargetsTextField, c, rowIndex++, leftInsets, rightInsets);
        this.addGuiRow(panel, this.m_numOfSessionsLabel, this.m_numOfSessionsTextField, c, rowIndex++, leftInsets, rightInsets);
        this.addCenterPanel(panel);
    }

    private void addGuiRow(SrPanel panel, SrClientLabel label, SrTextField textField, GridBagConstraints c, int rowIndex, Insets leftInsets, Insets rightInsets) {
        c.insets = leftInsets;
        c.gridx = 0;
        c.gridy = rowIndex;
        panel.add((Component)label, c);
        if (textField != null) {
            c.insets = rightInsets;
            c.gridx = 1;
            panel.add((Component)textField, c);
        }
    }

    @Override
    public void iscsiInstanceCreated(ISCSIInstanceEvent e) {
    }

    @Override
    public void iscsiInstanceRemoved(ISCSIInstanceEvent e) {
    }
}

