/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.connection;

import com.sanrad.nms.client.data.iscsi.connection.SrISCSISessionConnectionsModelsManager;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSISessionConnectionsTableModel;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionRowSelectionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionRowSelectionListener;
import com.sanrad.nms.client.gui.iscsi.connection.ISCSIConnectionsTableHeader;
import com.sanrad.nms.client.gui.iscsi.connection.SrISCSIConnectionsTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.show.SrISCSISessionsTablePanel;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;

public class SrISCSISessionConnectionsTablePanel
extends SrISCSIConnectionsTablePanel
implements ISCSISessionRowSelectionListener {
    private SrISCSISessionConnectionsModelsManager m_modelManager;
    private SrISCSISessionsTablePanel m_sessionTablePanel;
    private String m_lastInitiatorGroupName;
    private String m_lastTargetGroupName;

    public SrISCSISessionConnectionsTablePanel(SrISCSISessionConnectionsModelsManager modelsManager, SrISCSISessionsTablePanel sessionTablePanel) {
        super(modelsManager.getModelAt(0));
        this.m_modelManager = modelsManager;
        this.m_sessionTablePanel = sessionTablePanel;
        this.m_sessionTablePanel.addISCSISessionSelectionListener(this);
        this.initTableColumnsGroups();
    }

    protected void initiColumns(SessionDirectionConstant sessionDirection) {
        this.initTableColumnsGroups(sessionDirection);
        this.initTableColumnsInvisible();
    }

    @Override
    protected void initTableColumnsGroups() {
        if (this.m_modelManager != null) {
            SrISCSISessionConnectionsTableModel model = this.m_modelManager.getModelAt(0);
            model.removeListeners();
            ISCSISessionNode sessionNode = model.getSessionNode();
            if (sessionNode != null) {
                SessionDirectionConstant sessionDirection = model.getSessionNode().getDirection();
                this.initTableColumnsGroups(sessionDirection);
            } else {
                super.initTableColumnsGroups();
            }
        }
    }

    protected void initTableColumnsGroups(SessionDirectionConstant sessionDirection) {
        SrTableModel model = this.getModel();
        boolean isSessionInbound = sessionDirection.equals(SessionDirectionConstant.IN_BOUND);
        String initiatorAddressGroupPrefix = isSessionInbound ? ISCSIConnectionsTableHeader.REMOTE_HEADER_GROUP_TITLE : ISCSIConnectionsTableHeader.LOCAL_HEADER_GROUP_TITLE;
        String targetAddressGroupPrefix = isSessionInbound ? ISCSIConnectionsTableHeader.LOCAL_HEADER_GROUP_TITLE : ISCSIConnectionsTableHeader.REMOTE_HEADER_GROUP_TITLE;
        int[] initiatorAddressGroup = new int[]{model.getColumnIndex(initiatorAddressGroupPrefix + " " + ISCSIConnectionsTableHeader.INITIATOR_IP.getColumnName()), model.getColumnIndex(initiatorAddressGroupPrefix + " " + ISCSIConnectionsTableHeader.INITIATOR_PORT.getColumnName())};
        this.m_lastInitiatorGroupName = initiatorAddressGroupPrefix + " " + this.INITIATOR_HEADER_GROUP_TITLE;
        this.addNewColumnGroup(this.m_lastInitiatorGroupName, initiatorAddressGroup);
        int[] targetAddressGroup = new int[]{model.getColumnIndex(targetAddressGroupPrefix + " " + ISCSIConnectionsTableHeader.TARGET_IP.getColumnName()), model.getColumnIndex(targetAddressGroupPrefix + " " + ISCSIConnectionsTableHeader.TARGET_PORT.getColumnName())};
        this.m_lastTargetGroupName = targetAddressGroupPrefix + " " + this.TARGET_HEADER_GROUP_TITLE;
        this.addNewColumnGroup(this.m_lastTargetGroupName, targetAddressGroup);
    }

    @Override
    protected void initTableColumnsInvisible() {
        super.initTableColumnsInvisible();
        this.hideTableColumn(ISCSIConnectionsTableHeader.VSWITCH.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.INITIATOR_ALIAS.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.INITIATOR_NAME.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.ISID.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.TARGET_ALIAS.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.TARGET_NAME.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.TSIH.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.CID.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.MAX_RECEIVED_PDU_LENGTH.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.MAX_TRANSMITTED_PDU_LENGTH.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.HEADER_INTEGRITY.getColumnName());
        this.hideTableColumn(ISCSIConnectionsTableHeader.DATA_INTEGRITY.getColumnName());
    }

    @Override
    public void iscsiSessionRowSelected(ISCSISessionRowSelectionEvent event) {
        SrISCSISessionConnectionsTableModel model = this.getSelectedSessionConnectionsModel(event.getIscsiSessionNode());
        this.updateTableView(model);
    }

    public void updateTableView(SrISCSISessionConnectionsTableModel model) {
        ISCSISessionNode sessionNode = model.getSessionNode();
        if (sessionNode != null) {
            SessionDirectionConstant sessionDirection = model.getSessionNode().getDirection();
            boolean isSessionInbound = sessionDirection.equals(SessionDirectionConstant.IN_BOUND);
            String initiatorAddressGroupPrefix = isSessionInbound ? ISCSIConnectionsTableHeader.REMOTE_HEADER_GROUP_TITLE : ISCSIConnectionsTableHeader.LOCAL_HEADER_GROUP_TITLE;
            String targetAddressGroupPrefix = isSessionInbound ? ISCSIConnectionsTableHeader.LOCAL_HEADER_GROUP_TITLE : ISCSIConnectionsTableHeader.REMOTE_HEADER_GROUP_TITLE;
            String newInitiatorAddressGroupName = initiatorAddressGroupPrefix + " " + this.INITIATOR_HEADER_GROUP_TITLE;
            String newTargetAddressGroupName = targetAddressGroupPrefix + " " + this.TARGET_HEADER_GROUP_TITLE;
            this.setModel(model);
            this.changeGroupHeaderName(this.m_lastInitiatorGroupName, newInitiatorAddressGroupName);
            this.changeGroupHeaderName(this.m_lastTargetGroupName, newTargetAddressGroupName);
            this.m_lastInitiatorGroupName = newInitiatorAddressGroupName;
            this.m_lastTargetGroupName = newTargetAddressGroupName;
        }
    }

    @Override
    public void iscsiSessionRowEmptySelection() {
        this.getTable().setModel(new SrTableModel(new SrDefaultTableColumns(ISCSIConnectionsTableHeader.getColumnNames())){

            @Override
            public void removeListeners() {
            }

            @Override
            public void addListeners() {
            }
        });
    }

    private SrISCSISessionConnectionsTableModel getSelectedSessionConnectionsModel(ISCSISessionNode iscsiSessionNode) {
        return this.m_modelManager.getSelectedSessionConnectionsModel(iscsiSessionNode);
    }
}

