/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.iscsi.connection;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSIConnectionsClusterViewTableModel;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSIConnectionsTargetViewTableModel;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSIConnectionsVswitchViewTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrCloseDialog;
import com.sanrad.nms.client.gui.iscsi.connection.SrISCSIConnectionsClusterViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.connection.SrISCSIConnectionsTargetViewTablePanel;
import com.sanrad.nms.client.gui.iscsi.connection.SrISCSIConnectionsVswitchViewTablePanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;

public class ISCSIConnectionsShowDialog
extends SrCloseDialog {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_CONNECTIONS_DIALOG_SPECIFIC_TITLE);
    private int m_dialogView = 0;
    private SrTreeNode m_treeNode = null;
    private SrTablePanel m_connectionsTablePanel;

    public ISCSIConnectionsShowDialog(JFrame owner, SrTreeNode treeNode, int dialogView) {
        super(owner, "", SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_treeNode = treeNode;
        this.m_dialogView = dialogView;
        this.setDialogTitle();
        this.initDialogPanels();
        this.initDialogLayout();
        this.setLocation(50, 100);
        this.pack();
    }

    @Override
    public void removeListeners() {
        this.m_connectionsTablePanel.getModel().removeListeners();
    }

    @Override
    public void addListeners() {
        this.m_connectionsTablePanel.getModel().addListeners();
    }

    @Override
    public void doOnCancel() {
    }

    private void setDialogTitle() {
        String title = "";
        switch (this.m_dialogView) {
            case 0: {
                title = ClientLoader.CLUSTER_DISPLAY_STRING + " " + ((ClusterNode)this.m_treeNode).getAlias();
                break;
            }
            case 1: {
                title = ClientLoader.VSWITCH_DISPLAY_STRING + " " + ((VSwitchNode)this.m_treeNode).getName();
                break;
            }
            case 2: {
                title = "Target " + (TargetNode)this.m_treeNode;
            }
        }
        this.setTitle(title + " - " + DIALOG_SPECIFIC_TITLE);
    }

    private void initDialogPanels() {
        this.createISCSIConnectionsTablePanel();
        Dimension dim = this.m_connectionsTablePanel.getPreferredSize();
        this.m_connectionsTablePanel.setPreferredSize(new Dimension(900, dim.height));
    }

    private void createISCSIConnectionsTablePanel() {
        switch (this.m_dialogView) {
            case 0: {
                this.m_connectionsTablePanel = new SrISCSIConnectionsClusterViewTablePanel(new SrISCSIConnectionsClusterViewTableModel((ClusterNode)this.m_treeNode));
                break;
            }
            case 1: {
                this.m_connectionsTablePanel = new SrISCSIConnectionsVswitchViewTablePanel(new SrISCSIConnectionsVswitchViewTableModel((VSwitchNode)this.m_treeNode));
                break;
            }
            case 2: {
                this.m_connectionsTablePanel = new SrISCSIConnectionsTargetViewTablePanel(new SrISCSIConnectionsTargetViewTableModel((TargetNode)this.m_treeNode));
            }
        }
    }

    private void initDialogLayout() {
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)this.m_connectionsTablePanel, "Center");
        super.initDialogLayout(mainPanel);
    }
}

