/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.initiator;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorManager;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.initiator.SrInitiatorEvent;
import com.sanrad.nms.client.event.initiator.SrInitiatorsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.initiator.SrInitiatorPropertyPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFrame;

public class SrInitiatorPropertiesDlg
extends SrOKCancelDialog
implements SrInitiatorsListener {
    private SrInitiatorPropertyPanel myPropertyPanel;
    private SrPasswordTextField myChapPasswordTextField;
    private SrTextField myChapUserTextField;
    private static final int CREDENTIALS_MIN_PASSWORD_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MIN_PASSWORD_LENGTH));
    private static final int CREDENTIALS_MAX_PASSWORD_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MAX_PASSWORD_LENGTH));

    public SrInitiatorPropertiesDlg(JFrame frm, String siteName, ClusterNode aCluster, VSwitchNode vswitchNode, SrInitiatorNode initiatorNode) {
        super(frm, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_TITLE_VSWITCH) + " " + vswitchNode.getName() + "; " + ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_SPECIFIC_TITLE) + " " + ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_PROPERTIES_DLG_SPECIFIC_TITLE), aCluster);
        this.myPropertyPanel = new SrInitiatorPropertyPanel(SrInitiatorPropertiesDlg.class.getName(), initiatorNode);
        this.myChapUserTextField = (SrTextField)this.myPropertyPanel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_CHAP_USER_NAME));
        this.myChapPasswordTextField = (SrPasswordTextField)this.myPropertyPanel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_CHAP_PASSWORD));
        this.addCenterPanel(this.myPropertyPanel);
        this.setOKAction();
        this.pack();
    }

    @Override
    public void addListeners() {
        SrInitiatorManager.getInstance().addInitiatorsListener(this);
    }

    @Override
    public void removeListeners() {
        SrInitiatorManager.getInstance().removeInitiatorsListener(this);
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String chapUserName = SrInitiatorPropertiesDlg.this.myChapUserTextField.getText().trim();
                String chapPassword = new String(SrInitiatorPropertiesDlg.this.myChapPasswordTextField.getPassword()).trim();
                String srpUserName = (String)SrInitiatorPropertiesDlg.this.myPropertyPanel.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_SRP_USER_NAME));
                String srpPassword = (String)SrInitiatorPropertiesDlg.this.myPropertyPanel.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_SRP_PASSWORD));
                Collection<SrFuture<Void>> retVal = SrInitiatorPropertiesDlg.this.editCredentials(chapUserName, chapPassword, srpUserName, srpPassword);
                return retVal;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String chapUserName = SrInitiatorPropertiesDlg.this.myChapUserTextField.getText().trim();
                if (chapUserName.equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.ISCSI_INITIATOR_DLG_CHAP_USER_NAME_IS_MISSING);
                }
                String chapPassword = new String(SrInitiatorPropertiesDlg.this.myChapPasswordTextField.getPassword()).trim();
                if (chapPassword.length() < CREDENTIALS_MIN_PASSWORD_LENGTH || chapPassword.length() > CREDENTIALS_MAX_PASSWORD_LENGTH) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.ISCSI_INITIATOR_DLG_CHAP_PASSWORD_IS_MISSING, Integer.toString(CREDENTIALS_MIN_PASSWORD_LENGTH), Integer.toString(CREDENTIALS_MAX_PASSWORD_LENGTH));
                }
                return null;
            }
        };
        this.myChapUserTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.myChapPasswordTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
    }

    protected Collection<SrFuture<Void>> editCredentials(String chapUserName, String chapPassword, String srpUserName, String srpPassword) {
        SrInitiatorNode initiatorNode = this.myPropertyPanel.getInitiatorNode();
        HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
        params.put(ClientParameterCode.ISCSI_INITIATOR_CHAP_USER_NAME, chapUserName);
        params.put(ClientParameterCode.ISCSI_INITIATOR_CHAP_PASSWORD, chapPassword);
        if (srpUserName != null && !srpUserName.equals(initiatorNode.getSRPUserName())) {
            params.put(ClientParameterCode.ISCSI_INITIATOR_SRP_USER_NAME, srpUserName);
        }
        if (srpPassword != null) {
            params.put(ClientParameterCode.ISCSI_INITIATOR_SRP_PASSWORD, srpPassword);
        }
        return Collections.singleton(ClientAOImpl.getInstance().changeElements(Collections.singleton(this.myPropertyPanel.getInitiatorNode().getIdentifier()), params));
    }

    @Override
    public void iscsiInitiatorChanged(SrInitiatorEvent e) {
        SrInitiatorNode initiatorNode = e.getInitiatorNode();
        String alias = initiatorNode.getAlias();
        String name = initiatorNode.getName();
        this.myPropertyPanel.setPropertyValue(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_ALIAS), alias);
        this.myPropertyPanel.setPropertyValue(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_DLG_NAME), name);
    }

    @Override
    public void iscsiInitiatorRemoved(SrInitiatorEvent e) {
    }

    @Override
    public void iscsiInitiatorCreated(SrInitiatorEvent e) {
    }

    @Override
    public void doOnCancel() {
    }
}

