/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.initiator;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.initiator.SrSCSIInitiatorPortNode;
import com.sanrad.nms.client.data.initiator.SrSCSIInitiatorPortsTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrCloseDialog;
import com.sanrad.nms.client.gui.initiator.SrISCSIInitiatorPortsTablePanel;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public class SrISCSIInitiatorPortsShowDialog
extends SrCloseDialog {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_PORTS_DLG_SPECIFIC_TITLE);
    private SrInitiatorNode m_initiatorNode;
    private SrSCSIInitiatorPortNode m_initiatorPortNodeStartPollingInitiator;
    private SrISCSIInitiatorPortsTablePanel m_initiatorPortsTablePanel;

    public SrISCSIInitiatorPortsShowDialog(JFrame owner, SrInitiatorNode initiatorNode) {
        super(owner, "", SystemRootNode.getInstance().getCurrentClusterNode());
        this.m_initiatorNode = initiatorNode;
        this.m_initiatorPortNodeStartPollingInitiator = (SrSCSIInitiatorPortNode)this.m_initiatorNode.getSCSIPorts()[0];
        this.setDialogTitle();
        this.initDialogPanels();
        this.initDialogLayout();
        this.pack();
    }

    @Override
    public void addListeners() {
        SrAction.waitAndInvokeController(this.activateDeactivateStatisticsUpdate(true), this);
    }

    @Override
    public void removeListeners() {
        SrAction.waitAndInvokeController(this.activateDeactivateStatisticsUpdate(false), StatusPanel.getInstance());
    }

    private void setDialogTitle() {
        ClusterNode clusterNode = (ClusterNode)this.m_initiatorNode.getParentVSwitch().getParent();
        SiteNode siteNode = (SiteNode)clusterNode.getParent();
        StringBuffer sb = new StringBuffer(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ISCSI_INITIATOR_PORTS_DLG_TITLE_SITE));
        sb.append(siteNode.getAlias());
        sb.append("; ");
        sb.append(ClientLoader.CLUSTER_DISPLAY_STRING);
        sb.append(":");
        sb.append(clusterNode.getAlias());
        sb.append("; ");
        sb.append(ClientLoader.VSWITCH_DISPLAY_STRING);
        sb.append(":");
        sb.append(this.m_initiatorNode.getAlias());
        sb.append(" - ");
        sb.append(DIALOG_SPECIFIC_TITLE);
        this.setTitle(sb.toString());
    }

    private void initDialogPanels() {
        this.createInitiatorPortsTablePanel();
        Dimension dim = this.m_initiatorPortsTablePanel.getPreferredSize();
        this.m_initiatorPortsTablePanel.setPreferredSize(new Dimension(dim.width + 100, 200));
    }

    private void createInitiatorPortsTablePanel() {
        this.m_initiatorPortsTablePanel = new SrISCSIInitiatorPortsTablePanel((JFrame)this.getOwner(), new SrSCSIInitiatorPortsTableModel(this.m_initiatorNode));
    }

    private void initDialogLayout() {
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)this.m_initiatorPortsTablePanel, "North");
        super.initDialogLayout(mainPanel);
    }

    private Collection<SrFuture<Void>> activateDeactivateStatisticsUpdate(boolean mode) {
        if (this.m_initiatorPortNodeStartPollingInitiator != null) {
            return Collections.singleton(StatisticsManager.activateDeactivateStatistics((CommKeyClassId)this.m_initiatorPortNodeStartPollingInitiator.getIdentifier(), mode, (CommKeyClassId)this.m_initiatorPortNodeStartPollingInitiator.getParent().getIdentifier()));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setVisible(boolean aB) {
        super.setVisible(aB);
    }
}

