/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.identity.IdentityNameManager;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JDialog;

public class NewIdentityNameDialog
extends SrOKCancelDialog {
    private static final String EMPTY_NAME_ERROR = ClientLoader.BUNDLE.getString(SrClientBundleKeys.EMPTY_IDENTITY_NAME_TOOLTIP);
    private SrTextField nameFld;
    private IdentityNode identityNode;

    public NewIdentityNameDialog(JDialog owner, IdentityNode node) {
        super(owner, "Host Group: " + node.getAlias() + " - New Initiator Name", SystemRootNode.getInstance().getClusterNodeOfSource(node));
        this.identityNode = node;
        this.initialize();
        MyOKAction myOKAction = new MyOKAction();
        this.nameFld.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
    }

    protected void initialize() {
        SrClientLabel label = new SrClientLabel("Initiator Name (wwui): ");
        this.nameFld = new SrTextField(14);
        SrPanel panel = this.createSrPanel(label, this.nameFld);
        this.addCenterPanel(panel);
        this.setComponentBgColor(this.buttonsPanel);
        this.setSizeAndMoveToCenter(400, 150);
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }

    private class MyOKAction
    extends SrClientAction<Void, Void> {
        public MyOKAction() {
            super(SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String name = NewIdentityNameDialog.this.nameFld.getText().trim();
            return Collections.singleton(IdentityNameManager.getInstance().createIdentityName(NewIdentityNameDialog.this.identityNode, name));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String name = NewIdentityNameDialog.this.nameFld.getText().trim();
            if (name.indexOf(" ") > -1) {
                return "The name cannot have spaces.";
            }
            if (name.trim().length() == 0) {
                return EMPTY_NAME_ERROR;
            }
            return null;
        }
    }
}

