/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JTextArea;

public class NewIdentityDialog
extends SrOKCancelDialog<ClusterNode> {
    private static final String CLUSTER_SHOULD_BE_SELECTED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CLUSTER_NOT_SELECTED);
    private static final String SELECT_CLUSTER_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_IDENTITY_DIALOG_SELECT_CLUSTER_TEXT);
    private SrTextField aliasFld;
    private SrClientLabel aliasLbl;
    private JTextArea descriptionFld;
    private SrClientLabel descriptionLbl;

    public NewIdentityDialog(JFrame owner, ClusterNode workingCluster) {
        super(owner, "New Host Group", true, workingCluster);
        this.initComponents();
        this.fixSizes();
        this.addTopContextBox(SELECT_CLUSTER_TEXT, ClusterNode.class, SrSystemObjectComboBox.CLUSTER_PROPERTIES, null);
        this.setTopContextBoxSelection(workingCluster);
        MyOKAction myOKAction = new MyOKAction();
        this.aliasFld.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.addItemListenerToTopContextBox(new View.ToggleButtonListener(myOKAction));
        this.setOKAction(myOKAction);
        this.pack();
    }

    protected void fixSizes() {
        Dimension dim = this.descriptionLbl.getPreferredSize();
        this.aliasLbl.setPreferredSize(dim);
    }

    protected void initComponents() {
        this.aliasFld = new SrTextField(15);
        this.aliasLbl = new SrClientLabel("Alias: ");
        SrPanel aliasPanel = this.createSrPanel(this.aliasLbl, this.aliasFld);
        this.descriptionLbl = new SrClientLabel("Description: ");
        this.descriptionFld = new JTextArea(3, 18);
        this.descriptionFld.setFont(LookAndFill.GENERAL_FONT);
        SrScrollPane scroll = new SrScrollPane(this.descriptionFld);
        scroll.setVerticalScrollBarPolicy(22);
        SrPanel descPanel = this.createSrPanel(this.descriptionLbl, scroll);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(3, 0));
        mainPanel.add(aliasPanel);
        mainPanel.add(descPanel);
        mainPanel.add(new SrPanel());
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
    }

    @Override
    protected void systemNodeSelected(ClusterNode aClusterNode) {
        this.m_workingCluster = aClusterNode;
    }

    @Override
    public void doOnCancel() {
        this.success(null);
    }

    @Override
    public void removeListeners() {
    }

    private class MyOKAction
    extends SrClientAction<Void, Void> {
        public MyOKAction() {
            super(SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String alias = NewIdentityDialog.this.aliasFld.getText();
            String description = NewIdentityDialog.this.descriptionFld.getText();
            return Collections.singleton(IdentityManager.getInstance().createIdentity(NewIdentityDialog.this.m_workingCluster, alias, description));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (NewIdentityDialog.this.m_workingCluster == null) {
                return CLUSTER_SHOULD_BE_SELECTED;
            }
            if (NewIdentityDialog.this.aliasFld.getText().trim().equals("")) {
                return "Alias cannot be empty";
            }
            return null;
        }
    }
}

