/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.auth.CredentialsValidator;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientCheckBox;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JDialog;

public class NewCredentialsDialog
extends SrOKCancelDialog {
    private static final SrLogger theLogger = SrLogger.getLogger();
    protected final String SRP = "SRP";
    protected final String CHAP = "CHAP";
    private SrClientLabel methodLbl;
    private SrClientLabel userNameLbl;
    private SrClientLabel passwordLbl;
    protected SrComboBox<String> methodCbox;
    protected SrTextField userFld;
    protected SrPasswordTextField passwordFld;
    protected SrClientCheckBox radiusEnabledCb;
    private SrClientLabel radiusEnabledLbl;
    protected final String[] methods = new String[]{"CHAP", "SRP"};
    protected IdentityNode identityNode;

    public NewCredentialsDialog(JDialog owner, IdentityNode identityNode) {
        super(owner, "New Credentials", true, SystemRootNode.getInstance().getClusterNodeOfSource(identityNode));
        this.identityNode = identityNode;
        this.initComponents();
        this.fixSizes();
        this.setSizeAndMoveToCenter(350, 250);
        this.setOKAction(this.getOKAction());
    }

    protected void fixSizes() {
        Dimension dim = this.passwordLbl.getPreferredSize();
        this.userNameLbl.setPreferredSize(dim);
        this.methodLbl.setPreferredSize(dim);
        this.radiusEnabledLbl.setPreferredSize(dim);
        dim = this.userFld.getPreferredSize();
        this.methodCbox.setPreferredSize(dim);
    }

    protected void initComponents() {
        this.methodLbl = new SrClientLabel("Method: ");
        this.methodCbox = new SrComboBox<String>((T[])this.methods);
        this.methodCbox.setFont(LookAndFill.GENERAL_FONT);
        SrPanel methodPanel = this.createSrPanel(this.methodLbl, this.methodCbox);
        this.methodCbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewCredentialsDialog.this.enableRadiusSelection();
            }
        });
        this.userNameLbl = new SrClientLabel("User Name: ");
        this.userFld = new SrTextField(15);
        SrPanel userPanel = this.createSrPanel(this.userNameLbl, this.userFld);
        StringBuffer passwordLabelText = new StringBuffer("Password: [");
        passwordLabelText.append(CredentialsValidator.MIN_PASSWORD_LENGTH);
        passwordLabelText.append("-");
        passwordLabelText.append(CredentialsValidator.MAX_PASSWORD_LENGTH);
        passwordLabelText.append(" characters] ");
        this.passwordLbl = new SrClientLabel(passwordLabelText.toString());
        this.passwordFld = new SrPasswordTextField(15);
        this.passwordFld.setMaxLength(CredentialsValidator.MAX_PASSWORD_LENGTH);
        SrPanel passwodPanel = this.createSrPanel(this.passwordLbl, this.passwordFld);
        this.radiusEnabledCb = new SrClientCheckBox();
        this.radiusEnabledLbl = new SrClientLabel("RADIUS Enabled: ");
        SrPanel radiusPanel = this.createSrPanel(this.radiusEnabledLbl, this.radiusEnabledCb);
        this.radiusEnabledCb.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewCredentialsDialog.this.enablePassordField();
            }
        });
        this.enableRadiusSelection();
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(4, 0));
        mainPanel.add(methodPanel);
        mainPanel.add(userPanel);
        mainPanel.add(passwodPanel);
        mainPanel.add(radiusPanel);
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
    }

    protected void enablePassordField() {
        boolean isRadiusSelected = this.radiusEnabledCb.isSelected();
        this.passwordFld.setEnabled(!isRadiusSelected);
        this.passwordLbl.setEnabled(!isRadiusSelected);
    }

    private void enableRadiusSelection() {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        String method = (String)this.methodCbox.getSelectedItem();
        boolean chap = method.equalsIgnoreCase("CHAP");
        boolean isRadiusServerExist = clusterNode != null && clusterNode.getRadiusServers().size() > 0;
        this.radiusEnabledCb.setEnabled(chap && isRadiusServerExist);
        this.radiusEnabledCb.setVisible(chap);
        this.radiusEnabledLbl.setVisible(chap);
    }

    public CredentialsOKAction getOKAction() {
        return new CredentialsOKAction();
    }

    @Override
    public void doOnCancel() {
        this.success(null);
    }

    @Override
    public void removeListeners() {
    }

    public class CredentialsOKAction
    extends SrClientAction<Void, Void> {
        public CredentialsOKAction() {
            super(SrLicenseTreePath.GENERAL_PATH);
            NewCredentialsDialog.this.userFld.getDocument().addDocumentListener(new View.ViewTextListener(this));
            NewCredentialsDialog.this.passwordFld.getDocument().addDocumentListener(new View.ViewTextListener(this));
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String userName = NewCredentialsDialog.this.userFld.getText();
            String password = new String(NewCredentialsDialog.this.passwordFld.getPassword());
            switch (NewCredentialsDialog.this.methodCbox.getSelectedIndex()) {
                case 1: {
                    return Collections.singleton(ClientAOImpl.getInstance().createSRPCredentials((CommKeyClassId)NewCredentialsDialog.this.identityNode.getIdentifier(), userName, password));
                }
                case 0: {
                    return Collections.singleton(ClientAOImpl.getInstance().createCHAPCredentials((CommKeyClassId)NewCredentialsDialog.this.identityNode.getIdentifier(), userName, password, NewCredentialsDialog.this.radiusEnabledCb.isSelected()));
                }
            }
            theLogger.logAndAssert(SrLogCategories.ERROR, "Unsupported password Authentication protocol in NewCredentialsDialog");
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String password;
            String userName = NewCredentialsDialog.this.userFld.getText();
            CredentialsValidator validator = new CredentialsValidator(userName, password = new String(NewCredentialsDialog.this.passwordFld.getPassword()), NewCredentialsDialog.this.radiusEnabledCb.isSelected());
            if (!validator.isValidForCreation()) {
                return validator.getErrorMessage();
            }
            return null;
        }
    }
}

