/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.identity.dialogs.IdentityCredentialsPanel;
import com.sanrad.nms.client.gui.identity.dialogs.IdentityNamesPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class IdentityPropertiesDialog
extends SrOKCancelDialog {
    private static final String theAliasLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IDENTITY_DLG_ALIAS);
    private static final String theDescLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IDENTITY_DLG_DESCRIPTION);
    private static final String theNamesTabLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IDENTITY_DLG_NAMES_TAB);
    private static final String theAuthTabLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IDENTITY_DLG_AUTHENTICATION_TAB);
    private static final String theDlgTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IDENTITY_DLG_TITLE);
    private SrTextField myAliasFld;
    private JTextArea myDescriptionFld;
    private IdentityNamesPanel myNamesPanel;
    private IdentityCredentialsPanel myCredentialsPanel;
    private IdentityNode myNode;
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String newAlias = IdentityPropertiesDialog.this.myAliasFld.getText().trim();
            String newDescription = IdentityPropertiesDialog.this.myDescriptionFld.getText().trim();
            HashMap<ClientParameterCode, String> parametersMap = new HashMap<ClientParameterCode, String>();
            if (IdentityPropertiesDialog.this.myNode != null) {
                if (!newAlias.equals(IdentityPropertiesDialog.this.myNode.getAlias()) && !newAlias.equals("")) {
                    parametersMap.put(ClientParameterCode.IDENTITY_ALIAS, newAlias);
                }
                if (!newDescription.equalsIgnoreCase(IdentityPropertiesDialog.this.myNode.getDescription())) {
                    parametersMap.put(ClientParameterCode.IDENTITY_DESCRIPTION, newDescription);
                }
            }
            if (!parametersMap.isEmpty()) {
                return Collections.singleton(IdentityManager.getInstance().editIdentity(IdentityPropertiesDialog.this.myNode, parametersMap));
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public IdentityPropertiesDialog(JFrame owner, IdentityNode identityNode) {
        super(owner, theDlgTitle, false, SystemRootNode.getInstance().getClusterNodeOfSource(identityNode));
        this.myNode = identityNode;
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (IdentityPropertiesDialog.this.myNode != null) {
                    IdentityPropertiesDialog.this.myNode.setUserObject(null);
                }
            }
        });
        if (this.myNode != null) {
            this.myAliasFld.setText(this.myNode.getAlias());
            this.myDescriptionFld.setText(this.myNode.getDescription());
        }
        this.setLocationRelativeTo(owner);
        this.pack();
        this.setOKAction(this.myOKAction);
    }

    @Override
    public void dispose() {
        if (this.myNode != null) {
            this.myNode.setUserObject(null);
        }
        super.dispose();
    }

    private void initComponents() {
        SrPanel propertiesPanel = this.createPropertiesPanel();
        JTabbedPane tabs = new JTabbedPane();
        this.myNamesPanel = new IdentityNamesPanel(this, this.myNode);
        this.myCredentialsPanel = new IdentityCredentialsPanel(this, this.myNode);
        tabs.addTab(theNamesTabLabel, this.myNamesPanel);
        tabs.addTab(theAuthTabLabel, this.myCredentialsPanel);
        this.setComponentBgColor(tabs);
        this.setComponentBgColor(this.buttonsPanel);
        SrPanel tabsPanel = new SrPanel();
        tabsPanel.setLayout(new BorderLayout());
        tabsPanel.add((Component)tabs, "Center");
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)tabsPanel, "Center");
        mainPanel.add((Component)propertiesPanel, "North");
        mainPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.addCenterPanel(mainPanel);
    }

    private SrPanel createPropertiesPanel() {
        SrPanel propPanel = new SrPanel();
        propPanel.setLayout(new GridLayout(2, 0));
        SrClientLabel aliasLbl = new SrClientLabel(theAliasLabel);
        SrClientLabel descriptionLbl = new SrClientLabel(theDescLabel);
        this.myAliasFld = new SrTextField(14);
        this.myDescriptionFld = new JTextArea(2, 17);
        this.myDescriptionFld.setFont(LookAndFill.GENERAL_FONT);
        SrScrollPane scroll = new SrScrollPane(this.myDescriptionFld);
        SrPanel aliasPanel = this.createSrPanel(aliasLbl, this.myAliasFld);
        SrPanel descPanel = this.createSrPanel(descriptionLbl, scroll);
        propPanel.add(aliasPanel);
        propPanel.add(descPanel);
        return propPanel;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

