/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity.dialogs;

import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.SrIdentityAuthenticationTableModel;
import com.sanrad.nms.client.data.identity.auth.CredentialsNode;
import com.sanrad.nms.client.event.identity.auth.CredentialsSelectionEvent;
import com.sanrad.nms.client.event.identity.auth.CredentialsSelectionListener;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.identity.SrIdentityAuthenticationTablePanel;
import com.sanrad.nms.client.gui.identity.dialogs.EditCredentialsDialog;
import com.sanrad.nms.client.gui.identity.dialogs.IdentityPropertiesDialog;
import com.sanrad.nms.client.gui.identity.dialogs.IdentityTabPanel;
import com.sanrad.nms.client.gui.identity.dialogs.NewCredentialsDialog;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.border.EmptyBorder;

public class IdentityCredentialsPanel
extends IdentityTabPanel
implements CredentialsSelectionListener {
    private SrIdentityAuthenticationTablePanel m_authTable;
    protected JButton editButton;

    public IdentityCredentialsPanel(IdentityPropertiesDialog owner, IdentityNode identityNode) {
        super(owner, identityNode);
    }

    @Override
    protected void initComponents() {
        SrIdentityAuthenticationTableModel model = new SrIdentityAuthenticationTableModel(this.myIdentityNode);
        this.m_authTable = new SrIdentityAuthenticationTablePanel(model);
        this.m_authTable.addCredentialsSelectionListener(this);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        mainPanel.add((Component)this.m_authTable, "Center");
        this.setCenterPanel(mainPanel);
    }

    void setIdentity(IdentityNode aIdentity) {
        this.myIdentityNode = aIdentity;
        this.m_authTable.setModel(new SrIdentityAuthenticationTableModel(this.myIdentityNode));
    }

    @Override
    protected void addButtonPressed() {
        new NewCredentialsDialog((JDialog)this.myOwner, this.myIdentityNode).show();
    }

    @Override
    protected DeleteAction getDeleteAction() {
        return this.m_authTable.myDeleteAction;
    }

    protected void editButtonPressed() {
        Object[] selectedCredentials = this.m_authTable.getSelectedValues();
        if (selectedCredentials != null && selectedCredentials.length > 0) {
            new EditCredentialsDialog((JDialog)this.myOwner, this.myIdentityNode, (CredentialsNode)selectedCredentials[0]).show();
        }
    }

    @Override
    protected SrPanel createButtonsPanel() {
        SrPanel panel = super.createButtonsPanel();
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdentityCredentialsPanel.this.editButtonPressed();
            }
        });
        this.editButton.setEnabled(false);
        panel.add(this.editButton);
        return panel;
    }

    @Override
    public void credentialsSelected(CredentialsSelectionEvent e) {
        SrIdentityAuthenticationTablePanel table = (SrIdentityAuthenticationTablePanel)e.getSource();
        int[] selRows = table.getTable().getSelectedRows();
        boolean enableDelete = false;
        boolean enableEdit = false;
        if (selRows != null && selRows.length > 0) {
            enableDelete = true;
            if (selRows.length == 1) {
                enableEdit = true;
            }
        }
        this.deleteBtn.setEnabled(enableDelete);
        this.editButton.setEnabled(enableEdit);
    }
}

