/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity.dialogs;

import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.auth.CHAPCredentialsNode;
import com.sanrad.nms.client.data.identity.auth.CredentialsNode;
import com.sanrad.nms.client.gui.identity.dialogs.NewCredentialsDialog;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JDialog;

public class EditCredentialsDialog
extends NewCredentialsDialog {
    protected CredentialsNode credentials;

    public EditCredentialsDialog(JDialog owner, IdentityNode identityNode, CredentialsNode credentials) {
        super(owner, identityNode);
        this.credentials = credentials;
        this.setComponents();
    }

    protected void setComponents() {
        String credentialsType = this.credentials.toString();
        this.methodCbox.setSelectedItem(credentialsType);
        this.methodCbox.setEnabled(false);
        this.userFld.setText(this.credentials.getUserName());
        if (credentialsType.equalsIgnoreCase("CHAP")) {
            this.radiusEnabledCb.setSelected(((CHAPCredentialsNode)this.credentials).isRadiusEnabled());
        }
        this.enablePassordField();
    }

    @Override
    public NewCredentialsDialog.CredentialsOKAction getOKAction() {
        return new NewCredentialsDialog.CredentialsOKAction(){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String userName = EditCredentialsDialog.this.userFld.getText();
                String password = new String(EditCredentialsDialog.this.passwordFld.getPassword());
                switch (EditCredentialsDialog.this.methodCbox.getSelectedIndex()) {
                    case 1: {
                        return Collections.singleton(EditCredentialsDialog.this.editSRP(userName, password));
                    }
                    case 0: {
                        return Collections.singleton(EditCredentialsDialog.this.editCHAP(userName, password, EditCredentialsDialog.this.radiusEnabledCb.isSelected()));
                    }
                }
                return Collections.EMPTY_LIST;
            }
        };
    }

    protected SrFuture<Void> editSRP(String userName, String password) {
        HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>(2);
        if (!userName.equalsIgnoreCase(this.credentials.getUserName())) {
            params.put(ClientParameterCode.SRP_CREDENTIALS_USER_NAME, userName);
        }
        params.put(ClientParameterCode.SRP_CREDENTIALS_PASSWORD, password);
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(this.credentials.getIdentifier()), params);
    }

    protected SrFuture<Void> editCHAP(String userName, String password, boolean radiusEnabled) {
        HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>(3);
        if (!userName.equalsIgnoreCase(this.credentials.getUserName())) {
            params.put(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, userName);
        }
        params.put(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD, password);
        if (radiusEnabled != ((CHAPCredentialsNode)this.credentials).isRadiusEnabled()) {
            params.put(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, new Boolean(radiusEnabled));
        }
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(this.credentials.getIdentifier()), params);
    }
}

