/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity;

import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.identity.SrIdentityAuthenticationTableModel;
import com.sanrad.nms.client.data.identity.auth.CredentialsNode;
import com.sanrad.nms.client.data.identity.auth.SRPCredentialsNode;
import com.sanrad.nms.client.event.identity.auth.CredentialsSelectionEvent;
import com.sanrad.nms.client.event.identity.auth.CredentialsSelectionListener;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.identity.IdentityAuthenticationTableHeader;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrCheckboxTableCellEditor;
import com.sanrad.swing.SrCheckboxTableCellRenderer;
import com.sanrad.swing.SrLineComponent;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrEventListenerManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;

public class SrIdentityAuthenticationTablePanel
extends SrClientTablePanel {
    SrEventListenerManager.Informer<CredentialsSelectionListener, CredentialsSelectionEvent> credentialsSelectedInformer = new SrEventListenerManager.Informer<CredentialsSelectionListener, CredentialsSelectionEvent>(){

        @Override
        public void inform(CredentialsSelectionListener listener, CredentialsSelectionEvent event) {
            listener.credentialsSelected(event);
        }
    };
    private View<CredentialsNode> myView = new SrTableView<CredentialsNode>((JTable)this.getTable()){

        @Override
        public Collection<CredentialsNode> getValue() {
            Object[] selectedValues = SrIdentityAuthenticationTablePanel.this.getSelectedValues();
            if (selectedValues == null || selectedValues.length == 0) {
                return Collections.EMPTY_LIST;
            }
            Vector<CredentialsNode> retVal = new Vector<CredentialsNode>(selectedValues.length);
            for (int i = 0; i < selectedValues.length; ++i) {
                retVal.add((CredentialsNode)selectedValues[i]);
            }
            return retVal;
        }
    };
    public DeleteAction myDeleteAction = new DeleteAction<CredentialsNode>(this.myView, StatusPanel.getInstance(), new DeleteAction.Confirmator());

    public SrIdentityAuthenticationTablePanel(SrIdentityAuthenticationTableModel model) {
        super(model);
        this.getTable().setColumnSelectionAllowed(false);
        this.getTable().setCellSelectionEnabled(false);
        this.getTable().setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setTableRenderer();
    }

    public void addCredentialsSelectionListener(CredentialsSelectionListener l) {
        this.m_listeners.add(l);
    }

    public void removeCredentialsSelectionListener(CredentialsSelectionListener l) {
        this.m_listeners.remove(l);
    }

    public Object[] getSelectedValues() {
        int[] selectedRows = this.getSelectedRows();
        int methodCol = ((SrIdentityAuthenticationTableModel)this.getModel()).getColumnIndex(IdentityAuthenticationTableHeader.METHOD.getColumnName());
        if (selectedRows != null) {
            Object[] values = new Object[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                values[i] = this.getModel().getValueAt(selectedRows[i], methodCol);
            }
            return values;
        }
        return null;
    }

    protected void setTableRenderer() {
        int radiusColIndex = ((SrIdentityAuthenticationTableModel)this.getModel()).getColumnIndex(IdentityAuthenticationTableHeader.RADIUS.getColumnName());
        this.getTable().getColumnModel().getColumn(radiusColIndex).setCellRenderer(new RadiusCheckboxTableCellRenderer());
        this.getTable().getColumnModel().getColumn(radiusColIndex).setCellEditor(new RadiusColEditor(new JCheckBox()));
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        CredentialsSelectionEvent event = new CredentialsSelectionEvent(this);
        this.m_listeners.fireEvent(CredentialsSelectionListener.class, event, this.credentialsSelectedInformer);
    }

    protected CredentialsNode[] getSelectedCredentialsNodes() {
        return ((SrIdentityAuthenticationTableModel)this.getModel()).getSelectedCredentialsNodes(this.getSelectedRows());
    }

    protected void setRadiusEnabled(boolean enable) {
        CredentialsNode[] credNodes = this.getSelectedCredentialsNodes();
        HashMap<ClientParameterCode, Integer> params = new HashMap<ClientParameterCode, Integer>();
        int radiusEnabled = enable ? 2 : 1;
        params.put(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, new Integer(radiusEnabled));
        ArrayList ids = new ArrayList(credNodes.length);
        for (CredentialsNode credNode : credNodes) {
            ids.add(credNode.getIdentifier());
        }
        SrClientAction.blockActions(Collections.singleton(ClientAOImpl.getInstance().changeElements(ids, params)), StatusPanel.getInstance());
    }

    public void success() {
    }

    public void inProccess(String msg) {
    }

    public void fail(String msg) {
        StatusPanel.getInstance().setText(msg, StatusPanel.ERROR, this);
    }

    @Override
    protected Class getTableHeaderClass() {
        return IdentityAuthenticationTableHeader.class;
    }

    class RadiusCheckboxTableCellRenderer
    extends SrCheckboxTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = new Boolean(false);
            }
            boolean shouldSelect = (Boolean)value;
            int credCol = ((SrIdentityAuthenticationTableModel)table.getModel()).getColumnIndex(IdentityAuthenticationTableHeader.METHOD.getColumnName());
            Object credentialsNode = table.getValueAt(row, credCol);
            if (!shouldSelect && credentialsNode instanceof SRPCredentialsNode) {
                value = "--";
                return this.createLineRenderer(isSelected);
            }
            boolean isSelectable = SystemRootNode.getInstance().getCurrentClusterNode().getRadiusServers().size() > 0;
            this.setSelected(shouldSelect);
            this.setEnabled(isSelectable);
            this.setHorizontalAlignment(0);
            this.setSelectionColor(this, isSelected);
            return this;
        }

        private void setSelectionColor(Component component, boolean isSelected) {
            if (isSelected) {
                component.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
                component.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
            } else {
                component.setBackground(LookAndFill.TABLE_BACKGROUND);
                component.setForeground(LookAndFill.TABLE_FOREGROUND);
            }
        }

        private JComponent createLineRenderer(boolean isSelected) {
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            SrLineComponent line = new SrLineComponent(Color.blue);
            p.add((Component)line, "Center");
            this.setSelectionColor(p, isSelected);
            return p;
        }
    }

    class RadiusColEditor
    extends SrCheckboxTableCellEditor {
        public RadiusColEditor(final JCheckBox checkbox) {
            super(checkbox);
            checkbox.setEnabled(false);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SrIdentityAuthenticationTablePanel.this.setRadiusEnabled(checkbox.isSelected());
                }
            });
        }
    }
}

