/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.AclEntryNode;
import com.sanrad.nms.client.data.acl.AclMap;
import com.sanrad.nms.client.data.acl.AclNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.IdentityValidator;
import com.sanrad.nms.client.data.identity.SrIdentitiesTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionAdapter;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.event.identity.IdentitySelectionEvent;
import com.sanrad.nms.client.event.identity.IdentitySelectionListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.identity.IdentitiesTableHeader;
import com.sanrad.nms.client.gui.identity.IdentitiesTableRenderer;
import com.sanrad.nms.client.gui.identity.SrIdentitiesTablePopupMenu;
import com.sanrad.nms.client.gui.identity.dialogs.IdentityPropertiesDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class SrIdentitiesTablePanel
extends SrClientTablePanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected IdentitySelectionAdapter m_identitySelectionAdapter = new IdentitySelectionAdapter();
    protected JFrame m_owner;
    SrEventListenerManager.Informer<IdentitySelectionListener, IdentitySelectionEvent> identitySelectedInformer = new SrEventListenerManager.Informer<IdentitySelectionListener, IdentitySelectionEvent>(){

        @Override
        public void inform(IdentitySelectionListener listener, IdentitySelectionEvent event) {
            listener.identitySelected(event);
        }
    };
    private View<IdentityNode> myView = new SrTableView<IdentityNode>((JTable)this.getTable()){

        @Override
        public Collection<IdentityNode> getValue() {
            return Arrays.asList(SrIdentitiesTablePanel.this.getSelectedIdentityNodes());
        }
    };
    public final SrClientAction identityPropertiesAction = new SrClientAction<IdentityNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<IdentityNode> arg) {
            IdentityNode[] nodes = arg.toArray(new IdentityNode[arg.size()]);
            JFrame frame = new JFrame();
            frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes == null) continue;
                Object uo = nodes[i].getUserObject();
                if (uo == null) {
                    IdentityPropertiesDialog props = new IdentityPropertiesDialog(frame, nodes[i]);
                    nodes[i].setUserObject(props);
                    int x = (int)props.getLocation().getX();
                    int y = (int)props.getLocation().getY();
                    props.setLocation(x + i * 5, y + i * 5);
                    props.show();
                    continue;
                }
                ((JDialog)uo).requestFocus();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final AlarmAction mySpecificAlarmsAction = new AlarmAction<IdentityNode>(this.myView, true);
    public final DeleteAction myDeleteAction = new DeleteAction<IdentityNode>(this.myView, (OperationController)StatusPanel.getInstance(), new DeleteAction.Confirmator(), false){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<IdentityNode> arg) {
            String questionString;
            IdentityValidator validator = new IdentityValidator(arg.toArray(new IdentityNode[arg.size()]));
            if (!validator.isValidForRemoval() && JOptionPane.showConfirmDialog(SrIdentitiesTablePanel.this, questionString = "Some of the selected Host Groups are attached to targets. Are you sure you want to delete them?", "Delete Host Groups", 0, 3) != 0) {
                return Collections.singleton(new CompleteFuture("SrIdentitiesTablePanel.myDeleteAction, not confirmed"));
            }
            return super.derivedActionPerformed(arg);
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String msg = super.derivedClientUpdateEnabled();
            if (msg != null) {
                return msg;
            }
            ClusterNode cluster = SystemRootNode.getInstance().getCurrentClusterNode();
            if (cluster != null) {
                PolicyManager policyMgr = cluster.getPolicyManager();
                AclMap aclMap = policyMgr.getAllAcl();
                Enumeration keys = aclMap.keys();
                Collection selectedNodes = this.myView.getValue();
                while (keys.hasMoreElements()) {
                    TargetNode targetNode = (TargetNode)keys.nextElement();
                    AclNode acl = (AclNode)aclMap.get(targetNode);
                    Vector<AclEntryNode> entries = acl.getAclEntries();
                    for (AclEntryNode aclEntryNodeObj : entries) {
                        AclEntryNode entry = aclEntryNodeObj;
                        IdentityNode identity = entry.getIdentity();
                        if (!selectedNodes.contains(identity)) continue;
                        String[] msgArgs = new String[]{identity.getAlias(), targetNode.getAlias()};
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.IDENTITY_DELETE_ATTACHED_TO_TARGET, msgArgs);
                    }
                }
            }
            return msg;
        }
    };

    public SrIdentitiesTablePanel(SrIdentitiesTableModel model) {
        this(model, null);
    }

    public SrIdentitiesTablePanel(SrIdentitiesTableModel model, JFrame owner) {
        super(model);
        this.m_owner = owner;
        this.getTable().setColumnSelectionAllowed(false);
        this.getTable().setCellSelectionEnabled(false);
        this.getTable().setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        SrIdentitiesTablePopupMenu m_popup = new SrIdentitiesTablePopupMenu(this);
        this.setTablePopUpMenuObject(m_popup);
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(new IdentitiesTableRenderer());
        }
        AlarmsManager.getInstance().addAlarmSourceSelectionListener(this.m_identitySelectionAdapter);
    }

    @Override
    public void removeListeners() {
        AlarmsManager.getInstance().removeAlarmSourceSelectionListener(this.m_identitySelectionAdapter);
    }

    protected void finalize() throws Throwable {
        this.removeListeners();
        super.finalize();
    }

    public void refresh() {
        ((SrIdentitiesTableModel)this.getModel()).refresh();
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            ((SrIdentitiesTableModel)this.getModel()).setRowSelected(rowIndices[0], rowIndices[rowIndices.length - 1]);
            int col = ((SrIdentitiesTableModel)this.getModel()).getColumnIndex(IdentitiesTableHeader.ALIAS.getColumnName());
            this.notifyIdentitySelected(rowIndices[0], col);
        } else {
            ((SrIdentitiesTableModel)this.getModel()).setRowSelected(-1, -1);
            this.notifyIdentitySelected(-1, -1);
        }
    }

    private void notifyIdentitySelected(int row, int col) {
        IdentityNode identityNode = null;
        if (row != -1 && col != -1) {
            try {
                identityNode = (IdentityNode)this.getModel().getValueAt(row, col);
            }
            catch (Exception e) {
                theLogger.warn(SrLogCategories.LEGACY, e);
                return;
            }
        }
        IdentitySelectionEvent event = new IdentitySelectionEvent(this, identityNode);
        this.m_listeners.fireEvent(IdentitySelectionListener.class, event, this.identitySelectedInformer);
    }

    public IdentityNode[] getSelectedIdentityNodes() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows != null) {
            IdentityNode[] nodes = new IdentityNode[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                int col = ((SrIdentitiesTableModel)this.getModel()).getColumnIndex(IdentitiesTableHeader.ALIAS.getColumnName());
                IdentityNode node = (IdentityNode)this.getModel().getValueAt(selectedRows[i], col);
                if (node == null) continue;
                nodes[i] = node;
            }
            return nodes;
        }
        return null;
    }

    public void addIdentitySelectionListeners(Vector listeners) {
        this.m_listeners.addAll(listeners);
    }

    public void addIdentitySelectionListener(IdentitySelectionListener l) {
        this.m_listeners.add(l);
    }

    public void removeIdentitySelectionListener(IdentitySelectionListener l) {
        this.m_listeners.remove(l);
    }

    public IdentityNode[] removeSelectedIdentities() {
        IdentityNode[] identities = this.getSelectedIdentityNodes();
        ((SrIdentitiesTableModel)this.getModel()).removeIdentities(identities);
        return identities;
    }

    public void addIdentities(Collection<IdentityNode> identities) {
        ((SrIdentitiesTableModel)this.getModel()).addIdentities(identities);
    }

    public void setOwner(JFrame owner) {
        this.m_owner = owner;
    }

    public void setModel(SrIdentitiesTableModel tableModel) {
        super.setModel(tableModel);
        TableModelEvent event = new TableModelEvent(tableModel);
        tableModel.fireTableChanged(event);
        this.selectSelectedRows();
    }

    public void selectSelectedRows() {
        Integer[] selectedRows = ((SrIdentitiesTableModel)this.getModel()).getSelectedRowIndices();
        if (selectedRows != null && selectedRows.length > 0) {
            this.setRowSelectionSet(selectedRows[0], selectedRows[selectedRows.length - 1]);
            this.scrollToRow(selectedRows[0]);
        } else {
            this.getTable().clearSelection();
        }
    }

    @Override
    protected Class getTableHeaderClass() {
        return IdentitiesTableHeader.class;
    }

    public View<IdentityNode> getView() {
        return this.myView;
    }

    class IdentitySelectionAdapter
    extends AlarmSourceSelectionAdapter {
        IdentitySelectionAdapter() {
        }

        @Override
        public void identitySelected(AlarmSourceSelectionEvent e) {
            SrTreeNode selected = e.getNode();
            if (selected != null) {
                IdentityNode node = (IdentityNode)selected;
                int col = ((SrIdentitiesTableModel)SrIdentitiesTablePanel.this.getModel()).getColumnIndex(IdentitiesTableHeader.ALIAS.getColumnName());
                int rowCount = SrIdentitiesTablePanel.this.getTable().getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    IdentityNode identity = (IdentityNode)SrIdentitiesTablePanel.this.getModel().getValueAt(i, col);
                    Object stub = identity.getStub();
                    if (!stub.equals(node.getStub())) continue;
                    SrIdentitiesTablePanel.this.setRowSelectionSet(i, i);
                }
            }
        }
    }
}

