/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.RendererPanel;
import com.sanrad.swing.LookAndFill;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class IdentitiesTableRenderer
extends DefaultTableCellRenderer {
    private RendererPanel m_rendererPanel = new RendererPanel();

    public IdentitiesTableRenderer() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = "";
        }
        String newVal = value.toString().replaceAll("\n", " ");
        this.setText(newVal);
        if (isSelected) {
            this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
        } else {
            this.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_FOREGROUND);
        }
        if (value instanceof IdentityNode) {
            this.setIcon(ClientImageObject.IDENTITIES.getImageIcon());
            this.m_rendererPanel.restorePanel(this, (SrTreeNode)value);
            if (isSelected) {
                this.m_rendererPanel.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            } else {
                this.m_rendererPanel.setBackground(Color.white);
            }
            return this.m_rendererPanel;
        }
        return this;
    }
}

