/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.identity;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.SrAvailableIdentitiesTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.identity.IdentitySelectionListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.identity.AvailableIdentitiesTableHeader;
import com.sanrad.nms.client.gui.identity.SrIdentitiesTablePanel;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrPanelTitle;
import com.sanrad.swing.actions.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class IdentitiesTablePanel
extends JPanel {
    private SrPanelTitle availableIdentLbl = new SrPanelTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ACL_AVAILABLE_IDENTITIES));
    private SrIdentitiesTablePanel m_identitiesTablePanel;
    private SrAvailableIdentitiesTableModel m_model;

    public IdentitiesTablePanel(JFrame owner, TargetNode targetNode) {
        this.initComponents(owner, targetNode);
    }

    protected void initComponents(JFrame owner, TargetNode targetNode) {
        this.setLayout(new BorderLayout());
        this.m_model = new SrAvailableIdentitiesTableModel(new SrDefaultTableColumns(AvailableIdentitiesTableHeader.getColumnNames()), targetNode);
        this.m_identitiesTablePanel = new SrIdentitiesTablePanel(this.m_model, owner);
        JPanel labelPanel = this.createLabelPanel();
        this.add((Component)this.m_identitiesTablePanel, "Center");
        this.add((Component)labelPanel, "North");
    }

    public void closeMe() {
        this.m_model.removeListeners();
    }

    public void setAsSelectionListener(IdentitySelectionListener l) {
        this.m_identitiesTablePanel.addIdentitySelectionListener(l);
    }

    protected JPanel createLabelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.availableIdentLbl);
        return panel;
    }

    public void refresh() {
        this.m_identitiesTablePanel.refresh();
    }

    public IdentityNode[] getSelectedIdentityNodes() {
        return this.m_identitiesTablePanel.getSelectedIdentityNodes();
    }

    public void newClusterHasBeenSelected() {
    }

    public IdentityNode[] removeSelectedIdentities() {
        return this.m_identitiesTablePanel.removeSelectedIdentities();
    }

    public void addIdentities(Collection<IdentityNode> selectedIdentities) {
        this.m_identitiesTablePanel.addIdentities(selectedIdentities);
    }

    public SrIdentitiesTablePanel getIdentitiesTablePanel() {
        return this.m_identitiesTablePanel;
    }

    public View<IdentityNode> getView() {
        return this.getIdentitiesTablePanel().getView();
    }
}

