/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.hardware;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.hardware.HardwareData;
import com.sanrad.nms.client.data.hardware.HardwareManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.hardware.HardwareDataEvent;
import com.sanrad.nms.client.event.hardware.HardwareDataListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.SrOKCancelFrame;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.hardware.Hardware;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class VSwitchHardwareDataDialog
extends SrOKCancelFrame
implements HardwareDataListener,
VSwitchListener {
    private VSwitchNode m_vSwitchNode;
    private HardwareData m_hardwareData;
    private SrClientLabel m_powerSuppliersLabelField;
    private SrClientLabel m_powerSuppliersCurrentWorkingValLabelField;
    private SrClientLabel m_powerSuppliersMaxNumberValLabelField;
    private SrClientLabel m_fansLabelField;
    private SrClientLabel m_fansCurrentWorkingValLabelField;
    private SrClientLabel m_fansMaxNumberValLabelField;
    private SrClientLabel m_cpuTempLabelField;
    private SrClientLabel m_cpuCurrentTempLabelField;
    private SrClientLabel m_cpuStatusTempLabelField;
    private SrClientLabel m_cpuCurrentTempValLabelField;
    private SrClientLabel m_cpuStatusTempValLabelField;
    private SrClientLabel m_cpuWarningAndCriticalTempLabelField;
    private SrClientLabel m_onboardTempLabelField;
    private SrClientLabel m_onboardCurrentTempLabelField;
    private SrClientLabel m_onboardStatusTempLabelField;
    private SrClientLabel m_onboardCurrentTempValLabelField;
    private SrClientLabel m_onboardStatusTempValLabelField;
    private SrClientLabel m_onboardWarningAndCriticalTempLabelField;
    private SrClientLabel m_cpuTempUnitsLabelField;
    private SrClientLabel m_onboardTempUnitsLabelField;
    private final String WORKING_POWER_SUPPLIERS_STR = "Working Power Supplies:";
    private final String WORKING_FANS_STR = "Working FANs:";
    private final String OUT_OF_STR = "out of ";
    private final String CPU_TEMPERATURE_STR = "CPU Temperature";
    private final String ONBOARD_TEMPERATURE_STR = "Onboard Temperature";
    private final String CURRENT_TEMPERATURE_STR = "Current:";
    private final String STATUS_TEMPERATURE_STR = "Status:";
    private final String WARNING_TEMPERATURE_STR = "Warning Thresh:";
    private final String CRITICAL_TEMPERATURE_STR = "Critical Thresh:";
    private final String CLOSE_STR = "Close";

    public VSwitchHardwareDataDialog(JFrame owner, VSwitchNode vSwitchNode) {
        super(owner, ClientLoader.VSWITCH_DISPLAY_STRING + " Hardware Status - " + vSwitchNode.getName(), SystemRootNode.getInstance().getClusterNodeOfSource(vSwitchNode));
        this.m_vSwitchNode = vSwitchNode;
        this.m_hardwareData = this.m_vSwitchNode.getHardwareData();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VSwitchHardwareDataDialog.this.m_vSwitchNode.setUserObject(null);
            }
        });
        HardwareManager.getInstance().addHardwareListener(this);
        VSwitchManager.getInstance().addVSwitchListener(this);
        this.initComponents();
        this.setResizable(true);
    }

    protected void initComponents() {
        this.setBackgroungColor(this.buttonsPanel);
        SrPanel centeredPanel = this.createCenteredPanel();
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        mainPanel.add((Component)centeredPanel, "Center");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
    }

    @Override
    protected void setCancelButtonText() {
        this.btnCancel.setText("Close");
    }

    private SrPanel createCenteredPanel() {
        this.initGuiFields();
        this.setSizesOfComponents();
        this.setCancelButtonText();
        this.btnOK.setVisible(false);
        SrPanel centeredPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.15;
        c.weightx = 0.2;
        c.anchor = 21;
        c.insets = new Insets(10, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        centeredPanel.add((Component)this.m_powerSuppliersLabelField, c);
        c.gridx = 0;
        c.gridy = 1;
        centeredPanel.add((Component)this.m_fansLabelField, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = new Insets(35, 0, 0, 0);
        centeredPanel.add((Component)this.m_cpuTempLabelField, c);
        c.gridx = 1;
        c.gridy = 2;
        centeredPanel.add((Component)this.m_cpuTempUnitsLabelField, c);
        c.gridx = 0;
        c.gridy = 4;
        centeredPanel.add((Component)this.m_onboardTempLabelField, c);
        c.gridx = 1;
        c.gridy = 4;
        centeredPanel.add((Component)this.m_onboardTempUnitsLabelField, c);
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(10, 10, 0, 0);
        centeredPanel.add((Component)this.m_powerSuppliersCurrentWorkingValLabelField, c);
        c.gridx = 2;
        c.gridy = 1;
        centeredPanel.add((Component)this.m_fansCurrentWorkingValLabelField, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 10;
        centeredPanel.add((Component)this.m_powerSuppliersMaxNumberValLabelField, c);
        c.gridx = 2;
        c.gridy = 1;
        centeredPanel.add((Component)this.m_fansMaxNumberValLabelField, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = new Insets(35, 10, 0, 0);
        c.anchor = 21;
        centeredPanel.add((Component)this.m_cpuCurrentTempLabelField, c);
        c.gridx = 3;
        c.gridy = 2;
        c.insets = new Insets(35, 0, 0, 0);
        centeredPanel.add((Component)this.m_cpuCurrentTempValLabelField, c);
        c.gridx = 4;
        c.gridy = 2;
        c.insets = new Insets(35, 10, 0, 0);
        centeredPanel.add((Component)this.m_cpuStatusTempLabelField, c);
        c.gridx = 5;
        c.gridy = 2;
        c.insets = new Insets(35, 0, 0, 0);
        centeredPanel.add((Component)this.m_cpuStatusTempValLabelField, c);
        c.gridx = 2;
        c.gridy = 4;
        c.insets = new Insets(35, 10, 0, 0);
        centeredPanel.add((Component)this.m_onboardCurrentTempLabelField, c);
        c.gridx = 3;
        c.gridy = 4;
        c.insets = new Insets(35, 0, 0, 0);
        centeredPanel.add((Component)this.m_onboardCurrentTempValLabelField, c);
        c.gridx = 4;
        c.gridy = 4;
        c.insets = new Insets(35, 10, 0, 0);
        centeredPanel.add((Component)this.m_onboardStatusTempLabelField, c);
        c.gridx = 5;
        c.gridy = 4;
        c.insets = new Insets(35, 0, 0, 0);
        centeredPanel.add((Component)this.m_onboardStatusTempValLabelField, c);
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 3;
        c.insets = new Insets(10, 10, 0, 0);
        centeredPanel.add((Component)this.m_cpuWarningAndCriticalTempLabelField, c);
        c.gridx = 2;
        c.gridy = 5;
        centeredPanel.add((Component)this.m_onboardWarningAndCriticalTempLabelField, c);
        return centeredPanel;
    }

    private void initGuiFields() {
        this.m_powerSuppliersLabelField = new SrClientLabel("Working Power Supplies:");
        this.m_powerSuppliersCurrentWorkingValLabelField = new SrClientLabel(this.m_hardwareData.getCurrNumOfWorkingPowerSuppliers().toString());
        String labelStr = "(out of " + this.m_hardwareData.getMaxNumOfPowerSuppliers().toString() + ")";
        this.m_powerSuppliersMaxNumberValLabelField = new SrClientLabel(labelStr);
        this.m_fansLabelField = new SrClientLabel("Working FANs:");
        this.m_fansCurrentWorkingValLabelField = new SrClientLabel(this.m_hardwareData.getCurrNumOfWorkingFANs().toString());
        labelStr = "(out of " + this.m_hardwareData.getMaxNumOfFANs().toString() + ")";
        this.m_fansMaxNumberValLabelField = new SrClientLabel(labelStr);
        this.m_cpuTempUnitsLabelField = new SrClientLabel(" (" + this.m_vSwitchNode.getTempUnits().toString() + "):");
        this.m_onboardTempUnitsLabelField = new SrClientLabel(" (" + this.m_vSwitchNode.getTempUnits().toString() + "):");
        this.m_cpuTempLabelField = new SrClientLabel("CPU Temperature");
        this.m_cpuCurrentTempLabelField = new SrClientLabel("Current:");
        this.m_cpuStatusTempLabelField = new SrClientLabel("Status:");
        this.m_cpuCurrentTempValLabelField = new SrClientLabel(this.m_hardwareData.getCPUTemp().toString());
        this.m_cpuStatusTempValLabelField = new SrClientLabel(this.m_hardwareData.getCPUTempStatus());
        labelStr = "(Warning Thresh:" + this.m_hardwareData.getCPUWarningTempThresh().toString() + "          " + "Critical Thresh:" + this.m_hardwareData.getCPUFactoryTempThresh().toString() + ")";
        this.m_cpuWarningAndCriticalTempLabelField = new SrClientLabel(labelStr);
        this.m_onboardTempLabelField = new SrClientLabel("Onboard Temperature");
        this.m_onboardCurrentTempLabelField = new SrClientLabel("Current:");
        this.m_onboardStatusTempLabelField = new SrClientLabel("Status:");
        this.m_onboardCurrentTempValLabelField = new SrClientLabel(this.m_hardwareData.getOnboardTemp().toString());
        this.m_onboardStatusTempValLabelField = new SrClientLabel(this.m_hardwareData.getOnboardTempStatus());
        labelStr = "(Warning Thresh:" + this.m_hardwareData.getOnboardWarningTempThresh().toString() + "          " + "Critical Thresh:" + this.m_hardwareData.getOnboardFactoryTempThresh().toString() + ")";
        this.m_onboardWarningAndCriticalTempLabelField = new SrClientLabel(labelStr);
        this.m_powerSuppliersLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_powerSuppliersCurrentWorkingValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_powerSuppliersMaxNumberValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_fansLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_fansCurrentWorkingValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_fansMaxNumberValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_cpuTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_cpuCurrentTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_cpuStatusTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_cpuCurrentTempValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_cpuStatusTempValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_cpuWarningAndCriticalTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_onboardTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_onboardCurrentTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_onboardStatusTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_onboardCurrentTempValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_onboardStatusTempValLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_onboardWarningAndCriticalTempLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_cpuTempUnitsLabelField.setFont(LookAndFill.GENERAL_FONT);
        this.m_onboardTempUnitsLabelField.setFont(LookAndFill.GENERAL_FONT);
    }

    private void setSizesOfComponents() {
    }

    protected SrPanel createSrPanel(int rightIdent, JComponent c1, JComponent c2) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0, rightIdent, 0));
        panel.add(c1);
        if (c2 != null) {
            panel.add(c2);
        }
        return panel;
    }

    @Override
    protected void doOnOK() {
    }

    @Override
    public void doOnCancel() {
        this.m_vSwitchNode.setUserObject(null);
        super.dispose();
    }

    @Override
    public void hardwareDataChanged(HardwareDataEvent e) {
        HardwareData hardwareData = e.getHardwareData();
        if (!((Hardware)this.m_hardwareData.getStub()).equals(hardwareData.getStub())) {
            return;
        }
        this.updatePowerSuppliersData(hardwareData);
        this.updateFANsData(hardwareData);
        this.updateCPUTemperatureData(hardwareData);
        this.updateOnBoardTemperatureData(hardwareData);
        this.repaint();
    }

    private void updatePowerSuppliersData(HardwareData hardwareData) {
        Integer updatedNumOfWorkingPowerSuppliers;
        String currentMaxNumOfPowerSuppliersInLabel;
        String currentMaxNumOfPowerSuppliersVal;
        Integer updatedMaxNumOfPowerSuppliers = hardwareData.getMaxNumOfPowerSuppliers();
        if (updatedMaxNumOfPowerSuppliers != null && !(currentMaxNumOfPowerSuppliersVal = (currentMaxNumOfPowerSuppliersInLabel = this.m_powerSuppliersMaxNumberValLabelField.getValue().toString()).substring(currentMaxNumOfPowerSuppliersInLabel.lastIndexOf(" ") + 1, currentMaxNumOfPowerSuppliersInLabel.length() - 2)).equals(updatedMaxNumOfPowerSuppliers.toString())) {
            String labelStr = "(out of " + this.m_hardwareData.getMaxNumOfPowerSuppliers().toString() + ")";
            this.m_powerSuppliersMaxNumberValLabelField.setText(labelStr);
            this.packAndSetTitle();
        }
        if ((updatedNumOfWorkingPowerSuppliers = hardwareData.getCurrNumOfWorkingPowerSuppliers()) != null && !this.m_powerSuppliersCurrentWorkingValLabelField.getValue().equals(updatedNumOfWorkingPowerSuppliers.toString())) {
            this.m_powerSuppliersCurrentWorkingValLabelField.setText(updatedNumOfWorkingPowerSuppliers.toString());
            this.packAndSetTitle();
        }
    }

    private void updateFANsData(HardwareData hardwareData) {
        Integer updatedNumOfWorkingFANs;
        String currentMaxNumOfFANsInLabel;
        String currentMaxNumOfFANsVal;
        Integer updatedMaxNumOfFANs = hardwareData.getMaxNumOfFANs();
        if (updatedMaxNumOfFANs != null && !(currentMaxNumOfFANsVal = (currentMaxNumOfFANsInLabel = this.m_fansMaxNumberValLabelField.getValue().toString()).substring(currentMaxNumOfFANsInLabel.lastIndexOf(" ") + 1, currentMaxNumOfFANsInLabel.length() - 2)).equals(updatedMaxNumOfFANs.toString())) {
            String labelStr = "(out of " + this.m_hardwareData.getMaxNumOfFANs().toString() + ")";
            this.m_fansMaxNumberValLabelField.setText(labelStr);
            this.packAndSetTitle();
        }
        if ((updatedNumOfWorkingFANs = hardwareData.getCurrNumOfWorkingFANs()) != null && !this.m_fansCurrentWorkingValLabelField.getValue().equals(updatedNumOfWorkingFANs.toString())) {
            this.m_fansCurrentWorkingValLabelField.setText(updatedNumOfWorkingFANs.toString());
            this.packAndSetTitle();
        }
    }

    private void updateCPUTemperatureData(HardwareData hardwareData) {
        String updatedCPUTemperatureStatus;
        Integer updatedCPUTemperature = hardwareData.getCPUTemp();
        if (updatedCPUTemperature != null && !this.m_cpuCurrentTempValLabelField.getValue().equals(updatedCPUTemperature.toString())) {
            this.m_cpuCurrentTempValLabelField.setText(updatedCPUTemperature.toString());
            this.packAndSetTitle();
        }
        if ((updatedCPUTemperatureStatus = this.m_hardwareData.getCPUTempStatus()) != null && !this.m_cpuStatusTempValLabelField.getValue().equals(updatedCPUTemperatureStatus)) {
            this.m_cpuStatusTempValLabelField.setText(updatedCPUTemperatureStatus);
            this.packAndSetTitle();
        }
    }

    private void updateOnBoardTemperatureData(HardwareData hardwareData) {
        String updatedOnboardTemperatureStatus;
        Integer updatedOnboardTemperature = hardwareData.getOnboardTemp();
        if (updatedOnboardTemperature != null && !this.m_onboardCurrentTempValLabelField.getValue().equals(updatedOnboardTemperature.toString())) {
            this.m_onboardCurrentTempValLabelField.setText(updatedOnboardTemperature.toString());
            this.packAndSetTitle();
        }
        if ((updatedOnboardTemperatureStatus = this.m_hardwareData.getOnboardTempStatus()) != null && !this.m_onboardStatusTempValLabelField.getValue().equals(updatedOnboardTemperatureStatus)) {
            this.m_onboardStatusTempValLabelField.setText(updatedOnboardTemperatureStatus);
            this.packAndSetTitle();
        }
    }

    @Override
    public void dispose() {
        HardwareManager.getInstance().removeHardwareListener(this);
        super.dispose();
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        VSwitchNode node;
        TempetureUnitConstant tu;
        RemoteObject stub = e.getStub();
        SrTreeNode vs = SystemRootNode.getInstance().getRefByStub(stub);
        if (vs != null && (tu = (node = (VSwitchNode)vs).getTempUnits()) != null) {
            this.m_cpuTempUnitsLabelField.setText(" (" + tu.toString() + "):");
            this.m_onboardTempUnitsLabelField.setText(" (" + tu.toString() + "):");
            this.packAndSetTitle();
        }
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    private void packAndSetTitle() {
        String title = this.getTitle();
        this.pack();
        SrSwingUtils.setWindowMinimumWidthByTitleNotInvokeLater(this, title);
    }
}

