/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.target.TargetAdapter;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.target.SrAttachTargetWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.target.TargetWizardContextKeys;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.text.LengthLimitedDocument;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;

public class SrNewTargetWizardPanel
extends SrDRWizardPanel
implements PropertyPanelValidationListener {
    private SrPropertyPanel m_prop;
    private static SrLogger theLogger = SrLogger.getLogger();
    private ClusterNode m_cluster;
    private SrAttachTargetWizardPanel m_attachedPanel;
    private CreateTargetTransaction m_createTargetTransaction = new CreateTargetTransaction();
    private TargetCreationListener myTargetListener = new TargetCreationListener();

    public SrNewTargetWizardPanel(SrAttachTargetWizardPanel attachedPanel) {
        this.m_attachedPanel = attachedPanel;
        this.m_cluster = attachedPanel.getCluster();
        this.setSavedAsPrevious(false);
        this.initComponents();
        this.addWizardTransaction(this.m_createTargetTransaction);
    }

    private void initComponents() {
        SrClientLabel descLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_PANEL_DESC));
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 10, 20, 40);
        constraints.fill = 1;
        descriptionPanel.add((Component)descLabel, constraints);
        this.add((Component)descriptionPanel, "North");
        this.m_prop = new SrPropertyPanel(this.getClass().toString(), false, true, false);
        this.m_prop.addValidationListener(this);
        Permission[] permissions = new Permission[]{Permission.N_A, Permission.READ_ONLY, Permission.READ_WRITE};
        SrComboBox<Permission> accessCombo = new SrComboBox<Permission>((T[])permissions);
        accessCombo.setSelectedItem(Permission.READ_WRITE);
        Vector<VSwitchNode> vs = VSwitchManager.getInstance().getAvailableVSwitches(this.m_cluster);
        SrComboBox<VSwitchNode> vswitchesCombo = new SrComboBox<VSwitchNode>((List<VSwitchNode>)vs);
        this.m_prop.skipLines(1);
        String maxAliasLength = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.ALIAS_MAX_LENGTH);
        LengthLimitedDocument aliasDoc = new LengthLimitedDocument(Integer.parseInt(maxAliasLength));
        SrTextField aliasTextField = new SrTextField();
        aliasTextField.setDocument(aliasDoc);
        this.m_prop.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_TARGET_ALIAS_DESC), (SrComponent)aliasTextField);
        this.m_prop.skipLines(1);
        this.m_prop.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_TARGET_NAME), (SrComponent)new SrTextField());
        this.m_prop.skipLines(1);
        this.m_prop.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_VSWITCH_EXPOSED_ON), vswitchesCombo);
        this.m_prop.skipLines(1);
        this.m_prop.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_DEFAULT_ACCESS), accessCombo);
        this.add((Component)this.m_prop, "Center");
    }

    @Override
    public void display() {
        VSwitchNode forcedVswitch;
        TargetManager.getInstance().addTargetListener(this.myTargetListener);
        this.m_prop.onUpdateEvent(null);
        String forcedTargetName = (String)this.wizardContext.getAttribute(TargetWizardContextKeys.PREDEFINED_TARGET_NAME);
        if (forcedTargetName != null) {
            String targetNameKey = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_TARGET_NAME);
            this.m_prop.setPropertyValue(targetNameKey, forcedTargetName);
            this.m_prop.getProperty(targetNameKey).setEnableComponent(false);
        }
        if ((forcedVswitch = (VSwitchNode)this.wizardContext.getAttribute(TargetWizardContextKeys.PREDEFINED_EXPOSED_ON_VSWITCH)) != null) {
            String vsComboKey = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_VSWITCH_EXPOSED_ON);
            this.m_prop.setPropertyValue(vsComboKey, forcedVswitch);
            this.m_prop.getProperty(vsComboKey).setEnableComponent(false);
        }
    }

    @Override
    public WizardPanel next() {
        return this.m_attachedPanel;
    }

    @Override
    public boolean validateNext(List list) {
        boolean valid = true;
        String targetNameKey = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_TARGET_NAME);
        String tName = (String)this.m_prop.getPropertyVal(targetNameKey);
        if (!TargetManager.getInstance().isTargetNameLegal(tName, null)) {
            String targetNameNotValidMsg1 = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_TARGET_NAME_NOT_VALID_MSG_LINE1);
            String targetNameNotValidMsg2 = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_TARGET_NAME_NOT_VALID_MSG_LINE2);
            String targetNameNotValidMsg3 = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_TARGET_NAME_NOT_VALID_MSG_LINE3);
            list.add(targetNameNotValidMsg1);
            list.add(targetNameNotValidMsg2);
            list.add(targetNameNotValidMsg3);
            valid = false;
            this.m_prop.startCurserAt(targetNameKey);
        }
        return valid;
    }

    @Override
    public void onPanelPropertyChanged(PropertyPanelValidationEvent e) {
        Vector nonValidFields = e.getNonValidFields();
        this.setNextButtonEnabled(nonValidFields.isEmpty());
    }

    @Override
    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this.myTargetListener);
    }

    @Override
    public void back() {
        this.wizardContext.setAttribute(TargetWizardContextKeys.NEW_TARGET, null, this);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : (String)this.wizardContext.getAttribute(TargetWizardContextKeys.NEW_TARGET_PANEL_DESCRIPTION);
    }

    private class TargetCreationListener
    extends TargetAdapter {
        private TargetCreationListener() {
        }

        @Override
        public void newTargetCreate(TargetEvent e) {
            String targetName = (String)SrNewTargetWizardPanel.this.m_prop.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_TARGET_NAME));
            TargetNode newTargetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
            if (newTargetNode.getName().equals(targetName)) {
                SrNewTargetWizardPanel.this.wizardContext.setAttribute(TargetWizardContextKeys.NEW_TARGET, newTargetNode, SrNewTargetWizardPanel.this);
            }
        }
    }

    private class CreateTargetTransaction
    extends WizardTransaction {
        private CreateTargetTransaction() {
        }

        @Override
        protected void transaction() {
            String targetAlias = (String)SrNewTargetWizardPanel.this.m_prop.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_TARGET_ALIAS_DESC));
            String targetName = (String)SrNewTargetWizardPanel.this.m_prop.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_TARGET_NAME));
            Permission defaultAccess = (Permission)SrNewTargetWizardPanel.this.m_prop.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_DEFAULT_ACCESS));
            VSwitchNode selectedVswitch = (VSwitchNode)SrNewTargetWizardPanel.this.m_prop.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NEW_TARGET_KEY_VSWITCH_EXPOSED_ON));
            SrFuture<Void> actFuture = TargetManager.getInstance().createISCSITarget(targetName, targetAlias, selectedVswitch.toString(), defaultAccess, (ClusterNode)selectedVswitch.getParent());
            this.waitAndBlockActions(actFuture, SrNewTargetWizardPanel.this.getOwner());
            if (SrNewTargetWizardPanel.this.wizardContext.getAttribute(TargetWizardContextKeys.NEW_TARGET) == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Target wizard: creation future returned before target data");
            }
        }
    }
}

