/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.target.SrNewTargetWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.target.TargetWizardContextKeys;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class SrAttachTargetWizardPanel
extends SrDRWizardPanel
implements PropertyPanelValidationListener,
TargetListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrComboBox m_targetListCombo;
    private SrTextField m_targetNameField;
    private SrTextField m_exposedOnVswitchField;
    private SrIntegerTextField m_lunField;
    private SrButton m_newTargetBtt;
    private TargetPropertyPanel m_prop;
    private SrWizardPanel m_createTargetStep;
    private boolean m_isCreateTargetStep = false;
    protected ClusterNode m_cluster;
    private VolumeTreeNode m_vol;
    private String m_panelTitle;
    private DRRoleConstant m_drRole;
    private LUNode m_createdLUNode;
    private ExposeVolumeTransaction m_exposeVolumeTransaction = new ExposeVolumeTransaction();
    private LUCreationListener myLUListener = new LUCreationListener();

    public SrAttachTargetWizardPanel(VolumeTreeNode vol, DRRoleConstant drRole, String panelTitle) {
        this.m_vol = vol;
        if (this.m_vol != null) {
            this.m_cluster = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_vol);
        }
        this.m_drRole = drRole;
        this.m_panelTitle = panelTitle;
        this.initComponents();
    }

    ClusterNode getCluster() {
        return this.m_cluster;
    }

    private void initComponents() {
        SrPanel mainPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(20, 10, 0, 0);
        constraints.fill = 1;
        SrClientLabel descLabel = new SrClientLabel(this.m_panelTitle);
        mainPanel.add((Component)descLabel, constraints);
        this.m_prop = new TargetPropertyPanel();
        this.m_prop.addValidationListener(this);
        constraints.gridy = 1;
        mainPanel.add((Component)this.m_prop, constraints);
        this.m_newTargetBtt = new SrButton(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_TARGET_NEW_TARGET_BUTTON));
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.insets.left = 27;
        mainPanel.add((Component)this.m_newTargetBtt, constraints);
        this.add((Component)mainPanel, "Center");
    }

    @Override
    public void display() {
        String forcedTargetName;
        LUManager.getInstance().addLUListener(this.myLUListener);
        this.m_isCreateTargetStep = false;
        SrClientAction<Void, Void> newTargetAction = new SrClientAction<Void, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_TARGET_NEW_TARGET_BUTTON), null, true, true, null, SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                SrAttachTargetWizardPanel.this.m_isCreateTargetStep = true;
                SrAttachTargetWizardPanel.this.removeWizardTransaction(SrAttachTargetWizardPanel.this.m_exposeVolumeTransaction);
                SrAttachTargetWizardPanel.this.m_createTargetStep = new SrNewTargetWizardPanel(SrAttachTargetWizardPanel.this);
                SrAttachTargetWizardPanel.this.fireNextButtonAction();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                if (SrAttachTargetWizardPanel.this.m_vol != null && SrAttachTargetWizardPanel.this.m_vol.isExposed() && SrAttachTargetWizardPanel.this.m_vol.getLUNode() != null) {
                    return "The volume " + SrAttachTargetWizardPanel.this.m_vol + " is exposed on " + SrAttachTargetWizardPanel.this.m_vol.getLUNode();
                }
                String predefinedTargetName = SrAttachTargetWizardPanel.this.getPredefinedTargetName();
                if (predefinedTargetName != null) {
                    return "The volume " + SrAttachTargetWizardPanel.this.m_vol + " has predefined target name " + predefinedTargetName;
                }
                return null;
            }
        };
        this.m_newTargetBtt.setAction(newTargetAction);
        TargetManager.getInstance().addTargetListener(this);
        this.m_targetListCombo.removeAllItems();
        ArrayList targetList = this.getTargetList(this.wizardContext);
        int i = targetList.size();
        while (i-- > 0) {
            this.m_targetListCombo.addItem(targetList.get(i));
        }
        TargetNode newTarget = (TargetNode)this.wizardContext.getAttribute(TargetWizardContextKeys.NEW_TARGET);
        this.wizardContext.setAttribute(TargetWizardContextKeys.NEW_TARGET, null, this);
        if (newTarget != null) {
            if (!targetList.contains(newTarget)) {
                targetList.add(newTarget);
                this.m_targetListCombo.addItem(newTarget);
            }
            this.m_targetListCombo.setSelectedItem(newTarget);
        }
        if (this.m_vol != null) {
            if (!this.m_vol.isExposed()) {
                this.addExposeVolumeTransaction();
            } else if (this.m_vol.getLUNode() != null) {
                this.m_createdLUNode = this.m_vol.getLUNode();
                LUNode luNode = this.m_vol.getLUNode();
                if (luNode != null) {
                    this.m_targetListCombo.setSelectedItem(luNode.getTargetParent());
                    this.m_targetListCombo.setEnabled(false);
                    this.m_targetNameField.setEnabled(false);
                    this.m_lunField.setText(luNode.getLUN().toString());
                    this.m_lunField.setEnabled(false);
                }
            }
        }
        if ((forcedTargetName = this.getPredefinedTargetName()) != null) {
            TargetNode forcedTarget = null;
            int i2 = targetList.size();
            while (i2-- > 0) {
                if (!((TargetNode)targetList.get(i2)).getName().equals(forcedTargetName)) continue;
                forcedTarget = (TargetNode)targetList.get(i2);
            }
            this.m_targetListCombo.setSelectedItem(forcedTarget);
            this.m_targetListCombo.setEnabled(false);
        }
        if (this.wizardContext.getAttribute(TargetWizardContextKeys.PREDEFINED_LUN) != null) {
            this.m_lunField.setText(this.wizardContext.getAttribute(TargetWizardContextKeys.PREDEFINED_LUN).toString());
            this.m_lunField.setEnabled(false);
        }
    }

    private String getPredefinedTargetName() {
        return (String)this.wizardContext.getAttribute(TargetWizardContextKeys.PREDEFINED_TARGET_NAME);
    }

    protected void addExposeVolumeTransaction() {
        this.addWizardTransaction(this.m_exposeVolumeTransaction);
    }

    public ArrayList getTargetList(WizardContext ctxt) {
        ArrayList<TargetNode> targetList = new ArrayList<TargetNode>();
        Enumeration<TreeNode> e = this.m_cluster.getExposedVolumesNode().children();
        while (e.hasMoreElements()) {
            boolean addToList = true;
            TargetNode target = (TargetNode)e.nextElement();
            for (LUNode luNode : target.getLuNodes()) {
                VolumeTreeNode luVolume = luNode.getVolumeChild();
                DRASyncPairManager.getInstance();
                DRPairNode pair = DRASyncPairManager.getPairContainingVolume(luVolume);
                if (pair == null) continue;
                VolumeTreeNode pairVolume = null;
                pairVolume = DRRoleConstant.LOCAL.equals(this.m_drRole) ? pair.getPairPrimaryVolume() : pair.getPairSecondaryVolume();
                if (pairVolume == luVolume) continue;
                addToList = false;
                break;
            }
            if (!addToList) continue;
            targetList.add(target);
        }
        String forcedTargetName = (String)ctxt.getAttribute(TargetWizardContextKeys.PREDEFINED_TARGET_NAME);
        if (forcedTargetName != null) {
            TargetNode forcedTarget = this.getTargetByName(targetList, forcedTargetName);
            targetList.clear();
            if (forcedTarget != null) {
                targetList.add(forcedTarget);
            }
            return targetList;
        }
        VSwitchNode vsNode = (VSwitchNode)ctxt.getAttribute(TargetWizardContextKeys.PREDEFINED_EXPOSED_ON_VSWITCH);
        if (vsNode != null) {
            Iterator i = targetList.iterator();
            while (i.hasNext()) {
                TargetNode target = (TargetNode)i.next();
                if (target.getExposedOnVSwitchName().equals(vsNode.getName())) continue;
                i.remove();
            }
        }
        return targetList;
    }

    private TargetNode getTargetByName(ArrayList targetList, String targetName) {
        int i = targetList.size();
        while (i-- > 0) {
            TargetNode target = (TargetNode)targetList.get(i);
            if (!target.getName().equals(targetName)) continue;
            return target;
        }
        return null;
    }

    @Override
    public String getConfirmMessage() {
        TargetNode selectedTarget;
        int luCount;
        if (this.m_createTargetStep == null && ((luCount = (selectedTarget = (TargetNode)this.m_targetListCombo.getSelectedItem()).getLuCount()) > 1 || luCount == 1 && this.m_vol.getLUNode() == null)) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_NOT_EMPTY_TARGET_WARNING_MSG);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.m_prop.getNonValidMandatoryFields().isEmpty();
    }

    @Override
    public WizardPanel next() {
        SrWizardPanel nextStep = null;
        if (this.m_createTargetStep != null) {
            this.wizardContext.setAttribute(TargetWizardContextKeys.SELECTED_TARGET, null, this);
            this.wizardContext.setAttribute(TargetWizardContextKeys.SELECTED_LUN, null, this);
            nextStep = this.m_createTargetStep;
            this.m_createTargetStep = null;
        } else {
            this.wizardContext.setAttribute(TargetWizardContextKeys.SELECTED_TARGET, this.m_targetListCombo.getSelectedItem(), this);
            this.wizardContext.setAttribute(TargetWizardContextKeys.SELECTED_LUN, this.m_createdLUNode, this);
            nextStep = (SrWizardPanel)this.wizardContext.getAttribute(TargetWizardContextKeys.NEXT_OUTER_WIZARD_PANEL);
            TargetManager.getInstance().removeTargetListener(this);
            this.m_prop.removeValidationListener(this);
        }
        return nextStep;
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public void onPanelPropertyChanged(PropertyPanelValidationEvent e) {
        Vector nonValidFields = e.getNonValidFields();
        this.setNextButtonEnabled(nonValidFields.isEmpty());
    }

    @Override
    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this);
        LUManager.getInstance().removeLUListener(this.myLUListener);
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
        TargetNode target;
        ArrayList targetList;
        if (!this.m_vol.isExposed() && (targetList = this.getTargetList(this.wizardContext)).contains(target = (TargetNode)SystemRootNode.getInstance().getRefByStub(e.getStub()))) {
            this.m_targetListCombo.addItem(target);
        }
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
        TargetNode t = (TargetNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.refreshTargetComboBox(t);
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
        TargetNode t = (TargetNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.refreshTargetComboBox(t);
    }

    @Override
    public void targetRemove(TargetEvent e) {
        TargetNode t = (TargetNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.m_targetListCombo.removeItem(t);
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
        TargetNode t = (TargetNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.refreshTargetComboBox(t);
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
        TargetNode t = (TargetNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.refreshTargetComboBox(t);
    }

    private void refreshTargetComboBox(TargetNode t) {
        ArrayList newTargetList = this.getTargetList(this.wizardContext);
        boolean isLegalTarget = newTargetList.contains(t);
        int index = this.m_targetListCombo.indexOf(t);
        if (index < 0 && isLegalTarget) {
            this.m_targetListCombo.addItem(t);
        } else if (index >= 0 && !isLegalTarget) {
            this.m_targetListCombo.removeItemAt(index);
        } else if (index >= 0 && isLegalTarget) {
            this.m_targetListCombo.refreshItem(t);
        }
    }

    @Override
    public void back() {
        this.wizardContext.setAttribute(TargetWizardContextKeys.SELECTED_TARGET, null, this);
        this.wizardContext.setAttribute(TargetWizardContextKeys.SELECTED_LUN, null, this);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : (String)this.wizardContext.getAttribute(TargetWizardContextKeys.EXPOSE_PANEL_DESCRIPTION);
    }

    private class LUCreationListener
    implements LUListener {
        private LUCreationListener() {
        }

        @Override
        public void luChanged(LUEvent event) {
        }

        @Override
        public void luCreated(LUEvent event) {
            LUNode luNode = (LUNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
            if (SrAttachTargetWizardPanel.this.m_vol.equals(luNode.getVolumeChild())) {
                SrAttachTargetWizardPanel.this.m_createdLUNode = luNode;
            }
        }

        @Override
        public void luRemoved(LUEvent event) {
        }

        @Override
        public void luStatusChanged(LUEvent event) {
        }
    }

    private class ExposeVolumeTransaction
    extends WizardTransaction {
        private ExposeVolumeTransaction() {
        }

        @Override
        protected void transaction() {
            String lun = (String)SrAttachTargetWizardPanel.this.m_prop.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_TARGET_KEY_LUN));
            TargetNode targetNode = (TargetNode)SrAttachTargetWizardPanel.this.m_targetListCombo.getSelectedItem();
            if (!SrAttachTargetWizardPanel.this.m_vol.isExposed()) {
                String luSerialNumber = (String)SrAttachTargetWizardPanel.this.wizardContext.getAttribute(TargetWizardContextKeys.PREDEFINED_LUN_SERIAL_NUMBER);
                SrFuture<Void> actFuture = VolumeManager.getInstance().exposeVolume(new Integer(lun), luSerialNumber, SrAttachTargetWizardPanel.this.m_vol, (CommKeyClassId)targetNode.getIdentifier());
                this.waitAndBlockActions(actFuture, SrAttachTargetWizardPanel.this.getOwner());
                if (SrAttachTargetWizardPanel.this.m_createdLUNode == null) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "LU wizard: creation future returned before LU data");
                }
            } else {
                this.stop();
            }
        }
    }

    public class TargetPropertyPanel
    extends SrPropertyPanel {
        public TargetPropertyPanel() {
            super(TargetPropertyPanel.class.toString(), false, true, false);
            this.skipLines(1);
            SrAttachTargetWizardPanel.this.m_targetListCombo = new SrComboBox();
            SrAttachTargetWizardPanel.this.m_targetListCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TargetNode target = (TargetNode)e.getItem();
                    if (target != null) {
                        SrAttachTargetWizardPanel.this.wizardContext.setAttribute(TargetWizardContextKeys.SELECTED_TARGET, SrAttachTargetWizardPanel.this.m_targetListCombo.getSelectedItem(), SrAttachTargetWizardPanel.this);
                        SrAttachTargetWizardPanel.this.m_targetNameField.setText(target.getName());
                        SrAttachTargetWizardPanel.this.m_exposedOnVswitchField.setText(target.getExposedOnVSwitchName());
                    }
                }
            });
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_TARGET_KEY_TARGET_ALIAS_DESC), (SrComponent)SrAttachTargetWizardPanel.this.m_targetListCombo);
            String targetName = "";
            if (SrAttachTargetWizardPanel.this.m_targetListCombo.getItemCount() > 0) {
                TargetNode target = (TargetNode)SrAttachTargetWizardPanel.this.m_targetListCombo.getItemAt(0);
                targetName = target.getName();
            }
            this.skipLines(1);
            SrAttachTargetWizardPanel.this.m_targetNameField = new SrTextField(targetName);
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_TARGET_KEY_TARGET_NAME), new SrWidget(null, SrAttachTargetWizardPanel.this.m_targetNameField, false, true, false, false, null));
            this.skipLines(1);
            SrAttachTargetWizardPanel.this.m_lunField = new SrIntegerTextField();
            SrAttachTargetWizardPanel.this.m_lunField.setMaxValue(255);
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_TARGET_KEY_LUN), (SrComponent)SrAttachTargetWizardPanel.this.m_lunField);
            this.skipLines(1);
            SrAttachTargetWizardPanel.this.m_exposedOnVswitchField = new SrTextField();
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_TARGET_KEY_VSWITCH), new SrWidget(null, SrAttachTargetWizardPanel.this.m_exposedOnVswitchField, false, true, false, false, null));
        }
    }
}

