/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.snapshot;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalAliasAndVSwitchWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SnapshotWizardContextKeys;
import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrPercentTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;

public class SrSnapshotParamsWizardPanel
extends SrDRWizardPanel
implements PropertyPanelValidationListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private VolumeTreeNode m_childVolume;
    protected VolumeTreeNode m_snapSource;
    protected SnapshotVolumeNode m_createdSnapshot;
    private SnapshotPropertyPanel m_propPanel;
    private SrTextField m_snapAliasField;
    private SrPercentTextField m_thresholdField;
    private CreateSnapshotTransaction m_createSnapshotTransaction = new CreateSnapshotTransaction();
    private SnapshotCreationListener mySnapshotListener = new SnapshotCreationListener();

    public SrSnapshotParamsWizardPanel(VolumeTreeNode childVolume, VolumeTreeNode snapSource) {
        this.m_childVolume = childVolume;
        this.m_snapSource = snapSource;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescriptionPanel(), "North");
        this.m_propPanel = new SnapshotPropertyPanel(this);
        this.add((Component)this.m_propPanel, "Center");
    }

    public SrPanel getDescriptionPanel() {
        SrClientLabel descLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_SNAPSHOT_PANEL_INSTRUCTION));
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 5, 0, 40);
        constraints.fill = 1;
        descriptionPanel.add((Component)descLabel, constraints);
        return descriptionPanel;
    }

    @Override
    public void display() {
        this.removeWizardTransaction(this.m_createSnapshotTransaction);
        Boolean isCreateSnapshotAllowed = (Boolean)this.wizardContext.getAttribute(SnapshotWizardContextKeys.IS_CREATE_SNAPSHOT_TRANSACTION);
        if ((isCreateSnapshotAllowed == null || isCreateSnapshotAllowed.booleanValue()) && this.m_snapSource != null) {
            VolumeManager.getInstance().addVolumeListener(this.mySnapshotListener);
            this.addWizardTransaction(this.m_createSnapshotTransaction);
        }
        this.m_propPanel.onUpdateEvent(null);
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public WizardPanel next() {
        this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT, this.m_createdSnapshot, this);
        this.wizardContext.setAttribute(SnapshotWizardContextKeys.ALIAS, this.m_snapAliasField.getText(), this);
        this.wizardContext.setAttribute(SnapshotWizardContextKeys.THRESHOLD, new Integer(this.m_thresholdField.getPercentage()), this);
        this.wizardContext.setAttribute(SnapshotWizardContextKeys.CHILD_VOLUME, this.m_childVolume, this);
        this.wizardContext.setAttribute(SnapshotWizardContextKeys.SOURCE_VOLUME, this.m_snapSource, this);
        WizardPanel nextPanel = (WizardPanel)this.wizardContext.getAttribute(SnapshotWizardContextKeys.NEXT_OUTER_WIZARD_PANEL);
        return nextPanel;
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this.mySnapshotListener);
    }

    @Override
    public void back() {
        this.removeListeners();
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : (String)this.wizardContext.getAttribute(SnapshotWizardContextKeys.PARAMS_DESCRIPTION);
    }

    @Override
    public void onPanelPropertyChanged(PropertyPanelValidationEvent e) {
        Vector fields = e.getNonValidFields();
        boolean allowNext = false;
        if (fields.isEmpty()) {
            allowNext = true;
        }
        this.setApplyButtonEnabled(allowNext);
    }

    public class SnapshotPropertyPanel
    extends SrPropertyPanel {
        private SrSnapshotParamsWizardPanel m_parent;

        public SnapshotPropertyPanel(SrSnapshotParamsWizardPanel parent) {
            super(SrJournalAliasAndVSwitchWizardPanel.class.toString(), false, true, false);
            this.m_parent = parent;
            this.skipLines(2);
            SrSnapshotParamsWizardPanel.this.m_snapAliasField = new SrTextField();
            if (SrSnapshotParamsWizardPanel.this.m_snapSource != null) {
                this.setDefaultSnapshotAlias();
            }
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_SNAPSHOT_PANEL_ALIAS_KEY), (SrComponent)SrSnapshotParamsWizardPanel.this.m_snapAliasField);
            this.skipLines(1);
            SrSnapshotParamsWizardPanel.this.m_thresholdField = new SrPercentTextField();
            SrSnapshotParamsWizardPanel.this.m_thresholdField.setValue(Integer.toString(VolumeManager.SNAPSHOT_DEFAULT_THRESHOLD_VALUE));
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_SNAPSHOT_PANEL_THRESHOLD_KEY), (SrComponent)SrSnapshotParamsWizardPanel.this.m_thresholdField);
            this.addValidationListener(this.m_parent);
        }

        private void setDefaultSnapshotAlias() {
            SrSnapshotParamsWizardPanel.this.m_snapAliasField.setText(VolumeManager.getInstance().getDefaultSnapshotAlias(SrSnapshotParamsWizardPanel.this.m_snapSource));
        }
    }

    private class CreateSnapshotTransaction
    extends WizardTransaction {
        private CreateSnapshotTransaction() {
        }

        @Override
        protected void transaction() {
            Vector<VolumeTreeNode> children = new Vector<VolumeTreeNode>(1);
            children.addElement(SrSnapshotParamsWizardPanel.this.m_childVolume);
            String alias = SrSnapshotParamsWizardPanel.this.m_snapAliasField.getText();
            int threshold = SrSnapshotParamsWizardPanel.this.m_thresholdField.getPercentage();
            SrFuture<Void> actFuture = VolumeManager.getInstance().createSnapshotVolume(alias, SrSnapshotParamsWizardPanel.this.m_snapSource, children, threshold);
            this.waitAndBlockActions(actFuture, SrSnapshotParamsWizardPanel.this.getOwner());
            if (SrSnapshotParamsWizardPanel.this.m_createdSnapshot == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Snapshot wizard: creation future returned before snapshot data");
            }
        }
    }

    private class SnapshotCreationListener
    extends VolumeAdapter {
        private SnapshotCreationListener() {
        }

        @Override
        public void volumeCreate(VolumeEvent e) {
            SnapshotVolumeNode snapNode;
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(e.getStub());
            if (node != null && node instanceof SnapshotVolumeNode && SrSnapshotParamsWizardPanel.this.m_snapSource.equals((snapNode = (SnapshotVolumeNode)node).getSourceVolume())) {
                SrSnapshotParamsWizardPanel.this.m_createdSnapshot = snapNode;
            }
        }
    }
}

