/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.snapshot;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectResourceWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SnapshotWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SnapshotWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SrSnapshotCreateVolumeChildWizardPanel;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;

public class SrSelectSnapshotWizardPanel
extends SrSelectResourceWizardPanel {
    private VolumeTreeNode m_snapshotSource;

    public SrSelectSnapshotWizardPanel(ClusterNode cluster, VolumeTreeNode snapshotSource) {
        super(cluster);
        this.m_snapshotSource = snapshotSource;
    }

    @Override
    protected WizardPanel doNext() {
        VolumeTreeNode snapshot = this.getSelectedVolume();
        this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT, snapshot, this);
        return (WizardPanel)this.wizardContext.getAttribute(SnapshotWizardContextKeys.NEXT_OUTER_WIZARD_PANEL);
    }

    @Override
    public void display() {
        super.display();
        Boolean isBackButtonVisible = (Boolean)this.wizardContext.getAttribute(SnapshotWizardContextKeys.IS_BACK_BUTTON_VISIBLE);
        if (isBackButtonVisible != null) {
            this.setButtonVisible("BACK_I18N", isBackButtonVisible);
        }
    }

    @Override
    protected String getCreateVolumeButtonString() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_CREATE_SNAPSHOT_BUTTON_DESC);
    }

    @Override
    protected SrWizardPanel getCreateVolumePanel() {
        SrSnapshotCreateVolumeChildWizardPanel panel = new SrSnapshotCreateVolumeChildWizardPanel(this.m_clusterNode, this.m_snapshotSource);
        panel.setDescription((String)this.wizardContext.getAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_DESCRIPTION));
        return panel;
    }

    @Override
    public SrResourceTableModel getResourceTableModel(ClusterNode cluster, WizardContext context) {
        return new SrSnapshotResourceTableModel(cluster, this.m_snapshotSource);
    }

    @Override
    protected String getPanelTitleDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_CREATE_SNAPSHOT_PANEL_TITLE);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : (String)this.wizardContext.getAttribute(SnapshotWizardContextKeys.SELECT_SNAPSHOT_DESCRIPTION);
    }

    @Override
    protected ContextKey getContextKeyForSelectedResource() {
        return SnapshotWizardContextKeys.CREATED_SNAPSHOT;
    }

    public class SrSnapshotResourceTableModel
    extends SrResourceTableModel {
        private VolumeTreeNode m_sourceNode;

        public SrSnapshotResourceTableModel(ClusterNode cluster, VolumeTreeNode sourceNode) {
            super(cluster);
            this.m_sourceNode = sourceNode;
            this.initModel();
        }

        @Override
        protected boolean generalVolumeCheck(VolumeTreeNode vol) {
            if (vol instanceof SnapshotVolumeNode) {
                SnapshotVolumeNode snapshot = (SnapshotVolumeNode)vol;
                return SnapshotWizardValidations.isValidSnapshotForPair(snapshot, this.m_sourceNode, SrSelectSnapshotWizardPanel.this.wizardContext);
            }
            return false;
        }
    }
}

