/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.snapshot;

import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.dr.wizards.DRWizardValidation;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.nms.client.gui.volume.VolumeOperationFrame;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.swing.jwf.WizardContext;
import java.math.BigInteger;

public class SnapshotWizardValidations {
    private SnapshotWizardValidations() {
    }

    public static boolean isValidSnapshotForPair(SnapshotVolumeNode snapshot, VolumeTreeNode m_sourceNode, WizardContext wizardContext) {
        if (!DRWizardValidation.isRedundant(snapshot)) {
            return false;
        }
        VolumeTreeNode secondaryVol = (VolumeTreeNode)wizardContext.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME);
        if (secondaryVol != null) {
            if (secondaryVol == snapshot) {
                return false;
            }
            Boolean isOffLineCopy = (Boolean)wizardContext.getAttribute(SrPairWizardFrame.Key.IS_OFFLINE_LOCAL_VOLUME_SELECTED);
            if (isOffLineCopy != null && isOffLineCopy.booleanValue()) {
                ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(snapshot);
                ClusterNode secOfflineVolCluster = SystemRootNode.getInstance().getClusterNodeOfSource(secondaryVol);
                if (secOfflineVolCluster == cluster && VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(snapshot, secondaryVol)) {
                    return false;
                }
            }
        }
        return snapshot.getSourceVolume() == m_sourceNode && !snapshot.isActivated() && !VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(snapshot);
    }

    public static boolean isValidForSnapshotChild(VolumeTreeNode volume, VolumeTreeNode m_snapSource, WizardContext wizardContext) {
        if (volume == null) {
            return false;
        }
        if (!DRWizardValidation.isRedundant(volume)) {
            return false;
        }
        if (volume.isExposed()) {
            return false;
        }
        if (VolumeManager.getInstance().canBeOtherVolumeChild(volume) != null || volume.equals(m_snapSource)) {
            return false;
        }
        DRASyncPairManager.getInstance();
        if (DRASyncPairManager.getPairContainingVolume(volume) != null) {
            return false;
        }
        if (volume instanceof JournalVolumeNode) {
            return false;
        }
        if (volume instanceof StorageDeviceNode) {
            if (((StorageDeviceNode)volume).hasVolumeParent() || volume.isExposed()) {
                return false;
            }
            if (volume instanceof DirectAccessDeviceNode && ((DirectAccessDeviceNode)volume).hasSubdisks()) {
                return false;
            }
        }
        if (!volume.getBlockSize().equals(m_snapSource.getBlockSize())) {
            return false;
        }
        BigInteger sourceAccessibleSize = m_snapSource.getAccessibleSpace();
        if (m_snapSource instanceof DirectAccessDeviceNode) {
            sourceAccessibleSize = ((DirectAccessDeviceNode)m_snapSource).getTotalSpace();
        }
        BigInteger accessibleSize = volume.getAccessibleSpace();
        if (volume instanceof DirectAccessDeviceNode) {
            accessibleSize = ((DirectAccessDeviceNode)volume).getTotalSpace();
        }
        if (accessibleSize.multiply(VolumeOperationFrame.SNAPSHOT_LIMIT_PERCENTAGE).compareTo(sourceAccessibleSize) < 0) {
            return false;
        }
        VolumeTreeNode secOfflineVol = (VolumeTreeNode)wizardContext.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME);
        if (secOfflineVol != null && secOfflineVol.equals(volume)) {
            return false;
        }
        VolumeTreeNode secondaryVol = (VolumeTreeNode)wizardContext.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME);
        if (secondaryVol != null) {
            if (secondaryVol == volume) {
                return false;
            }
            Boolean isOffLineCopy = (Boolean)wizardContext.getAttribute(SrPairWizardFrame.Key.IS_OFFLINE_LOCAL_VOLUME_SELECTED);
            if (isOffLineCopy != null && isOffLineCopy.booleanValue()) {
                ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(volume);
                ClusterNode secOfflineVolCluster = SystemRootNode.getInstance().getClusterNodeOfSource(secondaryVol);
                if (secOfflineVolCluster == cluster && VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(volume, secondaryVol)) {
                    return false;
                }
            }
        }
        if (VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(volume)) {
            return false;
        }
        VolumeTreeNode otherSideVolume = SnapshotWizardValidations.getOtherSidePairVolumeFromPairCreationWizardContext(m_snapSource, wizardContext);
        if (otherSideVolume == null) {
            otherSideVolume = SnapshotWizardValidations.getSecondaryPairVolumeFromRecoverWizardContext(wizardContext);
        }
        if (otherSideVolume != null && volume instanceof DirectAccessDeviceNode) {
            DirectAccessDeviceNode snapChildDisk = (DirectAccessDeviceNode)volume;
            if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString().equals(snapChildDisk.getTransportType()) && SnapshotWizardValidations.isEquivalent(otherSideVolume, snapChildDisk)) {
                return false;
            }
        }
        return true;
    }

    private static VolumeTreeNode getOtherSidePairVolumeFromPairCreationWizardContext(VolumeTreeNode pairVolume, WizardContext wizardContext) {
        VolumeTreeNode secondaryVol = (VolumeTreeNode)wizardContext.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME);
        VolumeTreeNode primaryVol = (VolumeTreeNode)wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_VOLUME);
        if (pairVolume.equals(primaryVol)) {
            return secondaryVol;
        }
        if (pairVolume.equals(secondaryVol)) {
            return primaryVol;
        }
        return null;
    }

    private static VolumeTreeNode getSecondaryPairVolumeFromRecoverWizardContext(WizardContext wizardContext) {
        return (VolumeTreeNode)wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_SECONDARY_VOLUME);
    }

    private static boolean isEquivalent(VolumeTreeNode volume, DirectAccessDeviceNode iscsiDisk) {
        LUNode volLu = volume.getLUNode();
        if (volLu != null) {
            boolean isVolSNExists;
            String diskLU = iscsiDisk.getRemoteLU();
            String diskTarget = iscsiDisk.getEntityName();
            String diskSN = iscsiDisk.getSerialNumber();
            boolean isDiskSNExists = diskSN == null || diskSN.length() == 0;
            String volLU = volLu.getLUN().toString();
            String volTarget = volLu.getTargetParent().getName();
            String volSN = volLu.getSerialNumber();
            boolean bl = isVolSNExists = volSN == null || volSN.length() == 0;
            if (isDiskSNExists && isVolSNExists && !volSN.equals(diskSN)) {
                return false;
            }
            if (volLU.equals(diskLU) && volTarget.equals(diskTarget)) {
                return true;
            }
        }
        return false;
    }
}

