/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.recover;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.dr.DREvent;
import com.sanrad.nms.client.event.dr.DRListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverSelectSiteClusterVSwitchPanel;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.SrFinishWizardPanel;
import com.sanrad.swing.wizard.SrHiddenWizardPanel;
import com.sanrad.swing.wizard.SrWizardFrame;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;

public class SrRecoverWizardFrame
extends SrWizardFrame
implements DRListener {
    public SrRecoverWizardFrame(JFrame owner, final DRPairNode[] drPairNodes, final SiteNode backupSite) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_TITLE), ClientImageObject.WIZARD.getImageIcon());
        if (this.isRecoverPosible(backupSite)) {
            DRManager.getInstance().addDRListener(this);
            this.setFirstPanel(new SrHiddenWizardPanel(){

                @Override
                public WizardPanel next() {
                    ArrayList<DRPairNode> pairList = new ArrayList<DRPairNode>(Arrays.asList(drPairNodes));
                    this.getWizardContext().setAttribute(RecoverWizardContextKeys.BACKUP_PAIRS, pairList, this);
                    this.getWizardContext().setAttribute(RecoverWizardContextKeys.BACKUP_SITE, backupSite, this);
                    this.wizardContext.setAttribute(RecoverWizardContextKeys.START_REPLICATE_CHECKBOX_DEFAULT_SELECTION, Boolean.FALSE, this);
                    SrRecoverSelectSiteClusterVSwitchPanel next = new SrRecoverSelectSiteClusterVSwitchPanel();
                    next.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_WELLCOME_MSG));
                    return next;
                }

                @Override
                public void removeListeners() {
                }
            });
        } else {
            SrFinishWizardPanel abortPanel = new SrFinishWizardPanel(){

                @Override
                public void initDisplay() {
                }

                @Override
                public void removeListeners() {
                }
            };
            abortPanel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_ABORT_MSG));
            this.setFirstPanel(abortPanel);
        }
    }

    private boolean isRecoverPosible(SiteNode backupSite) {
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        for (int i = 0; i < sites.length; ++i) {
            if (sites[i] == backupSite || !this.hasAvailableClusters(sites[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasAvailableClusters(Object site) {
        SiteNode siteNode = (SiteNode)site;
        ClusterNode[] clusters = siteNode.getSiteClusters();
        ArrayList connectedClusterList = new ArrayList();
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[i].allAvailableVSwitchesDisconnected() || clusters[i].isUnderTakeover()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getClosingMessage() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_CANCELED_MSG);
    }

    @Override
    protected String getFinishMessage() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_CANCELED_MSG);
    }

    @Override
    public void drDiscoveryCompleted(DREvent e) {
    }

    @Override
    public void drDiscoveryStarted(DREvent e) {
        String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_WIZ_DR_REDISCOVERING);
        String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_DR_DISCOVERY_START_ERROR_TITLE);
        SrOptionPaneUtil.showErrorMsg(this, msg, title);
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        DRManager.getInstance().removeDRListener(this);
    }
}

