/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.recover;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverPreAttachTargetWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverPreSnapshotWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverSelectSiteClusterVSwitchPanel;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverStartReplicateWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SnapshotWizardContextKeys;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.jwf.Wizard;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class SrRecoverSummaryWizardPanel
extends SrWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private RecoverTransaction m_recoverTransaction = new RecoverTransaction();
    SrClientLabel m_priVolumeLabel;
    SrClientLabel m_priJournalLabel;
    SrClientLabel m_priSnapshotLabel;
    SrClientLabel m_secVolumeLabel;
    SrClientLabel m_secJournalLabel;
    SrClientLabel m_secSnapshotLabel;
    private SrClientLabel m_priVolumeValueLabel = new SrClientLabel();
    private SrClientLabel m_priJournalValueLabel = new SrClientLabel();
    private SrClientLabel m_priSnapshotValueLabel = new SrClientLabel();
    private SrClientLabel m_secVolumeValueLabel = new SrClientLabel();
    private SrClientLabel m_secJournalValueLabel = new SrClientLabel();
    private SrClientLabel m_secSnapshotValueLabel = new SrClientLabel();

    public SrRecoverSummaryWizardPanel() {
        this.addWizardTransaction(this.m_recoverTransaction);
        this.setSavedAsPrevious(false);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        SrPanel gridPanel = new SrPanel(new GridLayout(1, 2, 10, 0));
        SrPanel compsLeftPanel = new SrPanel(new GridBagLayout());
        SrPanel compsRightPanel = new SrPanel(new GridBagLayout());
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)gridPanel, constraints);
        String leftPanelTitle = "New Primary Volume";
        String rightPanelTitle = "Secondary Volume";
        Border etchedBorder = BorderFactory.createEtchedBorder();
        compsLeftPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, leftPanelTitle));
        compsRightPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, rightPanelTitle));
        gridPanel.add(compsLeftPanel);
        gridPanel.add(compsRightPanel);
        this.m_priVolumeLabel = new SrClientLabel("Volume:");
        this.m_priJournalLabel = new SrClientLabel("Journal:");
        this.m_priSnapshotLabel = new SrClientLabel("Snapshot:");
        this.m_secVolumeLabel = new SrClientLabel("Volume:");
        this.m_secJournalLabel = new SrClientLabel("Journal:");
        this.m_secSnapshotLabel = new SrClientLabel("Snapshot:");
        Color valuesFgColor = new Color(102, 102, 255);
        this.m_priVolumeValueLabel.setForeground(valuesFgColor);
        this.m_priJournalValueLabel.setForeground(valuesFgColor);
        this.m_priSnapshotValueLabel.setForeground(valuesFgColor);
        this.m_secVolumeValueLabel.setForeground(valuesFgColor);
        this.m_secJournalValueLabel.setForeground(valuesFgColor);
        this.m_secSnapshotValueLabel.setForeground(valuesFgColor);
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 5, 3, 0);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        compsLeftPanel.add((Component)this.m_priVolumeLabel, constraints);
        constraints.gridy = 1;
        compsLeftPanel.add((Component)this.m_priJournalLabel, constraints);
        constraints.gridy = 2;
        compsLeftPanel.add((Component)this.m_priSnapshotLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 0;
        compsLeftPanel.add((Component)this.m_priVolumeValueLabel, constraints);
        constraints.gridy = 1;
        compsLeftPanel.add((Component)this.m_priJournalValueLabel, constraints);
        constraints.gridy = 2;
        compsLeftPanel.add((Component)this.m_priSnapshotValueLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        compsRightPanel.add((Component)this.m_secVolumeLabel, constraints);
        constraints.gridy = 1;
        compsRightPanel.add((Component)this.m_secJournalLabel, constraints);
        constraints.gridy = 2;
        compsRightPanel.add((Component)this.m_secSnapshotLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        constraints.fill = 0;
        compsRightPanel.add((Component)this.m_secVolumeValueLabel, constraints);
        constraints.gridy = 1;
        compsRightPanel.add((Component)this.m_secJournalValueLabel, constraints);
        constraints.gridy = 2;
        compsRightPanel.add((Component)this.m_secSnapshotValueLabel, constraints);
    }

    @Override
    public void display() {
        if (this.wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_SNAPSHOT) == null) {
            this.wizardContext.setAttribute(RecoverWizardContextKeys.PRIMARY_SNAPSHOT, this.wizardContext.getAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT), this);
        }
        DRPairNode pairNode = (DRPairNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_PAIR);
        this.m_priVolumeValueLabel.setText(this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_PRIMARY_VOLUME).toString());
        this.m_secVolumeValueLabel.setText(this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_SECONDARY_VOLUME).toString());
        if (DRPairTypeConstant.ASYNC.equals(pairNode.getPairType())) {
            this.m_priJournalValueLabel.setText(this.wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_JOURNAL).toString());
            this.m_secJournalValueLabel.setText(this.wizardContext.getAttribute(RecoverWizardContextKeys.SECONDARY_JOURNAL).toString());
            if (DRPairInitialSyncTypeConstant.NONE.equals(pairNode.getInitialSyncType())) {
                this.m_priSnapshotLabel.setVisible(false);
                this.m_secSnapshotLabel.setVisible(false);
                this.m_priSnapshotValueLabel.setVisible(false);
                this.m_secSnapshotValueLabel.setVisible(false);
            } else {
                SnapshotVolumeNode secSnapshot = (SnapshotVolumeNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.SECONDARY_SNAPSHOT);
                if (secSnapshot != null) {
                    this.m_secSnapshotValueLabel.setText(secSnapshot.toString());
                }
                this.m_priSnapshotValueLabel.setText(this.wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_SNAPSHOT).toString());
            }
        } else {
            this.m_priJournalLabel.setVisible(false);
            this.m_priSnapshotLabel.setVisible(false);
            this.m_secJournalLabel.setVisible(false);
            this.m_secSnapshotLabel.setVisible(false);
            this.m_priJournalValueLabel.setVisible(false);
            this.m_priSnapshotValueLabel.setVisible(false);
            this.m_secJournalValueLabel.setVisible(false);
            this.m_secSnapshotValueLabel.setVisible(false);
        }
        this.setButtonText("NEXT_I18N", Wizard.APPLY);
        if (DRPairTypeConstant.ASYNC.equals(pairNode.getPairType()) && !DRPairInitialSyncTypeConstant.NONE.equals(pairNode.getInitialSyncType())) {
            this.setBackPanel(this.wizardContext.getWizardPanel(SrRecoverPreSnapshotWizardPanel.class));
        } else {
            this.setBackPanel(this.wizardContext.getWizardPanel(SrRecoverPreAttachTargetWizardPanel.class));
        }
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public WizardPanel next() {
        ExtendedElementNode cg;
        this.clearSummary();
        SrWizardFrame frame = (SrWizardFrame)this.wizardContext.getAttribute(SrWizardFrame.OWNER_KEY);
        Boolean isSelected = (Boolean)this.wizardContext.getAttribute(RecoverWizardContextKeys.START_REPLICATE_CHECKBOX_DEFAULT_SELECTION);
        DRPairNode pair = (DRPairNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_PAIR);
        ArrayList pairNodeList = (ArrayList)this.wizardContext.getAttribute(RecoverWizardContextKeys.BACKUP_PAIRS);
        SiteNode secondarySite = (SiteNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.BACKUP_SITE);
        this.wizardContext.clearAttributes();
        this.wizardContext.setAttribute(RecoverWizardContextKeys.START_REPLICATE_CHECKBOX_DEFAULT_SELECTION, isSelected, this);
        this.wizardContext.setAttribute(RecoverWizardContextKeys.SELECTED_PAIR, pair, this);
        this.wizardContext.setAttribute(RecoverWizardContextKeys.BACKUP_PAIRS, pairNodeList, this);
        this.wizardContext.setAttribute(RecoverWizardContextKeys.BACKUP_SITE, secondarySite, this);
        this.wizardContext.setAttribute(SrWizardFrame.OWNER_KEY, frame, this);
        if (pair instanceof DRASyncPairNode && (cg = ((DRASyncPairNode)pair).getConsistencyGroup()).isPartial()) {
            return new SrRecoverSelectSiteClusterVSwitchPanel();
        }
        return new SrRecoverStartReplicateWizardPanel();
    }

    @Override
    public void back() {
        this.removeListeners();
    }

    @Override
    public void removeListeners() {
    }

    private class RecoverTransaction
    extends WizardTransaction {
        private RecoverTransaction() {
        }

        @Override
        protected void transaction() {
            SrFuture<Void> actFuture = null;
            DRPairNode selectedRecoveringPair = (DRPairNode)SrRecoverSummaryWizardPanel.this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_PAIR);
            VolumeTreeNode volume = (VolumeTreeNode)SrRecoverSummaryWizardPanel.this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_PRIMARY_VOLUME);
            if (DRPairTypeConstant.ASYNC.equals(selectedRecoveringPair.getPairType())) {
                SnapshotVolumeNode snapshot = (SnapshotVolumeNode)SrRecoverSummaryWizardPanel.this.wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_SNAPSHOT);
                JournalVolumeNode journal = (JournalVolumeNode)SrRecoverSummaryWizardPanel.this.wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_JOURNAL);
                actFuture = DRASyncPairManager.getInstance().recover((DRASyncPairNode)selectedRecoveringPair, volume, snapshot, journal);
            } else if (DRPairTypeConstant.SYNC.equals(selectedRecoveringPair.getPairType())) {
                actFuture = DRSyncPairManager.getInstance().recover((DRSyncPairNode)selectedRecoveringPair, volume);
            } else {
                this.stop();
                theLogger.logAndAssert(SrLogCategories.ERROR, "The DR pair type is: " + selectedRecoveringPair.getPairType() + " which is not supported in the " + this.getClass() + " wizard");
                return;
            }
            this.waitAndBlockActions(actFuture, SrRecoverSummaryWizardPanel.this.getOwner());
        }
    }
}

