/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.recover;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectSiteClusterVSwitchPanel;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverPreResouceWizardPanel;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.swing.jwf.WizardPanel;
import java.util.ArrayList;

public class SrRecoverSelectSiteClusterVSwitchPanel
extends SrSelectSiteClusterVSwitchPanel {
    @Override
    protected String getClusterVSwitchSelectionDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_PANEL_SELECT_CLUSTER_VSWITCH);
    }

    @Override
    protected String getPanelTitleDesc() {
        return "";
    }

    protected Object[] getClusterVSwitchList(Object site) {
        SiteNode siteNode = (SiteNode)site;
        ClusterNode[] clusters = siteNode.getSiteClusters();
        ArrayList<ClusterNode> connectedClusterList = new ArrayList<ClusterNode>();
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[i].allAvailableVSwitchesDisconnected() || clusters[i].isUnderTakeover()) continue;
            connectedClusterList.add(clusters[i]);
        }
        return connectedClusterList.toArray();
    }

    @Override
    protected String getSiteSelectionDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_PANEL_SELECT_SITE);
    }

    @Override
    public void back() {
    }

    @Override
    public WizardPanel next() {
        this.removeListeners();
        this.wizardContext.setAttribute(RecoverWizardContextKeys.SELECTED_SITE, this.m_sitesCombo.getSelectedItem(), this);
        this.wizardContext.setAttribute(RecoverWizardContextKeys.SELECTED_CLUSTER, this.m_clusterVSwitchCombo.getSelectedItem(), this);
        ArrayList pairsList = (ArrayList)this.wizardContext.getAttribute(RecoverWizardContextKeys.BACKUP_PAIRS);
        DRPairNode selectedPair = (DRPairNode)pairsList.remove(0);
        this.wizardContext.setAttribute(RecoverWizardContextKeys.SELECTED_PAIR, selectedPair, this);
        if (DRPairTypeConstant.ASYNC.equals(selectedPair.getPairType())) {
            DRASyncPairNode asyncPair = (DRASyncPairNode)selectedPair;
            this.wizardContext.setAttribute(RecoverWizardContextKeys.SECONDARY_JOURNAL, asyncPair.getSecondaryJournal(), this);
            this.wizardContext.setAttribute(RecoverWizardContextKeys.SECONDARY_SNAPSHOT, asyncPair.getSecondarySnapshot(), this);
        }
        this.wizardContext.setAttribute(RecoverWizardContextKeys.SELECTED_SECONDARY_VOLUME, selectedPair.getPairSecondaryVolume(), this);
        DirectAccessDeviceNode remotePrimaryVol = (DirectAccessDeviceNode)selectedPair.getRemotePrimaryVolume();
        this.wizardContext.setAttribute(RecoverWizardContextKeys.PRIMARY_TARGET_NAME, remotePrimaryVol.getEntityName(), this);
        this.wizardContext.setAttribute(RecoverWizardContextKeys.PRIMARY_LUN, remotePrimaryVol.getRemoteLU(), this);
        this.wizardContext.setAttribute(RecoverWizardContextKeys.PRIMARY_LUN_SERIAL_NUMBER, remotePrimaryVol.getSerialNumber(), this);
        return new SrRecoverPreResouceWizardPanel();
    }

    @Override
    public void display() {
        super.display();
        SiteNode selectedSite = (SiteNode)this.getWizardContext().getAttribute(RecoverWizardContextKeys.SELECTED_SITE);
        if (selectedSite != null) {
            this.m_sitesCombo.setSelectedItem(selectedSite);
        }
        this.setBackButtonEnabled(false);
    }
}

