/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.recover;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrComponentNameBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectResourceWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverCreateVolumeWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.recover.SrRecoverPreAttachTargetWizardPanel;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;

public class SrRecoverSelectResourcePanel
extends SrSelectResourceWizardPanel {
    String m_expectedTargetName;
    String m_expectedLun;

    SrRecoverSelectResourcePanel(ClusterNode cluster) {
        super(cluster);
        this.m_table.getTable().setName(ClientLoader.COMP_NAMES_BUNDLE.getString(SrComponentNameBundleKeys.TABLE_DR_WIZARD_RECOVER_SELECT_RESOURCE));
    }

    @Override
    protected SrWizardPanel getCreateVolumePanel() {
        ClusterNode cluster = (ClusterNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_CLUSTER);
        VolumeTreeNode secVolume = (VolumeTreeNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.SELECTED_SECONDARY_VOLUME);
        return new SrRecoverCreateVolumeWizardPanel(cluster, secVolume);
    }

    @Override
    protected String getPanelTitleDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_RECOVER_WIZ_SELECT_RESOURCE_TITLE);
    }

    @Override
    public SrResourceTableModel getResourceTableModel(ClusterNode cluster, WizardContext context) {
        VolumeTreeNode secVolume = (VolumeTreeNode)context.getAttribute(RecoverWizardContextKeys.SELECTED_SECONDARY_VOLUME);
        SrRecoverResourceTableModel model = new SrRecoverResourceTableModel(cluster, secVolume);
        return model;
    }

    @Override
    protected WizardPanel doNext() {
        this.removeListeners();
        VolumeTreeNode selectedResource = this.getSelectedVolume();
        this.wizardContext.setAttribute(RecoverWizardContextKeys.SELECTED_PRIMARY_VOLUME, selectedResource, this);
        return new SrRecoverPreAttachTargetWizardPanel();
    }

    @Override
    public void display() {
        super.display();
        this.setBackButtonEnabled(false);
    }

    @Override
    protected ContextKey getContextKeyForSelectedResource() {
        return RecoverWizardContextKeys.SELECTED_PRIMARY_VOLUME;
    }

    private class SrRecoverResourceTableModel
    extends SrResourceTableModel {
        private VolumeTreeNode m_secVolume;

        SrRecoverResourceTableModel(ClusterNode cluster, VolumeTreeNode secVolume) {
            super(cluster);
            this.m_secVolume = secVolume;
            this.initModel();
        }

        @Override
        protected boolean isVolumeValid(VolumeTreeNode volume) {
            return RecoverWizardValidations.isVolumeValidAsPrimary(volume, this.m_secVolume, SrRecoverSelectResourcePanel.this.wizardContext);
        }
    }
}

