/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.recover;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.dr.wizards.DRWizardValidation;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.swing.jwf.WizardContext;

public class RecoverWizardValidations {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final String ISCSI_TRANS_TYPE = PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString();

    private RecoverWizardValidations() {
    }

    public static boolean isVolumeValidAsPrimary(VolumeTreeNode volume, VolumeTreeNode m_secVolume, WizardContext wizardContext) {
        DirectAccessDeviceNode disk;
        if (!DRWizardValidation.isRedundant(volume)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource, it is not redundant."));
            return false;
        }
        if (volume instanceof DirectAccessDeviceNode && ISCSI_TRANS_TYPE.equals((disk = (DirectAccessDeviceNode)volume).getTransportType())) {
            SiteNode secondarySite = (SiteNode)wizardContext.getAttribute(RecoverWizardContextKeys.BACKUP_SITE);
            TargetNode target = TargetManager.getInstance().getTargetByName(disk.getEntityName());
            if (target != null && secondarySite.equals(SystemRootNode.getInstance().getSiteNode(target))) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource, it is an iSCSI disk which its local target defined on the secondary cluster."));
                return false;
            }
        }
        if (!volume.getAccessibleSpace().equals(m_secVolume.getAccessibleSpace())) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource, its Accessible Space is " + volume.getAccessibleSpace() + " and the secondary is " + m_secVolume.getAccessibleSpace() + " ."));
            return false;
        }
        if (VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(volume)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource, offline-copy-resource reasons."));
            theLogger.logAndAssert(SrLogCategories.ERROR, "The offline-copy-GDR-volume is not completed feature");
            return false;
        }
        boolean isConflictWithRemote = false;
        if (volume.getLUNode() != null) {
            String expectedTargetName = (String)wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_TARGET_NAME);
            String expectedLun = (String)wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_LUN);
            String expectedSN = (String)wizardContext.getAttribute(RecoverWizardContextKeys.PRIMARY_LUN_SERIAL_NUMBER);
            LUNode lu = volume.getLUNode();
            TargetNode target = lu.getTargetParent();
            if (!(target.getName().equals(expectedTargetName) && lu.getLUN().toString().equals(expectedLun) && expectedSN.equals(lu.getSerialNumber()))) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource, its lu details " + lu + " in conflict with the expected: target=" + expectedTargetName + ", lun=" + expectedLun + ", S/N=" + expectedSN + "."));
                isConflictWithRemote = true;
            }
        }
        return RecoverWizardValidations.canBePrimaryResourceOnTarget(volume) && !isConflictWithRemote;
    }

    private static boolean canBePrimaryResourceOnTarget(VolumeTreeNode volume) {
        if (volume.getLUNode() != null) {
            LUNode lun = volume.getLUNode();
            TargetNode target = null;
            if (lun != null) {
                target = volume.getLUNode().getTargetParent();
            }
            if (target != null) {
                for (LUNode luNode : target.getLuNodes()) {
                    VolumeTreeNode pairPriVolume;
                    VolumeTreeNode luVolume = luNode.getVolumeChild();
                    DRASyncPairManager.getInstance();
                    DRPairNode pair = DRASyncPairManager.getPairContainingVolume(luVolume);
                    if (pair == null || (pairPriVolume = pair.getPairPrimaryVolume()) == luVolume) continue;
                    theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource on its own target."));
                    return false;
                }
            }
        }
        return true;
    }
}

