/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.pair;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairPrePrimSideWizardPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.jwf.Wizard;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrFinishWizardPanel;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public class SrPairWizardFrame
extends SrWizardFrame {
    private static final String LOCAL_CLUSTER_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_LOCAL_CLUSTER_TITLE);
    private static final String REMOTE_CLUSTER_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_REMOTE_CLUSTER_TITLE);

    public SrPairWizardFrame(JFrame owner) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_TITLE), ClientImageObject.WIZARD.getImageIcon());
        if (this.isDRPosible()) {
            this.setFirstPanel(new SrPairPrePrimSideWizardPanel());
        } else {
            SrFinishWizardPanel abortPanel = new SrFinishWizardPanel(){

                @Override
                public void initDisplay() {
                }

                @Override
                public void removeListeners() {
                }
            };
            abortPanel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_DR_NOT_AVAILABLE));
            this.setFirstPanel(abortPanel);
        }
    }

    public SrPairWizardFrame(JFrame owner, VolumeTreeNode primVol) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_TITLE), ClientImageObject.WIZARD.getImageIcon());
        if (this.isDRPosible()) {
            this.setFirstPanel(new SrPairPrePrimSideWizardPanel(primVol));
        } else {
            SrFinishWizardPanel abortPanel = new SrFinishWizardPanel(){

                @Override
                public void initDisplay() {
                }

                @Override
                public void removeListeners() {
                }
            };
            abortPanel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_DR_NOT_AVAILABLE));
            this.setFirstPanel(abortPanel);
        }
        this.setSize(560, 570);
    }

    private boolean isDRPosible() {
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        int connectedSitesCount = 0;
        for (int i = 0; i < sites.length; ++i) {
            if (!this.hasConnectedClusters(sites[i])) continue;
            ++connectedSitesCount;
        }
        return connectedSitesCount > 1;
    }

    private boolean hasConnectedClusters(Object site) {
        SiteNode siteNode = (SiteNode)site;
        ClusterNode[] clusters = siteNode.getSiteClusters();
        ArrayList connectedClusterList = new ArrayList();
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[i].allAvailableVSwitchesDisconnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getClosingMessage() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_CANCELED);
    }

    @Override
    protected String getFinishMessage() {
        return null;
    }

    public void wizardPanelChanged(Wizard wizard) {
        if (wizard.getCurrentPanel() != null) {
            String title = null;
            ClusterNode primCluster = (ClusterNode)wizard.getCurrentPanel().getWizardContext().getAttribute(Key.PRIMARY_CLUSTER);
            if (primCluster != null) {
                StringBuffer titleBuff = new StringBuffer(this.m_wizTitle);
                titleBuff.append(LOCAL_CLUSTER_MSG);
                titleBuff.append(primCluster.getAlias());
                ClusterNode secCluster = (ClusterNode)wizard.getCurrentPanel().getWizardContext().getAttribute(Key.SECONDARY_CLUSTER);
                if (secCluster != null) {
                    titleBuff.append(REMOTE_CLUSTER_MSG);
                    titleBuff.append(secCluster.getAlias());
                }
                title = titleBuff.toString();
            } else {
                title = this.m_wizTitle;
            }
            this.setTitle(title);
            this.m_statusPanel.setStatusStr("");
        }
    }

    public static class CreatePairAction<T extends VolumeTreeNode>
    extends SrClientAction<T, Void> {
        public CreatePairAction(View<T> view) {
            super(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_POPUP_MENU_CREATE_PAIR_LABEL), true, true, view, SrLicenseTreePath.GDR_PATH, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
            if (SrWizardFrame.isAlreadyRunningWizard(SrPairWizardFrame.class)) {
                return Collections.EMPTY_LIST;
            }
            SrPairWizardFrame frm = new SrPairWizardFrame(ClientLoader.getMainFrame(), (VolumeTreeNode)arg.iterator().next());
            frm.runWizard();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            StringBuffer reason = new StringBuffer("");
            if (!VolumeManager.getInstance().isCreatePairAllowed((VolumeTreeNode)this.myView.getValue().iterator().next(), reason)) {
                return reason.toString();
            }
            return null;
        }

        @Override
        public String getMultipleSelectionTooltip() {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VALIDAION_MORE_THAN_ONE_SOURCE_WAS_SELECTED);
        }
    }

    public static class Key
    extends ContextKey {
        public static final Key IS_PRIMARY_VOLUME_PREDEFINED = new Key();
        public static final Key PAIR_TYPE = new Key("Pair type");
        public static final Key PRIMARY_CLUSTER = new Key("Primary cluster");
        public static final Key PRIMARY_SITE = new Key("Primary site");
        public static final Key PRIMARY_VOLUME = new Key("Primary volume");
        public static final Key PRIMARY_TARGET = new Key("Primary target");
        public static final Key PRIMARY_LUN = new Key("Primary LUN");
        public static final Key PRIMARY_SNAPSHOT = new Key("Primary snapshot");
        public static final Key PRIMARY_JOURNAL = new Key("Primary journal");
        public static final Key SECONDARY_CLUSTER = new Key("Secondary cluster");
        public static final Key SECONDARY_SITE = new Key("Secondary site");
        public static final Key SECONDARY_VOLUME = new Key("Secondary volume");
        public static final Key SECONDARY_TARGET = new Key("Secondary target");
        public static final Key SECONDARY_LUN = new Key("Secondary LUN");
        public static final Key SECONDARY_SNAPSHOT = new Key();
        public static final Key SECONDARY_JOURNAL = new Key("Secondary journal");
        public static final Key SECONDARY_SNAPSHOT_DISPLAY = new Key("Secondary snapshot");
        public static final Key SECONDARY_SNAPSHOT_ALIAS = new Key();
        public static final Key SECONDARY_SNAPSHOT_THRESHOLD = new Key();
        public static final Key SECONDARY_SNAPSHOT_CHILD = new Key();
        public static final Key IS_SECONDARY_SNAPSHOT_SELECTED = new Key();
        public static final Key INITIAL_SYNC_TYPE = new Key("Initial sync. policy");
        public static final Key IS_NEW_CG = new Key();
        public static final Key SELECTED_CG_NAME = new Key("CG name");
        public static final Key CG_OBJECT = new Key("New CG name");
        public static final Key CG_SECONDARY_VSWITCH = new Key();
        public static final Key REPLICATION_METHOD = new Key("Replication method");
        public static final Key REPLICATION_RUN_EVERY = new Key();
        public static final Key REPLICATION_RUN_EVERY_DISPLAY = new Key("Replication run every");
        public static final Key REPLICATION_START_AT = new Key();
        public static final Key REPLICATION_STARTAT_DISPLAY = new Key("Replication start at");
        public static final Key TRANSFER_METHOD = new Key("Transfer method");
        public static final Key TRANSFER_RUN_EVERY = new Key();
        public static final Key TRANSFER_RUN_EVERY_DISPLAY = new Key("Transfer run every");
        public static final Key TRANSFER_START_AT = new Key();
        public static final Key TRANSFER_STARTAT_DISPLAY = new Key("Transfer start at");
        public static final Key IS_OFFLINE_LOCAL_VOLUME_SELECTED = new Key();

        private Key() {
        }

        private Key(String displayText) {
            super(displayText);
        }
    }
}

