/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.pair;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairAsyncSummaryWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class SrPairSyncSummaryWizardPanel
extends SrPairAsyncSummaryWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private CreatePairTrasaction m_createPairTransaction = new CreatePairTrasaction();

    public SrPairSyncSummaryWizardPanel(WizardContext context) {
        super(context);
    }

    @Override
    protected String getTitle() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_SYNC_PAIR_WIZ_SUM_PANEL_TITLE);
    }

    @Override
    protected WizardTransaction getCreatePairTrasaction() {
        return this.m_createPairTransaction;
    }

    @Override
    protected void registerTransaction() {
    }

    @Override
    protected SrPanel createCenterPanel() {
        SrPanel initialSyncPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints northPanelconstraints = new GridBagConstraints();
        northPanelconstraints.weightx = 1.0;
        northPanelconstraints.weighty = 1.0;
        northPanelconstraints.fill = 2;
        northPanelconstraints.anchor = 11;
        northPanelconstraints.gridx = 0;
        northPanelconstraints.gridy = 0;
        northPanelconstraints.insets = new Insets(5, 7, 0, 10);
        initialSyncPanel.add((Component)this.getInitialSyncPanel(), northPanelconstraints);
        return initialSyncPanel;
    }

    @Override
    protected JournalVolumeNode getJournal(TargetNode target) {
        return null;
    }

    private SrFuture<Void> createSyncPair() {
        WizardContext context = this.getWizardContext();
        DRPairInitialSyncTypeConstant initialSyncType = (DRPairInitialSyncTypeConstant)context.getAttribute(SrPairWizardFrame.Key.INITIAL_SYNC_TYPE);
        VolumeTreeNode primaryVolume = (VolumeTreeNode)context.getAttribute(SrPairWizardFrame.Key.PRIMARY_VOLUME);
        LUNode localLun = primaryVolume.getLUNode();
        TargetNode localTarget = null;
        if (localLun != null) {
            localTarget = localLun.getTargetParent();
        }
        VolumeTreeNode secondaryVolume = (VolumeTreeNode)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME);
        LUNode remoteLun = secondaryVolume.getLUNode();
        TargetNode remoteTarget = null;
        if (remoteLun != null) {
            remoteTarget = remoteLun.getTargetParent();
        }
        SrFuture<Void> actFuture = DRSyncPairManager.getInstance().createSyncPair(initialSyncType, primaryVolume, secondaryVolume, localTarget != null ? localTarget.getName() : null, localLun != null ? localLun.getLUN() : null, remoteTarget != null ? remoteTarget.getName() : null, remoteLun != null ? remoteLun.getLUN() : null);
        return actFuture;
    }

    @Override
    public void removeListeners() {
    }

    private class CreatePairTrasaction
    extends WizardTransaction {
        private CreatePairTrasaction() {
        }

        @Override
        protected void transaction() {
            SrFuture actFuture = SrPairSyncSummaryWizardPanel.this.createSyncPair();
            this.waitAndBlockActions(actFuture, SrPairSyncSummaryWizardPanel.this.getOwner());
        }
    }
}

