/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.pair;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrAllocateVolumeWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectResourceWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.PairWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairPreSecTargetWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.Util;
import com.sanrad.util.virtualization.ResourceAliasUtil;
import java.util.ArrayList;

public class SrPairSelectSecResourcePanel
extends SrSelectResourceWizardPanel {
    public SrPairSelectSecResourcePanel(ClusterNode cluster, WizardPanel lastPanel) {
        super(cluster);
        this.setBackPanel(lastPanel);
    }

    static SrAllocateVolumeWizardPanel createVolumeAllocationWizardPanel(ClusterNode aCluster, WizardContext aWizardContext, VolumeTreeNode aPriVolume) {
        Util.validateInputNotNull(aCluster, "Cluster node");
        Util.validateInputNotNull(aWizardContext, "Wizard context");
        Util.validateInputNotNull(aPriVolume, "Primary volume");
        ArrayList<String> allAliases = new ArrayList<String>();
        allAliases.addAll(VolumeManager.getInstance().getAllVolumeAliases(aCluster));
        allAliases.addAll(StorageManager.getInstance().getAllAliases(aCluster));
        String secVolumeAlias = ResourceAliasUtil.getRecommendedAlias(aPriVolume.getAlias() + "_remote", allAliases);
        SrAllocateVolumeWizardPanel createVolumePanel = new SrAllocateVolumeWizardPanel(aCluster, secVolumeAlias, aPriVolume.getAccessibleSpace(), null, null, null, SrPairWizardFrame.Key.SECONDARY_VOLUME, new SrPairPreSecTargetWizardPanel());
        return createVolumePanel;
    }

    @Override
    protected SrWizardPanel getCreateVolumePanel() {
        VolumeTreeNode priVolume = (VolumeTreeNode)this.wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_VOLUME);
        SrAllocateVolumeWizardPanel panel = SrPairSelectSecResourcePanel.createVolumeAllocationWizardPanel(this.m_clusterNode, this.wizardContext, priVolume);
        boolean isOfflineVolumeSelected = (Boolean)this.wizardContext.getAttribute(SrPairWizardFrame.Key.IS_OFFLINE_LOCAL_VOLUME_SELECTED);
        if (isOfflineVolumeSelected) {
            panel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_OFFLINE_LOCAL_COPY_CREATE_VOLUME_DESC));
        } else {
            panel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_VOLUME_CREATE_DESC));
        }
        return panel;
    }

    @Override
    protected WizardPanel doNext() {
        VolumeTreeNode secVol = this.getSelectedVolume();
        this.wizardContext.setAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME, secVol, this);
        return new SrPairPreSecTargetWizardPanel();
    }

    @Override
    public SrResourceTableModel getResourceTableModel(ClusterNode cluster, WizardContext context) {
        VolumeTreeNode primVol = (VolumeTreeNode)context.getAttribute(SrPairWizardFrame.Key.PRIMARY_VOLUME);
        return new SrPairSecondResourceTableModel(cluster, primVol);
    }

    @Override
    protected String getPanelTitleDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SELECT_SECOND_RESOURCE_TITLE);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_VOLUME_SELECT_DESC);
    }

    @Override
    protected ContextKey getContextKeyForSelectedResource() {
        return SrPairWizardFrame.Key.SECONDARY_VOLUME;
    }

    public class SrPairSecondResourceTableModel
    extends SrResourceTableModel {
        private VolumeTreeNode m_primVolume;

        public SrPairSecondResourceTableModel(ClusterNode cluster, VolumeTreeNode primaryVolume) {
            super(cluster);
            this.m_primVolume = primaryVolume;
            this.initModel();
        }

        @Override
        protected boolean isVolumeValid(VolumeTreeNode volume) {
            return PairWizardValidations.isVolumeValidAsSecondary(volume, this.m_primVolume, SrPairSelectSecResourcePanel.this.wizardContext);
        }
    }
}

