/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.pair;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectResourceWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.PairWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairCreatePrimVolumeWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairSelectTypeWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.client.gui.dr.wizards.target.SrPreTargetWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.target.TargetWizardContextKeys;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;

public class SrPairSelectPrimResourcePanel
extends SrSelectResourceWizardPanel {
    public SrPairSelectPrimResourcePanel(ClusterNode cluster, WizardPanel lastPanel) {
        super(cluster);
        this.setBackPanel(lastPanel);
    }

    @Override
    protected WizardPanel doNext() {
        VolumeTreeNode vol = this.getSelectedVolume();
        this.wizardContext.setAttribute(SrPairWizardFrame.Key.PRIMARY_VOLUME, vol, this);
        this.wizardContext.setAttribute(TargetWizardContextKeys.NEXT_OUTER_WIZARD_PANEL, new SrPairSelectTypeWizardPanel(), this);
        this.wizardContext.setAttribute(TargetWizardContextKeys.NEW_TARGET_PANEL_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_VOLUME_TARGET_CREATE_DESC), this);
        this.wizardContext.setAttribute(TargetWizardContextKeys.EXPOSE_PANEL_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_VOLUME_EXPOSE_DESC), this);
        return new SrPreTargetWizardPanel(vol, DRRoleConstant.LOCAL, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_ATTACH_PRIM_TARGET_PANEL_TITLE));
    }

    @Override
    protected SrWizardPanel getCreateVolumePanel() {
        SrPairCreatePrimVolumeWizardPanel panel = new SrPairCreatePrimVolumeWizardPanel((ClusterNode)this.wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_CLUSTER));
        panel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_VOLUME_CREATE_DESC));
        return panel;
    }

    @Override
    public SrResourceTableModel getResourceTableModel(ClusterNode cluster, WizardContext context) {
        return new SrPairPrimResourceTableModel(cluster);
    }

    @Override
    protected String getPanelTitleDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SELECT_PRIM_RESOURCE_TITLE);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_VOLUME_SELECT_DESC);
    }

    @Override
    protected ContextKey getContextKeyForSelectedResource() {
        return SrPairWizardFrame.Key.PRIMARY_VOLUME;
    }

    public class SrPairPrimResourceTableModel
    extends SrResourceTableModel {
        public SrPairPrimResourceTableModel(ClusterNode cluster) {
            super(cluster);
            this.initModel();
        }

        @Override
        protected boolean isVolumeValid(VolumeTreeNode volume) {
            return PairWizardValidations.isVolumeValidAsPrimary(volume, SrPairSelectPrimResourcePanel.this.wizardContext);
        }
    }
}

