/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.pair;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairCGReplicationWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairSelectSecSiteClusterPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrRadioButton;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.text.LengthLimitedDocument;
import com.sanrad.util.SrConstantsBundleKeys;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;

public class SrPairConsistencyGroupWizardPanel
extends SrDRWizardPanel
implements ActionListener,
DRConsistencyGroupListener {
    private SrComboBox<DRPairInitialSyncTypeConstant> m_initialSyncCombo;
    private SrTextField m_cgNameField;
    private CGFieldDocumentListener m_newCGListener = new CGFieldDocumentListener();
    private SrComboBox<ConsistencyGroupNode> m_cgListComboBox;
    private ButtonGroup m_bttGroup;
    private ClusterNode m_localCluster;
    private SrRadioButton m_useExistingBtt;
    private SrRadioButton m_newCGBtt;
    private SrRadioButton m_noneGCBtt;
    private ExtendedElementNode[] m_allCGNodes;
    private static final String USE_EXISTING_BTT_CMD = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_INITIAL_SYNC_CG_USE_EXISTING);
    private static final String NEW_BTT_CMD = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_INITIAL_SYNC_CG_NEW);
    private static final String NONE_BTT_CMD = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_INITIAL_SYNC_CG_NONE);

    public SrPairConsistencyGroupWizardPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainPanelconstraints = new GridBagConstraints();
        mainPanelconstraints.weightx = 1.0;
        mainPanelconstraints.weighty = 0.1;
        mainPanelconstraints.fill = 1;
        mainPanelconstraints.gridx = 0;
        mainPanelconstraints.gridy = 0;
        SrClientLabel descLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_INITIAL_SYNC_ASYNC_TITLE));
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 10, 10, 40);
        constraints.fill = 1;
        descriptionPanel.add((Component)descLabel, constraints);
        this.add((Component)descriptionPanel, mainPanelconstraints);
        SrPanel subMain = new SrPanel(new GridBagLayout());
        subMain.setBorder(BorderFactory.createEtchedBorder());
        Object[] original = DRPairInitialSyncTypeConstant.getValues();
        DRPairInitialSyncTypeConstant[] listOfTypes = (DRPairInitialSyncTypeConstant[])Arrays.copyOf(original, original.length, DRPairInitialSyncTypeConstant[].class);
        this.m_initialSyncCombo = new SrComboBox<DRPairInitialSyncTypeConstant>((T[])listOfTypes);
        SrPropertyPanel props = new SrPropertyPanel(this.getClass().toString(), false, true, false);
        props.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_INITIAL_SYNC_KEY_DESC), this.m_initialSyncCombo);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 20, 0, 20);
        subMain.add((Component)props, constraints);
        SrPanel cgPanel = new SrPanel(new GridBagLayout());
        cgPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_INITIAL_SYNC_CG_TITLE)));
        ++constraints.gridy;
        constraints.insets.top = 0;
        constraints.insets.bottom = 10;
        this.buildCGPanel(cgPanel);
        subMain.add((Component)cgPanel, constraints);
        mainPanelconstraints.weighty = 0.9;
        mainPanelconstraints.gridy = 1;
        mainPanelconstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)subMain, mainPanelconstraints);
    }

    private void buildCGPanel(SrPanel cgPanel) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(20, 10, 20, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_useExistingBtt = new SrRadioButton(USE_EXISTING_BTT_CMD);
        this.m_useExistingBtt.setActionCommand(USE_EXISTING_BTT_CMD);
        this.m_useExistingBtt.addActionListener(this);
        this.m_newCGBtt = new SrRadioButton(NEW_BTT_CMD);
        this.m_newCGBtt.setActionCommand(NEW_BTT_CMD);
        this.m_newCGBtt.addActionListener(this);
        this.m_noneGCBtt = new SrRadioButton(NONE_BTT_CMD);
        this.m_noneGCBtt.setActionCommand(NONE_BTT_CMD);
        this.m_noneGCBtt.addActionListener(this);
        this.m_bttGroup = new ButtonGroup();
        this.m_bttGroup.add(this.m_useExistingBtt);
        this.m_bttGroup.add(this.m_newCGBtt);
        this.m_bttGroup.add(this.m_noneGCBtt);
        this.m_cgListComboBox = new SrComboBox<ConsistencyGroupNode>(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                super.contentsChanged(e);
                if (SrPairConsistencyGroupWizardPanel.this.m_cgListComboBox.getItemCount() == 0) {
                    SrPairConsistencyGroupWizardPanel.this.m_useExistingBtt.setEnabled(false);
                    if (SrPairConsistencyGroupWizardPanel.this.m_useExistingBtt.isSelected()) {
                        SrPairConsistencyGroupWizardPanel.this.m_newCGBtt.doClick();
                    }
                } else {
                    SrPairConsistencyGroupWizardPanel.this.m_useExistingBtt.setEnabled(true);
                }
            }
        };
        this.m_cgNameField = new SrTextField();
        String maxLengthAlias = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.ALIAS_MAX_LENGTH);
        this.m_cgNameField.setDocument(new LengthLimitedDocument(Integer.parseInt(maxLengthAlias)));
        this.m_cgNameField.getDocument().addDocumentListener(this.m_newCGListener);
        cgPanel.add((Component)this.m_useExistingBtt, constraints);
        constraints.gridx = 1;
        constraints.insets.right = 70;
        constraints.insets.left = 0;
        cgPanel.add(this.m_cgListComboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets.right = 0;
        constraints.insets.left = 10;
        cgPanel.add((Component)this.m_newCGBtt, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets.right = 70;
        constraints.insets.left = 0;
        cgPanel.add((Component)this.m_cgNameField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets.right = 0;
        constraints.insets.left = 10;
        cgPanel.add((Component)this.m_noneGCBtt, constraints);
    }

    @Override
    public void display() {
        DRConsistencyGroupManager.getInstance().addDRConsistencyGroupListener(this);
        this.updateCGList();
        this.m_localCluster = (ClusterNode)this.wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_CLUSTER);
        ConsistencyGroupNode[] cgs = this.prepareGroupList(this.m_localCluster);
        this.m_cgListComboBox.setModel(new DefaultComboBoxModel<ConsistencyGroupNode>(cgs));
        if (this.m_cgListComboBox.getItemCount() > 0) {
            this.m_useExistingBtt.setSelected(true);
            this.m_useExistingBtt.doClick();
        } else {
            this.m_useExistingBtt.setEnabled(false);
            this.m_newCGBtt.setSelected(true);
            this.m_newCGBtt.doClick();
            this.updateNextButton();
        }
    }

    @Override
    public WizardPanel next() {
        SrDRWizardPanel nextPanel = null;
        DRPairInitialSyncTypeConstant isyncType = (DRPairInitialSyncTypeConstant)this.m_initialSyncCombo.getSelectedItem();
        if (!DRPairInitialSyncTypeConstant.OFFLINE.equals(isyncType)) {
            this.wizardContext.setAttribute(SrPairWizardFrame.Key.IS_OFFLINE_LOCAL_VOLUME_SELECTED, Boolean.FALSE, this);
        }
        this.getWizardContext().setAttribute(SrPairWizardFrame.Key.INITIAL_SYNC_TYPE, isyncType, this);
        if (this.m_newCGBtt.isSelected()) {
            this.getWizardContext().setAttribute(SrPairWizardFrame.Key.IS_NEW_CG, Boolean.TRUE, this);
            this.getWizardContext().setAttribute(SrPairWizardFrame.Key.CG_OBJECT, this.m_cgNameField.getText(), this);
            nextPanel = new SrPairCGReplicationWizardPanel();
        } else if (this.m_useExistingBtt.isSelected()) {
            this.getWizardContext().setAttribute(SrPairWizardFrame.Key.CG_OBJECT, this.m_cgListComboBox.getSelectedItem(), this);
            this.getWizardContext().setAttribute(SrPairWizardFrame.Key.IS_NEW_CG, Boolean.FALSE, this);
            nextPanel = new SrPairSelectSecSiteClusterPanel();
        } else if (this.m_noneGCBtt.isSelected()) {
            this.getWizardContext().setAttribute(SrPairWizardFrame.Key.CG_OBJECT, null, this);
            this.getWizardContext().setAttribute(SrPairWizardFrame.Key.PRIMARY_SNAPSHOT, null, this);
            this.getWizardContext().setAttribute(SrPairWizardFrame.Key.IS_NEW_CG, Boolean.TRUE, this);
            nextPanel = new SrPairCGReplicationWizardPanel();
        }
        return nextPanel;
    }

    @Override
    public boolean validateNext(List list) {
        String cmd = this.m_bttGroup.getSelection().getActionCommand();
        if (cmd.equals(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_INITIAL_SYNC_CG_NEW)) && this.m_cgNameField.getText().equals("")) {
            list.add(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_NEW_CG_WRONG_NAME));
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals(USE_EXISTING_BTT_CMD)) {
            this.m_cgNameField.setEnabled(false);
            this.m_cgNameField.setEditable(false);
            this.m_cgListComboBox.setEnabled(true);
            this.setNextButtonEnabled(true);
        } else if (actionCmd.equals(NEW_BTT_CMD)) {
            this.m_cgNameField.setEnabled(true);
            this.m_cgNameField.setEditable(true);
            this.m_cgNameField.requestFocus();
            this.m_cgListComboBox.setEnabled(false);
            this.updateNextButton();
        } else {
            this.m_cgNameField.setEnabled(false);
            this.m_cgNameField.setEditable(false);
            this.m_cgListComboBox.setEnabled(false);
            this.setNextButtonEnabled(true);
        }
    }

    @Override
    public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
        this.updateCGList();
        ConsistencyGroupNode[] cgs = this.prepareGroupList(this.m_localCluster);
        ExtendedElementNode node = e.getExtendedElementNode();
        int selectedIndex = this.m_cgListComboBox.getSelectedIndex();
        boolean isChangedGroupInAvailableCGList = false;
        int i = cgs.length;
        while (i-- > 0) {
            if (cgs[i] != node) continue;
            isChangedGroupInAvailableCGList = true;
        }
        if (isChangedGroupInAvailableCGList) {
            boolean isChangeGroupInComboBox = false;
            int i2 = this.m_cgListComboBox.getItemCount();
            while (i2-- > 0) {
                if (this.m_cgListComboBox.getItemAt(i2) != node) continue;
                isChangeGroupInComboBox = true;
                this.m_cgListComboBox.removeItemAt(i2);
                if (this.m_cgListComboBox.getItemCount() > 0) {
                    this.m_cgListComboBox.insertItemAt((ExtendedElementNode)node, i2);
                    break;
                }
                this.m_cgListComboBox.addItem((ExtendedElementNode)node);
                break;
            }
            this.m_cgListComboBox.setSelectedIndex(selectedIndex);
            if (!isChangeGroupInComboBox) {
                this.m_cgListComboBox.addItem((ExtendedElementNode)node);
            }
        } else {
            this.m_cgListComboBox.removeItem(node);
        }
    }

    @Override
    public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
        this.updateCGList();
        ConsistencyGroupNode[] cgs = this.prepareGroupList(this.m_localCluster);
        ExtendedElementNode node = e.getExtendedElementNode();
        boolean isChangedGroupInList = false;
        int i = cgs.length;
        while (i-- > 0) {
            if (cgs[i] != node) continue;
            isChangedGroupInList = true;
        }
        if (isChangedGroupInList) {
            this.m_cgListComboBox.addItem((ExtendedElementNode)node);
        }
    }

    @Override
    public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
        this.updateCGList();
        ExtendedElementNode node = e.getExtendedElementNode();
        this.m_cgListComboBox.removeItem(node);
    }

    @Override
    public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
    }

    public void consistencyGroupStateChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void removeListeners() {
        DRConsistencyGroupManager.getInstance().removeDRConsistencyGroupListener(this);
    }

    @Override
    public void back() {
    }

    private ConsistencyGroupNode[] prepareGroupList(ClusterNode localCluster) {
        ConsistencyGroupNode[] cgs = SrConsistencyGroupsTableModel.getInstance().getLocalCGNodesOfCluster(localCluster, false);
        String selPrimTargetExposedOnVSwitch = ((TargetNode)this.wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_TARGET)).getExposedOnVSwitchName();
        ArrayList<ConsistencyGroupNode> finalList = new ArrayList<ConsistencyGroupNode>();
        for (int i = 0; i < cgs.length; ++i) {
            if (cgs[i].isPartial() || !DRReplicationStateConstant.INACTIVE.equals(cgs[i].getReplicationState()) || !DRModeConstant.NORMAL.equals(cgs[i].getMode())) continue;
            DRASyncPairNode[] cgPairs = cgs[i].getPairs();
            LUNode primLU = cgPairs[0].getPairPrimaryVolume().getLUNode();
            String primTargetVSwitch = null;
            if (primLU != null) {
                primTargetVSwitch = cgPairs[0].getPairPrimaryVolume().getLUNode().getTargetParent().getExposedOnVSwitchName();
            }
            if (primTargetVSwitch == null || !primTargetVSwitch.equals(selPrimTargetExposedOnVSwitch) || cgPairs[0].getPairSecondaryVolume() == null) continue;
            finalList.add(cgs[i]);
        }
        return finalList.toArray(new ConsistencyGroupNode[finalList.size()]);
    }

    private void updateCGList() {
        this.m_allCGNodes = SrConsistencyGroupsTableModel.getInstance().getAllExtendedElementNodes();
    }

    private void updateNextButton() {
        if (this.m_newCGBtt.isSelected()) {
            boolean enable = true;
            String newCG = this.m_cgNameField.getText();
            if (newCG.length() == 0) {
                enable = false;
            } else {
                int i = this.m_allCGNodes.length;
                while (i-- > 0) {
                    ExtendedElementNode cg = this.m_allCGNodes[i];
                    if (cg == null || !((Object)cg).toString().equals(newCG)) continue;
                    enable = false;
                    break;
                }
            }
            this.setNextButtonEnabled(enable);
        }
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_CG_SELECT_DESC);
    }

    private class CGFieldDocumentListener
    implements DocumentListener {
        private CGFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SrPairConsistencyGroupWizardPanel.this.updateNextButton();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SrPairConsistencyGroupWizardPanel.this.updateNextButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SrPairConsistencyGroupWizardPanel.this.updateNextButton();
        }
    }
}

