/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.pair;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.MergePolicyNode;
import com.sanrad.nms.client.data.dr.ReplicationPolicyNode;
import com.sanrad.nms.client.data.dr.SrJournalsTableModel;
import com.sanrad.nms.client.data.dr.TransferPolicyNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairCreateAnotherWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrDateField;
import com.sanrad.swing.components.SrEnterTimeField;
import com.sanrad.swing.components.SrTimeField;
import com.sanrad.swing.jwf.Wizard;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class SrPairAsyncSummaryWizardPanel
extends SrWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private WizardContext m_context;
    private Color m_valuesFgColor;
    private CreatePairTransaction m_createPairTransaction = new CreatePairTransaction();
    private Insets keyInsets = new Insets(0, 5, 3, 0);
    private Insets valInsets = new Insets(0, 0, 3, 0);

    public SrPairAsyncSummaryWizardPanel(WizardContext context) {
        this.m_context = context;
        this.m_valuesFgColor = ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.WIZARD_VALUE_LABEL_COLOR);
        this.initComponents();
        this.addWizardTransaction(new WizardTransaction(){

            @Override
            protected void transaction() {
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        SrPairAsyncSummaryWizardPanel.this.setNextButtonEnabled(false);
                        SrPairAsyncSummaryWizardPanel.this.setBackButtonEnabled(false);
                    }
                });
                this.stop();
            }
        });
    }

    protected WizardTransaction getCreatePairTrasaction() {
        return this.m_createPairTransaction;
    }

    protected void registerTransaction() {
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        SrClientLabel descLabel = new SrClientLabel(this.getTitle());
        descLabel.setHtmlMode(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 10, 10, 0);
        gbc.anchor = 18;
        this.add((Component)descLabel, gbc);
    }

    private void displayAllPanels() {
        SrPanel primAndSecDetailsPanel = new SrPanel(new GridLayout());
        SrPanel primPanel = this.createPriSidePanel();
        SrPanel secondaryPanel = this.createSecSidePanel();
        primAndSecDetailsPanel.add(primPanel);
        primAndSecDetailsPanel.add(secondaryPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 10, 10, 10);
        this.add((Component)primAndSecDetailsPanel, c);
        c.gridy = 2;
        c.weighty = 0.1;
        this.add((Component)this.createCenterPanel(), c);
    }

    private SrPanel createPriSidePanel() {
        String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_PRIMARY_TITLE);
        SiteNode siteNide = (SiteNode)this.m_context.getAttribute(SrPairWizardFrame.Key.PRIMARY_SITE);
        ClusterNode clusterNode = (ClusterNode)this.m_context.getAttribute(SrPairWizardFrame.Key.PRIMARY_CLUSTER);
        VolumeTreeNode volumeNode = (VolumeTreeNode)this.m_context.getAttribute(SrPairWizardFrame.Key.PRIMARY_VOLUME);
        VolumeTreeNode snaphot = (VolumeTreeNode)this.m_context.getAttribute(SrPairWizardFrame.Key.PRIMARY_SNAPSHOT);
        return this.createSingleSidePanel(title, siteNide, clusterNode, volumeNode, snaphot);
    }

    private SrPanel createSecSidePanel() {
        String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_SECONDARY_TITLE);
        SiteNode siteNide = (SiteNode)this.m_context.getAttribute(SrPairWizardFrame.Key.SECONDARY_SITE);
        ClusterNode clusterNode = (ClusterNode)this.m_context.getAttribute(SrPairWizardFrame.Key.SECONDARY_CLUSTER);
        VolumeTreeNode volumeNode = (VolumeTreeNode)this.m_context.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME);
        VolumeTreeNode snaphot = (VolumeTreeNode)this.m_context.getAttribute(SrPairWizardFrame.Key.SECONDARY_SNAPSHOT);
        return this.createSingleSidePanel(title, siteNide, clusterNode, volumeNode, snaphot);
    }

    private SrPanel createSingleSidePanel(String title, SiteNode siteNode, ClusterNode clusterNode, VolumeTreeNode volumeNode, VolumeTreeNode snaphot) {
        LUNode luNode = volumeNode.getLUNode();
        TargetNode targetNode = luNode.getTargetParent();
        JournalVolumeNode journal = this.getJournal(targetNode);
        SrPanel retVal = new SrPanel(new GridBagLayout());
        retVal.setBorder(new TitledBorder(new EtchedBorder(), title));
        SrClientLabel siteKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_SITE_KEY));
        siteKey.setHtmlMode(false);
        SrClientLabel clusterKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_CLUSTER_KEY));
        clusterKey.setHtmlMode(false);
        SrClientLabel volumeKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_VOLUME_KEY));
        volumeKey.setHtmlMode(false);
        SrClientLabel journalKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_JOURNAL_KEY));
        journalKey.setHtmlMode(false);
        SrClientLabel targetKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_TARGET_KEY));
        targetKey.setHtmlMode(false);
        SrClientLabel lunKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_LUN_KEY));
        lunKey.setHtmlMode(false);
        SrClientLabel snapshotKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_SNAPSHOT_KEY));
        snapshotKey.setHtmlMode(false);
        SrClientLabel siteVal = new SrClientLabel(siteNode.getAlias());
        siteVal.setForeground(this.m_valuesFgColor);
        siteVal.setHtmlMode(false);
        SrClientLabel clusterVal = new SrClientLabel(clusterNode.getAlias());
        clusterVal.setForeground(this.m_valuesFgColor);
        clusterVal.setHtmlMode(false);
        SrClientLabel volumeVal = new SrClientLabel(volumeNode.getAlias());
        volumeVal.setForeground(this.m_valuesFgColor);
        volumeVal.setHtmlMode(false);
        SrClientLabel journalVal = new SrClientLabel();
        journalVal.setForeground(this.m_valuesFgColor);
        journalVal.setHtmlMode(false);
        SrClientLabel targetVal = new SrClientLabel(targetNode.getAlias());
        targetVal.setForeground(this.m_valuesFgColor);
        targetVal.setHtmlMode(false);
        SrClientLabel lunVal = new SrClientLabel(luNode.toString());
        lunVal.setForeground(this.m_valuesFgColor);
        lunVal.setHtmlMode(false);
        SrClientLabel primSnapshotVal = new SrClientLabel();
        primSnapshotVal.setForeground(this.m_valuesFgColor);
        primSnapshotVal.setHtmlMode(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = this.keyInsets;
        retVal.add((Component)siteKey, c);
        ++c.gridy;
        retVal.add((Component)clusterKey, c);
        ++c.gridy;
        retVal.add((Component)volumeKey, c);
        if (journal != null) {
            ++c.gridy;
            retVal.add((Component)journalKey, c);
        }
        ++c.gridy;
        retVal.add((Component)targetKey, c);
        ++c.gridy;
        retVal.add((Component)lunKey, c);
        if (snaphot != null) {
            ++c.gridy;
            retVal.add((Component)snapshotKey, c);
        }
        c.insets = this.valInsets;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        retVal.add((Component)siteVal, c);
        ++c.gridy;
        retVal.add((Component)clusterVal, c);
        ++c.gridy;
        retVal.add((Component)volumeVal, c);
        if (journal != null) {
            journalVal.setText(journal.getAlias());
            ++c.gridy;
            retVal.add((Component)journalVal, c);
        }
        ++c.gridy;
        retVal.add((Component)targetVal, c);
        ++c.gridy;
        if (snaphot == null) {
            c.weighty = 1.0;
        }
        retVal.add((Component)lunVal, c);
        if (snaphot != null) {
            primSnapshotVal.setText(snaphot.getAlias());
            c.weighty = 1.0;
            ++c.gridy;
            retVal.add((Component)primSnapshotVal, c);
        }
        return retVal;
    }

    protected JournalVolumeNode getJournal(TargetNode target) {
        return SrJournalsTableModel.getInstance().getJournal(target.getExposedOnVSwitchNode());
    }

    protected SrPanel createCenterPanel() {
        SrPanel centerPanel = new SrPanel(new BorderLayout());
        SrPanel northPanel = new SrPanel(new GridBagLayout());
        Object cgObj = this.m_context.getAttribute(SrPairWizardFrame.Key.CG_OBJECT);
        String replicationMethodString = null;
        String replicationStartAtString = null;
        String replicationRunEveryString = null;
        if (cgObj != null && cgObj instanceof ConsistencyGroupNode) {
            ConsistencyGroupNode cgNode = (ConsistencyGroupNode)cgObj;
            ReplicationPolicyNode repNode = cgNode.getReplicationPolicy();
            replicationMethodString = repNode.toString();
            replicationStartAtString = this.getDateAndTimeString(repNode.getStartAtDateAndTime());
            replicationRunEveryString = SrEnterTimeField.getDisplayString(repNode.getRunEvery());
        } else {
            replicationMethodString = this.m_context.getAttribute(SrPairWizardFrame.Key.REPLICATION_METHOD).toString();
            replicationStartAtString = (String)this.m_context.getAttribute(SrPairWizardFrame.Key.REPLICATION_STARTAT_DISPLAY);
            replicationRunEveryString = (String)this.m_context.getAttribute(SrPairWizardFrame.Key.REPLICATION_RUN_EVERY_DISPLAY);
        }
        SrPanel replicationPolicyPanel = this.getPolicyPanel(replicationMethodString, replicationStartAtString, replicationRunEveryString);
        replicationPolicyPanel.setBorder(new TitledBorder(new EtchedBorder(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_PERLICATION_POLICY_KEY)));
        SrPanel initialSyncCGpanel = this.getInitialSyncPanel();
        SrClientLabel cgKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_CG_KEY));
        SrClientLabel cgVal = new SrClientLabel();
        cgVal.setHtmlMode(false);
        cgVal.setForeground(this.m_valuesFgColor);
        String cgAlias = null;
        if (cgObj == null) {
            cgAlias = "---";
        } else if (cgObj instanceof ConsistencyGroupNode) {
            cgAlias = ((ConsistencyGroupNode)cgObj).getAlias();
        } else if (cgObj instanceof String) {
            cgAlias = (String)cgObj;
        }
        cgVal.setText(cgAlias);
        Insets keyInsets = new Insets(5, 5, 0, 0);
        Insets valInsets = new Insets(5, 5, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        if (cgVal != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = keyInsets;
            initialSyncCGpanel.add((Component)cgKey, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = valInsets;
            gridBagConstraints.weightx = 1.0;
            initialSyncCGpanel.add((Component)cgVal, gridBagConstraints);
        }
        GridBagConstraints northPanelconstraints = new GridBagConstraints();
        northPanelconstraints.weightx = 1.0;
        northPanelconstraints.weighty = 1.0;
        northPanelconstraints.fill = 2;
        northPanelconstraints.gridx = 0;
        northPanelconstraints.gridy = 0;
        northPanelconstraints.insets = new Insets(5, 0, 0, 0);
        northPanel.add((Component)initialSyncCGpanel, northPanelconstraints);
        northPanelconstraints.gridy = 1;
        northPanel.add((Component)replicationPolicyPanel, northPanelconstraints);
        SrPanel transPanel = new SrPanel(new GridBagLayout());
        String mergeMethod = PolicyTypeConstant.MERGE_ONLY_CURRENT.toString();
        if (cgObj != null && cgObj instanceof ConsistencyGroupNode) {
            ConsistencyGroupNode cgNode = (ConsistencyGroupNode)cgObj;
            MergePolicyNode mergeNode = cgNode.getMergePolicy();
            mergeMethod = mergeNode.toString();
        }
        SrPanel mergerPolicyPanel = this.getPolicyPanel(mergeMethod, null, null);
        mergerPolicyPanel.setBorder(new TitledBorder(new EtchedBorder(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_MERGE_POLICY_KEY)));
        String transferMethodString = null;
        String transferStartAtString = null;
        String transferRunEveryString = null;
        if (cgObj != null && cgObj instanceof ConsistencyGroupNode) {
            ConsistencyGroupNode cgNode = (ConsistencyGroupNode)cgObj;
            TransferPolicyNode transNode = cgNode.getTransferPolicy();
            if (transNode != null) {
                transferMethodString = transNode.toString();
                transferStartAtString = this.getDateAndTimeString(transNode.getStartAtDateAndTime());
                transferRunEveryString = SrEnterTimeField.getDisplayString(transNode.getRunEvery());
            } else {
                transferMethodString = replicationMethodString;
                transferStartAtString = replicationStartAtString;
                transferRunEveryString = replicationRunEveryString;
            }
        } else {
            transferMethodString = this.m_context.getAttribute(SrPairWizardFrame.Key.TRANSFER_METHOD).toString();
            transferStartAtString = (String)this.m_context.getAttribute(SrPairWizardFrame.Key.TRANSFER_STARTAT_DISPLAY);
            transferRunEveryString = (String)this.m_context.getAttribute(SrPairWizardFrame.Key.TRANSFER_RUN_EVERY_DISPLAY);
        }
        SrPanel transferPolicyPanel = this.getPolicyPanel(transferMethodString, transferStartAtString, transferRunEveryString);
        transferPolicyPanel.setBorder(new TitledBorder(new EtchedBorder(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_TRANSFER_POLICY_KEY)));
        GridBagConstraints transPanelConstraints = new GridBagConstraints();
        transPanelConstraints.weightx = 1.0;
        transPanelConstraints.weighty = 1.0;
        transPanelConstraints.fill = 1;
        transPanelConstraints.gridx = 0;
        transPanelConstraints.gridy = 0;
        transPanelConstraints.insets = new Insets(0, 0, 5, 0);
        transPanel.add((Component)transferPolicyPanel, transPanelConstraints);
        transPanelConstraints.gridy = 1;
        transPanel.add((Component)mergerPolicyPanel, transPanelConstraints);
        centerPanel.add((Component)northPanel, "North");
        centerPanel.add((Component)transPanel, "Center");
        return centerPanel;
    }

    protected SrPanel getInitialSyncPanel() {
        SrPanel initialSyncCGpanel = new SrPanel(new GridBagLayout());
        Insets insets = new Insets(5, 5, 0, 0);
        SrClientLabel initialSyncKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_INITIAL_SYNC_POLICY_KEY));
        DRPairInitialSyncTypeConstant initialSyncPolicy = (DRPairInitialSyncTypeConstant)this.m_context.getAttribute(SrPairWizardFrame.Key.INITIAL_SYNC_TYPE);
        SrClientLabel initialSyncVal = new SrClientLabel(initialSyncPolicy.toString());
        initialSyncVal.setForeground(this.m_valuesFgColor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        initialSyncCGpanel.add((Component)initialSyncKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.insets = insets;
        initialSyncCGpanel.add((Component)initialSyncVal, gridBagConstraints);
        initialSyncCGpanel.setBorder(new EtchedBorder());
        return initialSyncCGpanel;
    }

    protected String getTitle() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_PANEL_TITLE);
    }

    private SrPanel getPolicyPanel(String method, String startAt, String runEvery) {
        SrPanel pan = new SrPanel(new GridBagLayout());
        SrClientLabel methodKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_METHOD_KEY));
        SrClientLabel startAtKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_START_AT_KEY));
        SrClientLabel runEveryKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_SUM_RUN_EVERY_KEY));
        Color valueFg = ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.WIZARD_VALUE_LABEL_COLOR);
        SrClientLabel methodVal = new SrClientLabel(method);
        methodVal.setForeground(valueFg);
        SrClientLabel startAtVal = null;
        if (startAt != null) {
            startAtVal = new SrClientLabel(startAt);
            startAtVal.setForeground(valueFg);
        }
        SrClientLabel runEveryVal = null;
        if (runEvery != null) {
            runEveryVal = new SrClientLabel(runEvery);
            runEveryVal.setForeground(valueFg);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        pan.add((Component)methodKey, gridBagConstraints);
        if (startAt == null) {
            gridBagConstraints.weightx = 1.0;
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        pan.add((Component)methodVal, gridBagConstraints);
        if (startAt != null) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            pan.add((Component)startAtKey, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            pan.add((Component)startAtVal, gridBagConstraints);
        }
        if (runEvery != null) {
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            pan.add((Component)runEveryKey, gridBagConstraints);
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 0;
            pan.add((Component)runEveryVal, gridBagConstraints);
        }
        return pan;
    }

    @Override
    public void display() {
        this.displayAllPanels();
        this.addWizardTransaction(this.getCreatePairTrasaction());
        this.registerTransaction();
        this.setButtonText("NEXT_I18N", Wizard.APPLY);
    }

    @Override
    public WizardPanel next() {
        return new SrPairCreateAnotherWizardPanel();
    }

    private SrFuture<Void> createAsyncPair() {
        SrFuture<Void> actFuture = null;
        WizardContext context = this.getWizardContext();
        DRPairInitialSyncTypeConstant initialSyncType = (DRPairInitialSyncTypeConstant)context.getAttribute(SrPairWizardFrame.Key.INITIAL_SYNC_TYPE);
        VolumeTreeNode primaryVolume = (VolumeTreeNode)context.getAttribute(SrPairWizardFrame.Key.PRIMARY_VOLUME);
        LUNode localLu = primaryVolume.getLUNode();
        TargetNode localTarget = null;
        if (localLu != null) {
            localTarget = localLu.getTargetParent();
        }
        SnapshotVolumeNode primarySnapshot = (SnapshotVolumeNode)context.getAttribute(SrPairWizardFrame.Key.PRIMARY_SNAPSHOT);
        JournalVolumeNode primaryJournal = null;
        if (localTarget != null) {
            primaryJournal = this.getJournal(localTarget);
        }
        VolumeTreeNode secondaryVolume = (VolumeTreeNode)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME);
        LUNode remoteLun = (LUNode)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_LUN);
        TargetNode remoteTarget = (TargetNode)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_TARGET);
        SnapshotVolumeNode secondarySnapshot = (SnapshotVolumeNode)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_SNAPSHOT);
        JournalVolumeNode secondaryJournal = null;
        if (remoteTarget != null) {
            secondaryJournal = this.getJournal(remoteTarget);
        }
        HashMap<ClientParameterCode, Object> scondarySnapshotParams = null;
        Boolean isOfflineIsyncVolume = (Boolean)context.getAttribute(SrPairWizardFrame.Key.IS_OFFLINE_LOCAL_VOLUME_SELECTED);
        Boolean isSecondarySnapshotSelected = (Boolean)context.getAttribute(SrPairWizardFrame.Key.IS_SECONDARY_SNAPSHOT_SELECTED);
        if (isSecondarySnapshotSelected != null && isSecondarySnapshotSelected.booleanValue() && isOfflineIsyncVolume.booleanValue()) {
            String snapAlias = (String)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_SNAPSHOT_ALIAS);
            Integer snapThreshold = (Integer)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_SNAPSHOT_THRESHOLD);
            VolumeTreeNode snapChild = (VolumeTreeNode)context.getAttribute(SrPairWizardFrame.Key.SECONDARY_SNAPSHOT_CHILD);
            scondarySnapshotParams = new HashMap<ClientParameterCode, Object>();
            scondarySnapshotParams.put(ClientParameterCode.VOLUME_ALIAS, snapAlias);
            scondarySnapshotParams.put(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, snapThreshold);
            scondarySnapshotParams.put(ClientParameterCode.VOLUME_CHILDREN, snapChild);
        }
        if (!((Boolean)this.wizardContext.getAttribute(SrPairWizardFrame.Key.IS_NEW_CG)).booleanValue()) {
            ConsistencyGroupNode cg = (ConsistencyGroupNode)context.getAttribute(SrPairWizardFrame.Key.CG_OBJECT);
            actFuture = DRASyncPairManager.getInstance().createPair(initialSyncType, primaryVolume, secondaryVolume, localTarget != null ? localTarget.getName() : null, localLu != null ? localLu.getLUN() : null, remoteTarget != null ? remoteTarget.getName() : null, remoteLun.getLUN(), primarySnapshot, secondarySnapshot, scondarySnapshotParams, primaryJournal, secondaryJournal, cg);
        } else {
            String newCGName = (String)context.getAttribute(SrPairWizardFrame.Key.CG_OBJECT);
            PolicyTypeConstant pitPolicyType = (PolicyTypeConstant)context.getAttribute(SrPairWizardFrame.Key.REPLICATION_METHOD);
            Long pitRunEvery = (Long)context.getAttribute(SrPairWizardFrame.Key.REPLICATION_RUN_EVERY);
            Long pitStartAt = (Long)context.getAttribute(SrPairWizardFrame.Key.REPLICATION_START_AT);
            HashMap<ClientParameterCode, Serializable> pitPolicy = new HashMap<ClientParameterCode, Serializable>(3);
            pitPolicy.put(ClientParameterCode.DR_POLICY_METHOD, pitPolicyType);
            pitPolicy.put(ClientParameterCode.DR_POLICY_RUN_EVERY, pitRunEvery);
            pitPolicy.put(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME, pitStartAt);
            PolicyTypeConstant transferPolicyType = (PolicyTypeConstant)context.getAttribute(SrPairWizardFrame.Key.TRANSFER_METHOD);
            Long transferRunEvery = (Long)context.getAttribute(SrPairWizardFrame.Key.TRANSFER_RUN_EVERY);
            Long transferStartAt = (Long)context.getAttribute(SrPairWizardFrame.Key.TRANSFER_START_AT);
            HashMap<ClientParameterCode, Serializable> transferPolicy = new HashMap<ClientParameterCode, Serializable>(3);
            transferPolicy.put(ClientParameterCode.DR_POLICY_METHOD, transferPolicyType);
            transferPolicy.put(ClientParameterCode.DR_POLICY_RUN_EVERY, transferRunEvery);
            transferPolicy.put(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME, transferStartAt);
            HashMap<ClientParameterCode, Serializable> mergePolicy = new HashMap<ClientParameterCode, Serializable>(2);
            mergePolicy.put(ClientParameterCode.DR_POLICY_METHOD, PolicyTypeConstant.MERGE_ONLY_CURRENT);
            mergePolicy.put(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME, new Long(60L));
            actFuture = newCGName != null ? DRASyncPairManager.getInstance().createPair(initialSyncType, primaryVolume, secondaryVolume, localTarget != null ? localTarget.getName() : null, localLu != null ? localLu.getLUN() : null, remoteTarget != null ? remoteTarget.getName() : null, remoteLun.getLUN(), primarySnapshot, secondarySnapshot, scondarySnapshotParams, primaryJournal, secondaryJournal, newCGName, pitPolicy, transferPolicy, mergePolicy) : DRASyncPairManager.getInstance().createPair(initialSyncType, primaryVolume, secondaryVolume, localTarget != null ? localTarget.getName() : null, localLu != null ? localLu.getLUN() : null, remoteTarget != null ? remoteTarget.getName() : null, remoteLun.getLUN(), primarySnapshot, secondarySnapshot, scondarySnapshotParams, primaryJournal, secondaryJournal, pitPolicy, transferPolicy, mergePolicy);
        }
        return actFuture;
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public void back() {
    }

    public String getDateAndTimeString(long time) {
        if (time == 0L) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_NEW_CG_PARAMS_START_AT_IMMEDIATE_RADIO_DESC);
        }
        StringBuffer buff = new StringBuffer();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        buff.append(SrDateField.getDateString(String.valueOf(year), SrDateField.MONTHS[month - 1], SrDateField.DAYS[day - 1]));
        buff.append(" ");
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        buff.append(SrTimeField.getTimeString(String.valueOf(hours), String.valueOf(minutes), String.valueOf(seconds)));
        return buff.toString();
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SUMMARY_DESC);
    }

    private class CreatePairTransaction
    extends WizardTransaction {
        private CreatePairTransaction() {
        }

        @Override
        protected void transaction() {
            SrFuture actFuture = SrPairAsyncSummaryWizardPanel.this.createAsyncPair();
            this.waitAndBlockActions(actFuture, SrPairAsyncSummaryWizardPanel.this.getOwner());
        }
    }
}

