/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.pair;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.DRWizardValidation;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.wizard.SrWizardFrame;
import java.util.ArrayList;
import java.util.List;

public class PairWizardValidations {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final String ISCSI_TRANS_TYPE = PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString();

    private PairWizardValidations() {
    }

    public static boolean isVolumeValidAsPrimary(VolumeTreeNode volume, WizardContext wizardContext) {
        DirectAccessDeviceNode disk;
        if (!DRWizardValidation.isRedundant(volume)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary resource, it is not redundant."));
            return false;
        }
        if (volume instanceof DirectAccessDeviceNode && ISCSI_TRANS_TYPE.equals((disk = (DirectAccessDeviceNode)volume).getTransportType())) {
            TargetNode target = TargetManager.getInstance().getTargetByName(disk.getEntityName());
            SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
            if (target != null && sites.length == 2) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary resource, it is an iSCSI disk which its local target defined on the secondary cluster."));
                return false;
            }
        }
        return PairWizardValidations.canBePrimaryResourceOnTarget(volume) && !VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(volume);
    }

    public static boolean isVolumeValidAsSecondary(VolumeTreeNode volume, VolumeTreeNode m_primVolume, WizardContext wizardContext) {
        DirectAccessDeviceNode disk;
        if (!DRWizardValidation.isRedundant(volume)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR secondary resource, it is not redundant."));
            return false;
        }
        if (volume instanceof DirectAccessDeviceNode && ISCSI_TRANS_TYPE.equals((disk = (DirectAccessDeviceNode)volume).getTransportType())) {
            SiteNode primarySite = (SiteNode)wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_SITE);
            TargetNode target = TargetManager.getInstance().getTargetByName(disk.getEntityName());
            if (target != null && primarySite.equals(SystemRootNode.getInstance().getSiteNode(target))) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR secondary resource, it is an iSCSI disk which its local target defined on the primary cluster."));
                return false;
            }
        }
        Boolean isOfflineLocalCopy = (Boolean)wizardContext.getAttribute(SrPairWizardFrame.Key.IS_OFFLINE_LOCAL_VOLUME_SELECTED);
        SiteNode secondarySite = (SiteNode)wizardContext.getAttribute(SrPairWizardFrame.Key.SECONDARY_SITE);
        if (!volume.getAccessibleSpace().equals(m_primVolume.getAccessibleSpace())) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR secondary resource, its Accessible Space is " + volume.getAccessibleSpace() + " and the primary is " + m_primVolume.getAccessibleSpace() + " ."));
            return false;
        }
        if (isOfflineLocalCopy.booleanValue()) {
            if (volume == m_primVolume || !VolumeManager.getInstance().getDROfflineLocalCopyValidator().isValidForOfflineLocalCopy(volume, secondarySite)) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR secondary resource, offline-copy-resource reasons."));
                return false;
            }
        } else if (VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(volume)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR secondary resource, offline-copy-resource reasons."));
            return false;
        }
        return PairWizardValidations.canBeSecondaryResourceOnTarget(volume);
    }

    private static boolean canBePrimaryResourceOnTarget(VolumeTreeNode volume) {
        if (volume.getLUNode() != null) {
            LUNode lun = volume.getLUNode();
            TargetNode target = null;
            if (lun != null) {
                target = volume.getLUNode().getTargetParent();
            }
            if (target != null) {
                for (LUNode luNode : target.getLuNodes()) {
                    VolumeTreeNode pairVolume;
                    VolumeTreeNode luVolume = luNode.getVolumeChild();
                    DRASyncPairManager.getInstance();
                    DRPairNode pair = DRASyncPairManager.getPairContainingVolume(luVolume);
                    if (pair == null || (pairVolume = pair.getPairPrimaryVolume()) == luVolume) continue;
                    theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary resource on its own target."));
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean canBeSecondaryResourceOnTarget(VolumeTreeNode volume) {
        if (volume.getLUNode() != null) {
            LUNode lun = volume.getLUNode();
            TargetNode target = null;
            if (lun != null) {
                target = volume.getLUNode().getTargetParent();
            }
            if (target != null) {
                for (LUNode luNode : target.getLuNodes()) {
                    VolumeTreeNode pairSecVolume;
                    VolumeTreeNode luVolume = luNode.getVolumeChild();
                    DRPairNode pair = DRPairManager.getPairContainingVolume(luVolume);
                    if (pair == null || (pairSecVolume = pair.getPairSecondaryVolume()) == luVolume) continue;
                    theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR secondary resource on its own target."));
                    return false;
                }
            }
        }
        return true;
    }

    public static String validateCanCreatePair() {
        if (SrWizardFrame.isAlreadyRunningWizard(SrPairWizardFrame.class)) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_PAIR_CREATION_WIZARD_IS_ALREADY_OPENED);
        }
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        if (sites.length <= 1) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_PAIR_CREATION_LESS_THAN_TWO_SITES_CONFIGURED);
        }
        if (PairWizardValidations.getSitesWithConnectedCluster().size() < 2) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_PAIR_CREATION_NOT_ENOUGH_CONNECTED_CLUSTERS);
        }
        if (PairWizardValidations.getSitesWithNormalStateCluster().size() < 1) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_PAIR_CREATION_NOT_ENOUGH_NORMAL_CLUSTERS);
        }
        return null;
    }

    public static List<SiteNode> getSitesWithNormalStateCluster() {
        SiteNode[] sites;
        ArrayList<SiteNode> list = new ArrayList<SiteNode>();
        for (SiteNode site : sites = SystemRootNode.getInstance().getSiteNodes()) {
            if (PairWizardValidations.getNormalStateClusters(site).isEmpty()) continue;
            list.add(site);
        }
        return list;
    }

    public static List<SiteNode> getSitesWithConnectedCluster() {
        SiteNode[] sites;
        ArrayList<SiteNode> list = new ArrayList<SiteNode>();
        for (SiteNode site : sites = SystemRootNode.getInstance().getSiteNodes()) {
            if (PairWizardValidations.getConnectedClusters(site).isEmpty()) continue;
            list.add(site);
        }
        return list;
    }

    public static List<ClusterNode> getConnectedClusters(SiteNode aSite) {
        ClusterNode[] clusters;
        ArrayList<ClusterNode> list = new ArrayList<ClusterNode>();
        for (ClusterNode cluster : clusters = aSite.getSiteClusters()) {
            if (cluster.isInDiscoveryProcess() || !cluster.hasConnectedVSwitches()) continue;
            list.add(cluster);
        }
        return list;
    }

    public static List<ClusterNode> getNormalStateClusters(SiteNode aSite) {
        ClusterNode[] clusters;
        ArrayList<ClusterNode> list = new ArrayList<ClusterNode>();
        for (ClusterNode cluster : clusters = aSite.getSiteClusters()) {
            if (cluster.isInDiscoveryProcess() || !cluster.hasConnectedVSwitches() || cluster.isUnderTakeover()) continue;
            list.add(cluster);
        }
        return list;
    }
}

