/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.journal;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.SrMsgAndGoWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.journal.JournalWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalCreateAnotherWizardPanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;

public class SrJournalSummaryWizardPanel
extends SrDRWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private String m_alias;
    private VSwitchNode m_targetVSwitch;
    private Integer m_threshold;
    private VolumeTreeNode m_resource;
    private ClusterNode m_cluster;
    private int m_numberOfJournalCreationsAllowed = 0;
    private int m_numberOfJournalCreationsAllowedOnCluster = 0;
    private SrClientLabel m_siteLabel;
    private SrClientLabel m_clusterLabel;
    private SrClientLabel m_resourceLabel;
    private SrClientLabel m_aliasLabel;
    private SrClientLabel m_vswitchLabel;
    private SrClientLabel m_thresholdLabel;
    private CreateJournalTransaction m_createJournalTransaction = new CreateJournalTransaction();
    private JournalCreationListener myVolumeListener = new JournalCreationListener();

    public SrJournalSummaryWizardPanel() {
        this.setSavedAsPrevious(false);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainPanelconstraints = new GridBagConstraints();
        mainPanelconstraints.fill = 1;
        mainPanelconstraints.gridx = 0;
        mainPanelconstraints.gridy = 0;
        SrClientLabel descLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SUMMARY_PANEL_TITLE));
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 5, 40);
        constraints.fill = 2;
        descriptionPanel.add((Component)descLabel, constraints);
        this.add((Component)descriptionPanel, mainPanelconstraints);
        SrPanel detailPanel = new SrPanel(new GridBagLayout());
        detailPanel.setBorder(BorderFactory.createEtchedBorder());
        Color valuesFgColor = new Color(102, 102, 255);
        SrClientLabel siteKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SUMMARY_SITE_KEY));
        SrClientLabel clusterKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SUMMARY_CLUSTER_KEY));
        SrClientLabel resourceKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SUMMARY_RESOURCE_KEY));
        SrClientLabel aliasKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SUMMARY_ALIAS_KEY));
        SrClientLabel vswitchKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SUMMARY_TARGET_VSWITCH_KEY));
        SrClientLabel thresholdKey = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SUMMARY_THRESHOLD_KEY));
        this.m_siteLabel = new SrClientLabel();
        this.m_siteLabel.setForeground(valuesFgColor);
        this.m_clusterLabel = new SrClientLabel();
        this.m_clusterLabel.setForeground(valuesFgColor);
        this.m_resourceLabel = new SrClientLabel();
        this.m_resourceLabel.setForeground(valuesFgColor);
        this.m_aliasLabel = new SrClientLabel();
        this.m_aliasLabel.setForeground(valuesFgColor);
        this.m_vswitchLabel = new SrClientLabel();
        this.m_vswitchLabel.setForeground(valuesFgColor);
        this.m_thresholdLabel = new SrClientLabel();
        this.m_thresholdLabel.setForeground(valuesFgColor);
        Insets keyInsets = new Insets(0, 10, 5, 0);
        Insets valInsets = new Insets(0, 0, 5, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = keyInsets;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        detailPanel.add((Component)siteKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.m_siteLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)clusterKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.m_clusterLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)resourceKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.m_resourceLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)aliasKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.m_aliasLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)vswitchKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.m_vswitchLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)thresholdKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.m_thresholdLabel, gridBagConstraints);
        mainPanelconstraints.gridy = 1;
        mainPanelconstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)detailPanel, mainPanelconstraints);
    }

    @Override
    public void display() {
        VolumeManager.getInstance().addVolumeListener(this.myVolumeListener);
        this.m_cluster = (ClusterNode)this.wizardContext.getAttribute(JournalWizardContextKeys.SELECTED_CLUSTER);
        this.m_alias = (String)this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_ALIAS);
        if (this.m_alias == null) {
            this.m_alias = "";
        }
        this.m_alias.trim();
        this.m_targetVSwitch = (VSwitchNode)this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_VSWITCH);
        this.m_threshold = new Integer((String)this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_THRESHOLD));
        this.m_resource = (VolumeTreeNode)this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_CHILD_VOLUME);
        this.m_numberOfJournalCreationsAllowed = VolumeManager.getInstance().getJournalCreateAllowedCount() - 1;
        this.m_numberOfJournalCreationsAllowedOnCluster = VolumeManager.getInstance().getJournalCreateAllowedCount(this.m_cluster) - 1;
        if (this.m_numberOfJournalCreationsAllowedOnCluster + 1 > 0) {
            this.addWizardTransaction(this.m_createJournalTransaction);
        }
        this.m_siteLabel.setText(this.wizardContext.getAttribute(JournalWizardContextKeys.SELECTED_SITE).toString());
        this.m_clusterLabel.setText(this.wizardContext.getAttribute(JournalWizardContextKeys.SELECTED_CLUSTER).toString());
        this.m_resourceLabel.setText(this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_CHILD_VOLUME).toString());
        String jourAlias = this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_ALIAS).toString();
        if (jourAlias.length() == 0) {
            jourAlias = "(default)";
        }
        this.m_aliasLabel.setText(jourAlias);
        this.m_vswitchLabel.setText(this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_VSWITCH).toString());
        this.m_thresholdLabel.setText(this.wizardContext.getAttribute(JournalWizardContextKeys.JOURNAL_THRESHOLD).toString() + "%");
    }

    @Override
    public WizardPanel next() {
        WizardPanel nextPanel = null;
        Boolean isAutoCreate = (Boolean)this.wizardContext.getAttribute(JournalWizardContextKeys.IS_AUTO_SEARCH_FOR_OPTIONAL_JOURNAL);
        nextPanel = isAutoCreate != null && isAutoCreate.booleanValue() ? (this.m_numberOfJournalCreationsAllowed > 0 ? new SrJournalCreateAnotherWizardPanel() : new SrMsgAndGoWizardPanel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_END_MSG)){

            @Override
            protected String getQuestionString() {
                return null;
            }

            @Override
            public void display() {
                this.setBackButtonEnabled(false);
                this.setCancelButtonEnabled(false);
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public WizardPanel next() {
                return null;
            }

            @Override
            public boolean canFinish() {
                return true;
            }

            @Override
            public boolean validateFinish(List list) {
                return true;
            }
        }) : (WizardPanel)this.wizardContext.getAttribute(JournalWizardContextKeys.NEXT_OUTER_WIZARD_PANEL);
        return nextPanel;
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public void back() {
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this.myVolumeListener);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : (String)this.wizardContext.getAttribute(JournalWizardContextKeys.SUMMARY_DESCRIPTION);
    }

    private class CreateJournalTransaction
    extends WizardTransaction {
        private CreateJournalTransaction() {
        }

        @Override
        public void transaction() {
            SrFuture<Void> actFuture = VolumeManager.getInstance().createJournalVolume(SrJournalSummaryWizardPanel.this.m_alias, SrJournalSummaryWizardPanel.this.m_threshold, SrJournalSummaryWizardPanel.this.m_resource, SrJournalSummaryWizardPanel.this.m_targetVSwitch);
            this.waitAndBlockActions(actFuture, SrJournalSummaryWizardPanel.this.getOwner());
            if (SrJournalSummaryWizardPanel.this.wizardContext.getAttribute(JournalWizardContextKeys.CREATED_JOURNAL) == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Journal wizard: creation future returned before journal data");
            }
        }
    }

    private class JournalCreationListener
    extends VolumeAdapter {
        private JournalCreationListener() {
        }

        @Override
        public void volumeCreate(VolumeEvent e) {
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(e.getStub());
            if (node != null && node instanceof JournalVolumeNode) {
                JournalVolumeNode jourNode = (JournalVolumeNode)node;
                if ((SrJournalSummaryWizardPanel.this.m_alias.equals("") || jourNode.getAlias().equals(SrJournalSummaryWizardPanel.this.m_alias)) && SystemRootNode.getInstance().getClusterNodeOfSource(jourNode) == SrJournalSummaryWizardPanel.this.m_cluster) {
                    SrJournalSummaryWizardPanel.this.wizardContext.setAttribute(JournalWizardContextKeys.CREATED_JOURNAL, jourNode, SrJournalSummaryWizardPanel.this);
                }
            }
        }
    }
}

