/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.journal;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrMsgAndGoWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectSiteClusterVSwitchPanel;
import com.sanrad.nms.client.gui.dr.wizards.journal.JournalWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.journal.JournalWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalCreateVolumeWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalSelectResourcePanel;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.SrWizardPanel;
import java.util.ArrayList;
import java.util.List;

public class SrJournalSelectSiteClusterPanel
extends SrSelectSiteClusterVSwitchPanel {
    @Override
    public WizardPanel next() {
        this.removeListeners();
        ClusterNode cluster = (ClusterNode)this.m_clusterVSwitchCombo.getSelectedItem();
        SiteNode site = (SiteNode)this.m_sitesCombo.getSelectedItem();
        this.getWizardContext().setAttribute(JournalWizardContextKeys.SELECTED_CLUSTER, cluster, this);
        this.getWizardContext().setAttribute(JournalWizardContextKeys.SELECTED_SITE, site, this);
        this.getWizardContext().setAttribute(JournalWizardContextKeys.SELECTED_CLUSTER_DISPLAY, cluster, this);
        this.getWizardContext().setAttribute(JournalWizardContextKeys.SELECTED_SITE_DISPLAY, site, this);
        SrWizardPanel nextStep = null;
        SrJournalSelectResourcePanel selResourceStep = new SrJournalSelectResourcePanel(cluster);
        selResourceStep.setWizardContext(this.wizardContext);
        SrResourceTableModel model = selResourceStep.getResourceTableModel(cluster, null);
        selResourceStep.setTableModel(model);
        nextStep = selResourceStep.isTableEmpty() ? new SrMsgAndGoWizardPanel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_SOURCE_NOT_AVAILABLE_MSG), new SrJournalCreateVolumeWizardPanel(cluster)) : selResourceStep;
        return nextStep;
    }

    @Override
    public void display() {
        super.display();
        this.setBackButtonEnabled(false);
        this.setNextButtonEnabled(this.hasNext());
        this.wizardContext.setAttribute(JournalWizardContextKeys.IS_AUTO_SEARCH_FOR_OPTIONAL_JOURNAL, Boolean.TRUE, this);
    }

    @Override
    protected String getClusterVSwitchSelectionDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_PANEL1_KEY_CLUSTER_VSWITCH_DESC);
    }

    @Override
    protected String getPanelTitleDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_PANEL1_DESC);
    }

    @Override
    protected String getSiteSelectionDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_PANEL1_KEY_SITE_DESC);
    }

    protected Object[] getClusterVSwitchList(Object site) {
        ArrayList<ClusterNode> newList = new ArrayList<ClusterNode>();
        ClusterNode[] clusters = ((SiteNode)site).getSiteClusters();
        if (clusters != null && clusters.length > 0) {
            for (int i = 0; i < clusters.length; ++i) {
                if (!VolumeManager.getInstance().isCreateAnotherJournalAllowed(clusters[i])) continue;
                newList.add(clusters[i]);
            }
        }
        return newList.toArray();
    }

    @Override
    public boolean validateNext(List list) {
        return this.m_sitesCombo.isEnabled();
    }

    @Override
    public boolean canFinish() {
        return !this.m_sitesCombo.isEnabled();
    }

    @Override
    public boolean hasNext() {
        return this.m_sitesCombo.isEnabled();
    }

    @Override
    public boolean validateFinish(List list) {
        return true;
    }

    @Override
    public void back() {
    }

    @Override
    public Object[] getSiteList() {
        SiteNode backupSite = (SiteNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.BACKUP_SITE);
        List<SiteNode> siteList = JournalWizardValidations.getSitesWithNoJournal();
        if (backupSite != null) {
            siteList.remove(backupSite);
        }
        return siteList.toArray();
    }
}

