/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.journal;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectResourceWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.journal.JournalWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.journal.JournalWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalAliasAndVSwitchWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalCreateVolumeWizardPanel;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;

public class SrJournalSelectResourcePanel
extends SrSelectResourceWizardPanel {
    public SrJournalSelectResourcePanel(ClusterNode cluster) {
        super(cluster);
    }

    @Override
    protected WizardPanel doNext() {
        VolumeTreeNode volume = this.getSelectedVolume();
        this.getWizardContext().setAttribute(JournalWizardContextKeys.JOURNAL_CHILD_VOLUME, volume, this);
        return new SrJournalAliasAndVSwitchWizardPanel(this.m_clusterNode);
    }

    @Override
    protected SrWizardPanel getCreateVolumePanel() {
        SrJournalCreateVolumeWizardPanel panel = new SrJournalCreateVolumeWizardPanel(this.m_clusterNode);
        panel.setDescription((String)this.wizardContext.getAttribute(JournalWizardContextKeys.CREATE_VOLUME_DESCRIPTION));
        return panel;
    }

    @Override
    public SrResourceTableModel getResourceTableModel(ClusterNode cluster, WizardContext context) {
        return new SrJournalResourceTableModel(cluster);
    }

    @Override
    protected String getPanelTitleDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_WIZ_SELECT_RESOURCE_TITLE);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : (String)this.wizardContext.getAttribute(JournalWizardContextKeys.SELECT_VOLUME_DESCRIPTION);
    }

    @Override
    protected ContextKey getContextKeyForSelectedResource() {
        return JournalWizardContextKeys.JOURNAL_CHILD_VOLUME;
    }

    public class SrJournalResourceTableModel
    extends SrResourceTableModel {
        public SrJournalResourceTableModel(ClusterNode cluster) {
            super(cluster);
            this.initModel();
        }

        @Override
        protected boolean isVolumeValid(VolumeTreeNode volume) {
            return JournalWizardValidations.isValidJournalChild(volume, SrJournalSelectResourcePanel.this.wizardContext);
        }
    }
}

