/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.journal;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.journal.JournalWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalSummaryWizardPanel;
import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrPercentTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.text.LengthLimitedDocument;
import com.sanrad.util.SrConstantsBundleKeys;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SrJournalAliasAndVSwitchWizardPanel
extends SrDRWizardPanel
implements PropertyPanelValidationListener {
    private JournalPropertyPanel m_propPanel;

    public SrJournalAliasAndVSwitchWizardPanel(ClusterNode clusterNode) {
        this.setLayout(new BorderLayout());
        this.add((Component)SrJournalAliasAndVSwitchWizardPanel.getDescriptionPanel(), "North");
        this.m_propPanel = new JournalPropertyPanel(this, clusterNode);
        this.add((Component)this.m_propPanel, "Center");
    }

    public JournalPropertyPanel getPropertyPanel() {
        return this.m_propPanel;
    }

    public static SrPanel getDescriptionPanel() {
        SrClientLabel descLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_DLG_INSTRUCTION));
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 5, 0, 40);
        constraints.fill = 1;
        descriptionPanel.add((Component)descLabel, constraints);
        return descriptionPanel;
    }

    @Override
    public void display() {
        this.m_propPanel.onUpdateEvent(null);
        this.m_propPanel.startCurserAt(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_ALIAS_KEY));
        VSwitchNode selectedVswitch = (VSwitchNode)this.wizardContext.getAttribute(JournalWizardContextKeys.PREDEFINED_JOURNAL_VSWITCH);
        if (selectedVswitch != null) {
            this.m_propPanel.m_vswitchCombo.setSelectedItem(selectedVswitch);
            this.m_propPanel.m_vswitchCombo.setEnabled(false);
        } else {
            this.m_propPanel.m_vswitchCombo.setEnabled(true);
        }
    }

    @Override
    public WizardPanel next() {
        String alias = (String)this.m_propPanel.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_ALIAS_KEY));
        this.getWizardContext().setAttribute(JournalWizardContextKeys.JOURNAL_ALIAS, alias, this);
        SrComboBox targetVSwitches = (SrComboBox)this.m_propPanel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_VSWITCH_KEY));
        VSwitchNode vswitchNode = (VSwitchNode)targetVSwitches.getSelectedItem();
        this.getWizardContext().setAttribute(JournalWizardContextKeys.JOURNAL_VSWITCH, vswitchNode, this);
        String threshold = (String)this.m_propPanel.getPropertyVal(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_PERCENTAGE_THRESHOLD_KEY));
        this.getWizardContext().setAttribute(JournalWizardContextKeys.JOURNAL_THRESHOLD, threshold, this);
        return new SrJournalSummaryWizardPanel();
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public void onPanelPropertyChanged(PropertyPanelValidationEvent e) {
        Vector fields = e.getNonValidFields();
        boolean allowFinish = false;
        if (fields.isEmpty()) {
            allowFinish = true;
        }
        this.setNextButtonEnabled(allowFinish);
    }

    @Override
    public void back() {
        this.wizardContext.setAttribute(JournalWizardContextKeys.JOURNAL_CHILD_VOLUME, null, this);
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : (String)this.wizardContext.getAttribute(JournalWizardContextKeys.PARAMS_DESCRIPTION);
    }

    public class JournalPropertyPanel
    extends SrPropertyPanel {
        private SrJournalAliasAndVSwitchWizardPanel m_parent;
        private SrComboBox m_vswitchCombo;

        public JournalPropertyPanel(SrJournalAliasAndVSwitchWizardPanel parent, ClusterNode clusterNode) {
            super(SrJournalAliasAndVSwitchWizardPanel.class.toString(), false, true, false);
            this.m_parent = parent;
            List<VSwitchNode> vSwitches = clusterNode.getClusterVSwitches();
            ArrayList<VSwitchNode> vswitchList = new ArrayList<VSwitchNode>();
            for (VSwitchNode vswitch : vSwitches) {
                if (VolumeManager.getInstance().hasJournalOnVSwitch(vswitch)) continue;
                vswitchList.add(vswitch);
            }
            this.skipLines(2);
            this.m_vswitchCombo = new SrComboBox(vswitchList);
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_VSWITCH_KEY), this.m_vswitchCombo);
            this.skipLines(1);
            String jourAliasLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_ALIAS_KEY);
            SrTextField jourAliasVal = new SrTextField();
            jourAliasVal.setDocument(new LengthLimitedDocument(Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.ALIAS_MAX_LENGTH))));
            SrWidget jourAliasField = new SrWidget(jourAliasLabel, jourAliasVal);
            this.addProperty(jourAliasLabel, jourAliasField);
            this.skipLines(1);
            SrPercentTextField threshold = new SrPercentTextField();
            threshold.setValue(Integer.toString(VolumeManager.JOURNAL_DEFAULT_THRESHOLD_VALUE));
            this.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_PERCENTAGE_THRESHOLD_KEY), (SrComponent)threshold);
            this.addValidationListener(this.m_parent);
        }
    }
}

