/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.journal;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.dr.wizards.DRWizardValidation;
import com.sanrad.nms.client.gui.dr.wizards.pair.PairWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.swing.jwf.WizardContext;
import java.util.ArrayList;
import java.util.List;

public class JournalWizardValidations {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final String ISCSI_TRANS_TYPE = PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString();

    private JournalWizardValidations() {
    }

    public static boolean isValidJournalChild(VolumeTreeNode volume, WizardContext wizardContext) {
        VolumeTreeNode secondaryVol;
        DirectAccessDeviceNode disk;
        if (!DRWizardValidation.isRedundant(volume)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a journal child, it is not redundant."));
            return false;
        }
        if (volume.isExposed()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a journal child, it is exposed."));
            return false;
        }
        if (volume instanceof DirectAccessDeviceNode && ISCSI_TRANS_TYPE.equals((disk = (DirectAccessDeviceNode)volume).getTransportType())) {
            TargetNode target;
            TargetNode target2;
            ClusterNode primaryCluster = (ClusterNode)wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_CLUSTER);
            if (primaryCluster != null && (target2 = TargetManager.getInstance().getTargetByName(primaryCluster, disk.getEntityName())) != null) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a secondary journal child, it is an iSCSI disk which its local target defined on the primary cluster."));
                return false;
            }
            ClusterNode secondaryCluster = (ClusterNode)wizardContext.getAttribute(SrPairWizardFrame.Key.PRIMARY_CLUSTER);
            if (secondaryCluster != null && (target = TargetManager.getInstance().getTargetByName(secondaryCluster, disk.getEntityName())) != null) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a primary journal child, it is an iSCSI disk which its local target defined on the secondary cluster."));
                return false;
            }
        }
        if ((secondaryVol = (VolumeTreeNode)wizardContext.getAttribute(SrPairWizardFrame.Key.SECONDARY_VOLUME)) != null) {
            if (secondaryVol == volume) {
                theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a journal child, it is the selected secondary volume."));
                return false;
            }
            Boolean isOffLineCopy = (Boolean)wizardContext.getAttribute(SrPairWizardFrame.Key.IS_OFFLINE_LOCAL_VOLUME_SELECTED);
            if (isOffLineCopy != null && isOffLineCopy.booleanValue()) {
                ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(volume);
                ClusterNode secOfflineVolCluster = SystemRootNode.getInstance().getClusterNodeOfSource(secondaryVol);
                if (secOfflineVolCluster == cluster && VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(volume, secondaryVol)) {
                    theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource, offline-copy-resource reasons."));
                    theLogger.logAndAssert(SrLogCategories.ERROR, "The offline-copy-GDR-volume is not completed feature");
                    return false;
                }
            }
        }
        if (VolumeManager.getInstance().getDROfflineLocalCopyValidator().isDiskChildUsedByOfflineLocalCopy(volume)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new SrResourceTableModel.StorageFilterDebugMgs(volume, "it cannot be a DR primary recovery resource, offline-copy-resource reasons."));
            theLogger.logAndAssert(SrLogCategories.ERROR, "The offline-copy-GDR-volume is not completed feature");
            return false;
        }
        return true;
    }

    public static List<SiteNode> getSitesWithNoJournal() {
        ArrayList<SiteNode> list = new ArrayList<SiteNode>();
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        VolumeManager volMgr = VolumeManager.getInstance();
        block0: for (SiteNode site : sites) {
            List<ClusterNode> clusters = PairWizardValidations.getConnectedClusters(site);
            for (ClusterNode cluster : clusters) {
                if (volMgr.getJournalCreateAllowedCount(cluster) <= 0) continue;
                list.add(site);
                continue block0;
            }
        }
        return list;
    }
}

