/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.activation;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.activation.ActivationWizardContextKeys;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.SrFinishWizardPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;

public class SrStartDRActivationWizardPanel
extends SrFinishWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ActivationWizardTransaction activationTransaction = new ActivationWizardTransaction();

    public SrStartDRActivationWizardPanel(String message) {
        this.addWizardTransaction(this.activationTransaction);
        this.addWizardTransaction(new SelectDRRootNodeTransaction());
        SrClientLabel label = new SrClientLabel(message);
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 20, 20, 40);
        constraints.fill = 1;
        descriptionPanel.add((Component)label, constraints);
        this.add((Component)descriptionPanel, "Center");
    }

    @Override
    public void initDisplay() {
    }

    private Collection<String> getIds(SrTreeNode<?, String>[] nodes) {
        ArrayList<String> retVal = new ArrayList<String>(nodes.length);
        for (SrTreeNode<?, String> node : nodes) {
            retVal.add(node.getIdentifier());
        }
        return retVal;
    }

    @Override
    public void removeListeners() {
    }

    private class SelectDRRootNodeTransaction
    extends WizardTransaction {
        private SelectDRRootNodeTransaction() {
        }

        @Override
        protected void transaction() {
            EventDispatcherTask.submit(new Runnable(){

                @Override
                public void run() {
                    ClientLoader.getMainFrame().selectTreeNode(SrMainTreeModel.getInstance().getDRRootNode());
                }
            });
            this.stop();
        }
    }

    private class ActivationWizardTransaction
    extends WizardTransaction {
        private ActivationWizardTransaction() {
        }

        @Override
        public void transaction() {
            SrTreeNode[] cgs = (ExtendedElementNode[])SrStartDRActivationWizardPanel.this.getWizardContext().getAttribute(ActivationWizardContextKeys.SELECTED_CGS);
            SrTreeNode[] syncPairNodes = (DRSyncPairNode[])SrStartDRActivationWizardPanel.this.getWizardContext().getAttribute(ActivationWizardContextKeys.SELECTED_SYNC_PAIRS);
            ArrayList<String> ids = new ArrayList<String>();
            if (cgs != null) {
                ids.addAll(SrStartDRActivationWizardPanel.this.getIds(cgs));
            }
            if (syncPairNodes != null) {
                ids.addAll(SrStartDRActivationWizardPanel.this.getIds(syncPairNodes));
            }
            SrFuture<Void> actFuture = null;
            DRActivateConstant drActivation = (DRActivateConstant)SrStartDRActivationWizardPanel.this.getWizardContext().getAttribute(ActivationWizardContextKeys.DR_ACTION);
            if (DRActivateConstant.FALLBACK.equals(drActivation)) {
                actFuture = ClientAOImpl.getInstance().fallback(ids);
            } else if (DRActivateConstant.DISASTER_FAILOVER.equals(drActivation)) {
                actFuture = ClientAOImpl.getInstance().disasterOccured(ids);
            } else if (DRActivateConstant.PLANNED_FAILOVER.equals(drActivation)) {
                actFuture = ClientAOImpl.getInstance().plannedFailover(ids);
            } else {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The DR activate constant is: " + drActivation + " is not supported in the " + this.getClass() + " wizard.");
            }
            OperationController controller = new OperationController((ExtendedElementNode[])cgs, (DRSyncPairNode[])syncPairNodes, drActivation){
                final /* synthetic */ ExtendedElementNode[] val$cgs;
                final /* synthetic */ DRSyncPairNode[] val$syncPairNodes;
                final /* synthetic */ DRActivateConstant val$drActivation;
                {
                    this.val$cgs = extendedElementNodeArray;
                    this.val$syncPairNodes = dRSyncPairNodeArray;
                    this.val$drActivation = dRActivateConstant;
                }

                @Override
                public void fail(String aMessage) {
                    SrStartDRActivationWizardPanel.this.getOwner().fail(aMessage);
                }

                @Override
                public void inProcess(String aMessage) {
                }

                @Override
                public void success(SrAction aAction) {
                    ActionListener action = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ClientLoader.getMainFrame().selectTreeNode(SrMainTreeModel.getInstance().getDRRootNode());
                        }
                    };
                    int total = (this.val$cgs != null ? this.val$cgs.length : 0) + (this.val$syncPairNodes != null ? this.val$syncPairNodes.length : 0);
                    if (DRActivateConstant.FALLBACK.equals(this.val$drActivation)) {
                        SrTransientWindowPane.showMultiGDRPlannedFailbackStarted(ClientLoader.getMainFrame(), total, total, action);
                    } else if (DRActivateConstant.PLANNED_FAILOVER.equals(this.val$drActivation)) {
                        SrTransientWindowPane.showMultiGDRPlannedFailoverStarted(ClientLoader.getMainFrame(), total, total, action);
                    } else if (!DRActivateConstant.DISASTER_FAILOVER.equals(this.val$drActivation)) {
                        theLogger.logAndAssert(SrLogCategories.ERROR, "The DR activate constant is: " + this.val$drActivation + " is not supported in the " + this.getClass() + " wizard.");
                    }
                }
            };
            this.waitAndBlockActions(actFuture, controller);
        }
    }
}

