/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.activation;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.dr.wizards.SrWizardCGTableModel;
import com.sanrad.nms.client.data.dr.wizards.WizardCGTableHeader;
import com.sanrad.nms.client.event.dr.ResourceSelectionEvent;
import com.sanrad.nms.client.event.dr.ResourceSelectionListener;
import com.sanrad.nms.client.gui.GenericTableCellRenderer;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrClientTableHeader;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.activation.ActivationWizardContextKeys;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSplitPane;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class SrSelectCGWizardPanel
extends SrWizardPanel {
    private static final String COMMA_DELIMITER = ", ";
    protected SrTablePanel m_table;
    private SrPairDetailsTablePanel m_detailsTable;
    protected SrTreeNode[] m_drElements;

    public SrSelectCGWizardPanel(WizardContext context) {
        this.m_drElements = (SrTreeNode[])context.getAttribute(ActivationWizardContextKeys.AVAILABLE_DR_ELEMENTS);
        this.initComponents();
    }

    public SrSelectCGWizardPanel(SrTreeNode[] drElements) {
        this.m_drElements = drElements;
        this.initComponents();
    }

    private void initComponents() {
        SrClientLabel closeAppStr = new SrClientLabel(this.getPanelTitle());
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 20, 20, 20);
        constraints.fill = 1;
        descriptionPanel.add((Component)closeAppStr, constraints);
        this.add((Component)descriptionPanel, "North");
        SrSplitPane splitTablesPanel = new SrSplitPane(0);
        splitTablesPanel.setDividerLocation(150);
        SrPanel mainTablesPanel = new SrPanel(new GridBagLayout());
        this.m_table = new SrWizardCGTablePanel(this.m_drElements);
        this.m_detailsTable = new SrPairDetailsTablePanel();
        constraints.insets.top = 0;
        mainTablesPanel.add((Component)splitTablesPanel, constraints);
        JPanel cgTitlePanel = this.createTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_VIEW_CG_TITLE));
        JPanel detailsTitlePanel = this.createTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_VIEW_CG_DETAILS_TITLE));
        SrPanel cgPanel = new SrPanel(new BorderLayout());
        cgPanel.add((Component)cgTitlePanel, "North");
        cgPanel.add((Component)this.m_table, "Center");
        splitTablesPanel.setTopComponent(cgPanel);
        SrPanel detailsPanel = new SrPanel(new BorderLayout());
        detailsPanel.add((Component)detailsTitlePanel, "North");
        detailsPanel.add((Component)this.m_detailsTable, "Center");
        splitTablesPanel.setBottomComponent(detailsPanel);
        this.add((Component)mainTablesPanel, "Center");
    }

    private JPanel createTitle(String txt) {
        JPanel detailsTitlePanel = new JPanel(new FlowLayout(0));
        JLabel lbl = new JLabel(txt);
        lbl.setFont(Font.decode(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT)));
        lbl.setForeground(ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FOREGROUND));
        detailsTitlePanel.add(lbl);
        return detailsTitlePanel;
    }

    @Override
    public final void display() {
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                SrSelectCGWizardPanel.this.m_table.getTable().getSelectionModel().setSelectionInterval(0, SrSelectCGWizardPanel.this.m_table.getTable().getRowCount() - 1);
            }
        });
        this.initDisplay();
    }

    @Override
    public boolean hasNext() {
        boolean valid = false;
        int[] rowIndices = this.m_table.getSelectedRows();
        if (rowIndices != null && rowIndices.length > 0) {
            valid = true;
        }
        return valid;
    }

    @Override
    public final WizardPanel next() {
        int i;
        int[] rowIndices = this.m_table.getSelectedRows();
        ArrayList<Object> cgRows = new ArrayList<Object>();
        ArrayList<Object> syncPairRows = new ArrayList<Object>();
        int nodeIdxInModel = this.m_table.getModel().getColumnIndex(WizardCGTableHeader.NODE.getColumnName());
        for (int i2 = 0; i2 < rowIndices.length; ++i2) {
            Object node = this.m_table.getTable().getValueAt(rowIndices[i2], nodeIdxInModel);
            if (node instanceof DRSyncPairNode) {
                syncPairRows.add(node);
                continue;
            }
            cgRows.add(node);
        }
        StringBuffer cgsDisplayBuff = new StringBuffer();
        StringBuffer pairsDisplayBuff = new StringBuffer();
        if (!cgRows.isEmpty()) {
            ExtendedElementNode[] cgArray = cgRows.toArray(new ExtendedElementNode[cgRows.size()]);
            this.getWizardContext().setAttribute(ActivationWizardContextKeys.SELECTED_CGS, cgArray, this);
            for (i = 0; i < cgArray.length; ++i) {
                if (cgArray[i] instanceof ConsistencyGroupNode) {
                    cgsDisplayBuff.append(cgArray[i].toString());
                    cgsDisplayBuff.append(COMMA_DELIMITER);
                    continue;
                }
                if (!(cgArray[i] instanceof ExtendedPairNode)) continue;
                DRASyncPairNode pair = ((ExtendedPairNode)cgArray[i]).getPair();
                pairsDisplayBuff.append(pair.toString());
                pairsDisplayBuff.append(COMMA_DELIMITER);
            }
            if (cgsDisplayBuff.length() > 0) {
                cgsDisplayBuff.delete(cgsDisplayBuff.length() - COMMA_DELIMITER.length(), cgsDisplayBuff.length());
                this.getWizardContext().setAttribute(ActivationWizardContextKeys.SELECTED_CGS_DISPLAY, cgsDisplayBuff.toString(), this);
            }
        }
        if (!syncPairRows.isEmpty()) {
            DRSyncPairNode[] syncPairArray = syncPairRows.toArray(new DRSyncPairNode[syncPairRows.size()]);
            this.getWizardContext().setAttribute(ActivationWizardContextKeys.SELECTED_SYNC_PAIRS, syncPairArray, this);
            for (i = 0; i < syncPairArray.length; ++i) {
                pairsDisplayBuff.append(syncPairArray[i].toString());
                pairsDisplayBuff.append(COMMA_DELIMITER);
            }
            if (pairsDisplayBuff.length() > 0) {
                pairsDisplayBuff.delete(pairsDisplayBuff.length() - COMMA_DELIMITER.length(), pairsDisplayBuff.length());
                this.getWizardContext().setAttribute(ActivationWizardContextKeys.SELECTED_PAIRS_DISPLAY, pairsDisplayBuff.toString(), this);
            }
        }
        return this.getNextPanel();
    }

    protected abstract WizardPanel getNextPanel();

    protected abstract String getPanelTitle();

    protected abstract void initDisplay();

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public final void removeListeners() {
        this.m_table.getModel().removeListeners();
    }

    private static class SrPairDetailsTableHeader
    extends SrClientTableHeader {
        private static Vector columnNames = null;
        public static final SrPairDetailsTableHeader PRIM_VOL = new SrPairDetailsTableHeader(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_CG_TABLE_HEADER_PRIMARY_VOLUME));
        public static final SrPairDetailsTableHeader SEC_VOL = new SrPairDetailsTableHeader(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_CG_TABLE_HEADER_SECONDARY_VOLUME));

        public SrPairDetailsTableHeader(String columnName) {
            super(columnName);
            if (columnNames == null) {
                columnNames = new Vector();
            }
            columnNames.addElement(this.getColumnName());
        }

        public static Vector getColumnNames() {
            return columnNames;
        }
    }

    private static class SrPairDetailsWizardTableModel
    extends SrTableModel {
        public SrPairDetailsWizardTableModel() {
            super(new SrDefaultTableColumns(SrPairDetailsTableHeader.getColumnNames()));
        }

        public void setTableData(DRPairNode[] pairs) {
            this.removeAllRows();
            for (int i = 0; i < pairs.length; ++i) {
                Object[] row = new Object[SrPairDetailsTableHeader.getColumnNames().size()];
                row[this.getColumnIndex((String)SrPairDetailsTableHeader.PRIM_VOL.getColumnName())] = pairs[i].getPairPrimaryVolume();
                row[this.getColumnIndex((String)SrPairDetailsTableHeader.SEC_VOL.getColumnName())] = pairs[i].getPairSecondaryVolume();
                this.addRowQuetly(row, -1);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }

        @Override
        public void removeListeners() {
        }

        @Override
        public void addListeners() {
        }
    }

    public static class SrPairDetailsTablePanel
    extends SrTablePanel
    implements ResourceSelectionListener {
        public SrPairDetailsTablePanel() {
            super(new SrPairDetailsWizardTableModel());
            this.getTable().setRowSelectionAllowed(false);
            this.getTable().setColumnSelectionAllowed(false);
            GenericTableCellRenderer renderer = new GenericTableCellRenderer();
            this.setTablePanelCellRenderer(renderer);
        }

        @Override
        public void onResourceSelection(ResourceSelectionEvent e) {
            Vector sel = e.getSelectionVector();
            if (sel.size() > 0 && sel.get(0) != null) {
                Object selNode = sel.get(0);
                DRPairNode[] pairs = null;
                if (selNode instanceof ConsistencyGroupNode) {
                    pairs = ((ConsistencyGroupNode)selNode).getPairs();
                } else if (selNode instanceof ExtendedPairNode) {
                    pairs = new DRASyncPairNode[]{((ExtendedPairNode)selNode).getPair()};
                } else if (selNode instanceof DRSyncPairNode) {
                    pairs = new DRPairNode[]{(DRPairNode)selNode};
                }
                ((SrPairDetailsWizardTableModel)this.getModel()).setTableData(pairs);
            }
        }
    }

    public class SrWizardCGTablePanel
    extends SrTablePanel {
        public SrWizardCGTablePanel(SrTreeNode[] drElements) {
            super(new SrWizardCGTableModel(drElements));
            this.init();
        }

        private void init() {
            this.setSelectionMode(2);
            this.hideTableColumn(WizardCGTableHeader.NODE.getColumnName());
            GenericTableCellRenderer renderer = new GenericTableCellRenderer();
            this.setTablePanelCellRenderer(renderer);
        }

        @Override
        protected void rowSelectionChanged(int[] rowIndices) {
            SrSelectCGWizardPanel.this.setNextButtonEnabled(rowIndices.length > 0);
            int drElementCol = this.getModel().getColumnIndex(WizardCGTableHeader.NODE.getColumnName());
            ArrayList<SrTreeNode> pairsList = new ArrayList<SrTreeNode>();
            for (int i = 0; i < rowIndices.length; ++i) {
                SrTreeNode drElement = (SrTreeNode)this.getModel().getValueAt(rowIndices[i], drElementCol);
                if (drElement instanceof ConsistencyGroupNode) {
                    pairsList.addAll(Arrays.asList(((ConsistencyGroupNode)drElement).getPairs()));
                    continue;
                }
                if (drElement instanceof ExtendedPairNode) {
                    pairsList.add(((ExtendedPairNode)drElement).getPair());
                    continue;
                }
                if (!(drElement instanceof DRSyncPairNode)) continue;
                pairsList.add(drElement);
            }
            ((SrPairDetailsWizardTableModel)SrSelectCGWizardPanel.this.m_detailsTable.getModel()).setTableData(pairsList.toArray(new DRPairNode[pairsList.size()]));
        }
    }
}

