/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.activation;

import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.dr.wizards.activation.ActivationWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SnapshotWizardContextKeys;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.SrHiddenWizardPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collections;
import java.util.HashMap;

public abstract class SrActivationPreSnapshotWizardPanel
extends SrHiddenWizardPanel {
    private AttachPairSnapshotTransaction attachSnapshotTransaction = new AttachPairSnapshotTransaction();

    public SrActivationPreSnapshotWizardPanel() {
        this.addWizardTransaction(new WizardTransaction(){

            @Override
            protected void transaction() {
                SrActivationPreSnapshotWizardPanel.this.wizardContext.setAttribute(SnapshotWizardContextKeys.IS_BACK_BUTTON_VISIBLE, Boolean.FALSE, SrActivationPreSnapshotWizardPanel.this);
                this.stop();
            }
        });
        this.addWizardTransaction(this.attachSnapshotTransaction);
    }

    @Override
    public final void removeListeners() {
    }

    private class AttachPairSnapshotTransaction
    extends WizardTransaction {
        SnapshotVolumeNode m_createdSnapshot;

        private AttachPairSnapshotTransaction() {
        }

        @Override
        protected void transaction() {
            DRASyncPairNode asyncPair = (DRASyncPairNode)SrActivationPreSnapshotWizardPanel.this.wizardContext.getAttribute(ActivationWizardContextKeys.ASYNC_PAIR_FOR_SEC_SNAPSHOT);
            this.m_createdSnapshot = (SnapshotVolumeNode)SrActivationPreSnapshotWizardPanel.this.wizardContext.getAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT);
            VolumeTreeNode snapSource = (VolumeTreeNode)SrActivationPreSnapshotWizardPanel.this.wizardContext.getAttribute(ActivationWizardContextKeys.SNAPSHOT_SOURCE);
            if (asyncPair != null && this.m_createdSnapshot != null && snapSource != null) {
                ClientParameterCode code = null;
                if (snapSource == asyncPair.getPairSecondaryVolume()) {
                    code = ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME;
                } else if (snapSource == asyncPair.getPairPrimaryVolume()) {
                    code = ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME;
                }
                HashMap<ClientParameterCode, Object> changedValues = new HashMap<ClientParameterCode, Object>();
                changedValues.put(code, this.m_createdSnapshot.getIdentifier());
                HashMap pairToISyncTypeMap = (HashMap)SrActivationPreSnapshotWizardPanel.this.wizardContext.getAttribute(ActivationWizardContextKeys.PAIR_TO_ISYNC_TYPE_MAP);
                DRPairInitialSyncTypeConstant isyncType = (DRPairInitialSyncTypeConstant)pairToISyncTypeMap.get(asyncPair);
                if (isyncType != null) {
                    changedValues.put(ClientParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, isyncType);
                }
                SrFuture<Void> actFuture = ClientAOImpl.getInstance().changeElements(Collections.singleton(asyncPair.getIdentifier()), changedValues);
                this.waitAndBlockActions(actFuture, SrActivationPreSnapshotWizardPanel.this.getOwner());
            } else {
                this.stop();
            }
        }
    }
}

