/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.activation;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairSelectISyncTypeWizardPanel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.util.concurrent.SrFuture;
import java.util.HashMap;

public abstract class SrActivationChangeISyncTypeWizardPanel
extends SrPairSelectISyncTypeWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected DRPairNode m_pair;
    private ChangeISyncTransaction m_changeISyncTransaction = new ChangeISyncTransaction();

    public SrActivationChangeISyncTypeWizardPanel(DRPairNode pair) {
        this.m_initialSyncCombo.removeAllItems();
        this.m_initialSyncCombo.addItem(DRPairInitialSyncTypeConstant.NONE);
        this.m_initialSyncCombo.addItem(DRPairInitialSyncTypeConstant.ONLINE);
        if (pair instanceof DRASyncPairNode) {
            this.m_initialSyncCombo.addItem(DRPairInitialSyncTypeConstant.OFFLINE);
        }
        this.m_pair = pair;
        this.addWizardTransaction(this.m_changeISyncTransaction);
        DRSyncPairManager.getInstance().addDRSyncPairListener(this.m_changeISyncTransaction);
    }

    @Override
    public void removeListeners() {
        DRSyncPairManager.getInstance().removeDRSyncPairListener(this.m_changeISyncTransaction);
    }

    @Override
    public void display() {
        this.setButtonVisible("BACK_I18N", false);
    }

    private class ChangeISyncTransaction
    extends WizardTransaction
    implements DRSyncPairListener {
        private ChangeISyncTransaction() {
        }

        @Override
        protected void transaction() {
            if (SrActivationChangeISyncTypeWizardPanel.this.m_pair instanceof DRSyncPairNode && !DRPairInitialSyncTypeConstant.NONE.equals(SrActivationChangeISyncTypeWizardPanel.this.m_initialSyncCombo.getSelectedItem())) {
                HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>();
                params.put(ClientParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, SrActivationChangeISyncTypeWizardPanel.this.m_initialSyncCombo.getSelectedItem());
                SrFuture<Void> actFuture = DRSyncPairManager.getInstance().changeSyncPair((DRSyncPairNode)SrActivationChangeISyncTypeWizardPanel.this.m_pair, params);
                this.waitAndBlockActions(actFuture, SrActivationChangeISyncTypeWizardPanel.this.getOwner());
            } else {
                this.stop();
            }
        }

        @Override
        public void syncPairCreated(DRSyncPairEvent e) {
        }

        @Override
        public void syncPairRemoved(DRSyncPairEvent e) {
            if (e.getPair() == SrActivationChangeISyncTypeWizardPanel.this.m_pair) {
                this.stop();
            }
        }

        @Override
        public void syncPairChanged(DRSyncPairEvent e) {
            if (e.getPair() == SrActivationChangeISyncTypeWizardPanel.this.m_pair && !DRPairInitialSyncTypeConstant.NONE.equals(SrActivationChangeISyncTypeWizardPanel.this.m_pair.getInitialSyncType())) {
                this.stop();
            }
        }
    }
}

