/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards.activation;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.acl.AclWorkbenchFrame;
import com.sanrad.nms.client.gui.acl.AclWorkbenchMainPanel;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.activation.ActivationWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.activation.SrACLTargetViewWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.activation.SrStartDRActivationWizardPanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;

public class SrACLConfigWizardPanel
extends SrWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private TargetNode m_target;
    private AclWorkbenchMainPanel m_aclPanel;
    private PolicyManager m_policyMgr;
    private UpdateAclTransaction m_updateAclTransaction = new UpdateAclTransaction();

    public SrACLConfigWizardPanel(TargetNode target) {
        this.m_target = target;
        this.initComponents();
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_target);
        this.m_policyMgr = clusterNode.getPolicyManager();
        this.addWizardTransaction(this.m_updateAclTransaction);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainConstraints = new GridBagConstraints();
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.anchor = 17;
        mainConstraints.weightx = 1.0;
        mainConstraints.insets = new Insets(0, 0, 0, 10);
        mainConstraints.fill = 2;
        SrClientLabel targetAliasLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_ACL_VIEW_TARGET_ALIAS_LABEL));
        SrTextField targetAliasTxt = new SrTextField(this.m_target.getAlias());
        targetAliasTxt.setEditable(false);
        FontMetrics fontMatrix = targetAliasTxt.getFontMetrics(targetAliasTxt.getFont());
        targetAliasTxt.setMaximumSize(new Dimension(fontMatrix.stringWidth(targetAliasTxt.getText()) + 40, fontMatrix.getHeight()));
        SrPanel targetAliasPanel = new SrPanel(new FlowLayout(0, 10, 10));
        targetAliasPanel.add(targetAliasLbl);
        targetAliasPanel.add(targetAliasTxt);
        this.add((Component)targetAliasPanel, mainConstraints);
        SrPanel mainAclViewAndEditPanel = new SrPanel(new BorderLayout());
        mainAclViewAndEditPanel.setBorder(BorderFactory.createEtchedBorder());
        SrMultiLineLabel aclViewStr = new SrMultiLineLabel(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_ACL_CONFIG_PANEL_DESC, this.m_target.getAlias()));
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        descriptionPanel.add((Component)aclViewStr, constraints);
        mainAclViewAndEditPanel.add((Component)descriptionPanel, "North");
        SrAclWorkbenchWizardFrame workbench = new SrAclWorkbenchWizardFrame(this.m_target);
        this.m_aclPanel = workbench.getAclWorkbenchMainPanel();
        mainAclViewAndEditPanel.add((Component)workbench.getContentPane(), "Center");
        mainConstraints.gridy = 1;
        mainConstraints.weighty = 1.0;
        mainConstraints.insets.bottom = 10;
        mainConstraints.insets.left = 10;
        mainConstraints.fill = 1;
        this.add((Component)mainAclViewAndEditPanel, mainConstraints);
    }

    @Override
    public void display() {
    }

    @Override
    public WizardPanel next() {
        SrWizardPanel nextPanel = null;
        ArrayList remoteTargets = (ArrayList)this.getWizardContext().getAttribute(ActivationWizardContextKeys.TARGET_LIST);
        if (remoteTargets.size() > 0) {
            TargetNode remoteTarget = (TargetNode)remoteTargets.remove(0);
            nextPanel = new SrACLTargetViewWizardPanel(remoteTarget, this.getWizardContext(), false);
        } else {
            String msg = (String)this.getWizardContext().getAttribute(ActivationWizardContextKeys.START_DR_ACTIVATION_MSG);
            nextPanel = new SrStartDRActivationWizardPanel(msg);
        }
        return nextPanel;
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public void back() {
    }

    @Override
    public void removeListeners() {
    }

    private class UpdateAclTransaction
    extends WizardTransaction {
        private UpdateAclTransaction() {
        }

        @Override
        protected void transaction() {
            List<List<Object>> newAcl = SrACLConfigWizardPanel.this.m_aclPanel.getNewAclFromTable();
            if (newAcl != null && newAcl.size() > 0) {
                SrFuture<Void> actFuture = SrACLConfigWizardPanel.this.m_policyMgr.updateAcl(SrACLConfigWizardPanel.this.m_target, SrACLConfigWizardPanel.this.m_aclPanel.getNewAclFromTable());
                this.waitAndBlockActions(actFuture, SrACLConfigWizardPanel.this.getOwner());
            } else {
                this.stop();
            }
        }
    }

    private class SrAclWorkbenchWizardFrame
    extends AclWorkbenchFrame {
        public SrAclWorkbenchWizardFrame(TargetNode targetNode) {
            super(targetNode);
            this.getAclWorkbenchMainPanel().getSplitPanel().setDividerLocation(100);
        }

        protected GridBagConstraints getConstraintsForUpperPanel() {
            return new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        }

        @Override
        protected SrPanel createButtonsPanel() {
            return null;
        }
    }
}

