/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.cluster.ClusterListener;
import com.sanrad.nms.client.event.site.SiteEvent;
import com.sanrad.nms.client.event.site.SiteListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.pair.PairWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.recover.RecoverWizardContextKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public abstract class SrSelectSiteClusterVSwitchPanel
extends SrDRWizardPanel {
    protected SrComboBox m_clusterVSwitchCombo;
    protected SrComboBox m_sitesCombo;
    protected SrPropertyPanel m_prop;
    private ClusterListener myClusterListener = new ClusterListener(){

        @Override
        public void clusterCreated(ClusterEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void clusterPropertiesChanged(ClusterEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void clusterRemoved(ClusterEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void clusterStatusChanged(ClusterEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void discoverCompleted(ClusterEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void discoverStarted(ClusterEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void refreshCluster(ClusterEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }
    };
    private SiteListener mySiteListener = new SiteListener(){

        @Override
        public void siteCreated(SiteEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void sitePropertiesChanged(SiteEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void siteRemoved(SiteEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }

        @Override
        public void siteStatusChanged(SiteEvent event) {
            SrSelectSiteClusterVSwitchPanel.this.rebuildComboBoxes();
        }
    };
    private WizardTransaction registerClusterTransaction = new WizardTransaction(){

        @Override
        protected void transaction() {
            SrSelectSiteClusterVSwitchPanel.this.getOwner().addParticipatingCluster((ClusterNode)SrSelectSiteClusterVSwitchPanel.this.m_clusterVSwitchCombo.getSelectedItem());
            this.stop();
        }
    };

    protected SrSelectSiteClusterVSwitchPanel() {
        this.initComponents();
        this.addWizardTransaction(this.registerClusterTransaction);
    }

    protected abstract String getPanelTitleDesc();

    protected abstract String getSiteSelectionDesc();

    protected abstract String getClusterVSwitchSelectionDesc();

    protected Object[] getSiteList() {
        SiteNode backupSite = (SiteNode)this.wizardContext.getAttribute(RecoverWizardContextKeys.BACKUP_SITE);
        List<SiteNode> siteList = PairWizardValidations.getSitesWithConnectedCluster();
        if (backupSite != null) {
            siteList.remove(backupSite);
        }
        return siteList.toArray();
    }

    private void initComponents() {
        SrMultiLineLabel descLabel = new SrMultiLineLabel(this.getPanelTitleDesc());
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 10, 20, 40);
        constraints.fill = 1;
        descriptionPanel.add((Component)descLabel, constraints);
        this.add((Component)descriptionPanel, "North");
        this.m_sitesCombo = new SrComboBox();
        this.m_clusterVSwitchCombo = new SrComboBox();
        this.m_prop = new InnerPropertyPanel(SrSelectSiteClusterVSwitchPanel.class.toString(), false, true, false);
        this.m_prop.skipLines(1);
        this.m_prop.addLabel(this.getSiteSelectionDesc());
        this.m_prop.skipLines(1);
        this.m_prop.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_WIZ_SELECTED_SITE_KEY), new SrWidget(null, this.m_sitesCombo, true, false, false, true, null));
        this.m_prop.skipLines(2);
        this.m_prop.addLabel(this.getClusterVSwitchSelectionDesc());
        this.m_prop.skipLines(1);
        this.m_prop.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_WIZ_SELECTED_CLUSTER_KEY), new SrWidget(null, this.m_clusterVSwitchCombo, true, false, false, false, null));
        this.add((Component)this.m_prop, "Center");
    }

    protected Object[] getClusterVSwitchList(SiteNode site) {
        SiteNode siteNode = site;
        ClusterNode[] clusters = siteNode.getSiteClusters();
        ArrayList<ClusterNode> connectedClusterList = new ArrayList<ClusterNode>();
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[i].allAvailableVSwitchesDisconnected()) continue;
            connectedClusterList.add(clusters[i]);
        }
        return connectedClusterList.toArray();
    }

    @Override
    public void display() {
        ClusterManager.getInstance().addClusterListener(this.myClusterListener);
        SiteManager.getInstance().addSiteListener(this.mySiteListener);
        int i = this.m_clusterVSwitchCombo.getItemCount();
        while (i-- > 0) {
            this.getOwner().removeParticipatingCluster((ClusterNode)this.m_clusterVSwitchCombo.getItemAt(i));
        }
        this.m_sitesCombo.removeAllItems();
        this.rebuildComboBoxes();
        this.m_sitesCombo.addItemListener(this.m_prop.getSrListener());
        this.m_prop.addValidationListener(this.getOwner());
        this.m_prop.onUpdateEvent(null);
    }

    private void rebuildComboBoxes() {
        this.m_sitesCombo.removeAllItems();
        this.m_clusterVSwitchCombo.removeAllItems();
        Object[] listOfSites = this.getSiteList();
        this.m_sitesCombo.setModel(new DefaultComboBoxModel<Object>(listOfSites));
        if (this.m_sitesCombo.getItemCount() > 0) {
            Object[] items = this.getClusterVSwitchList((SiteNode)this.m_sitesCombo.getItemAt(0));
            this.m_clusterVSwitchCombo.setModel(new DefaultComboBoxModel<Object>(items));
        }
        this.setNextButtonEnabled(this.m_sitesCombo.getItemCount() > 0);
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public WizardPanel next() {
        return null;
    }

    @Override
    public void removeListeners() {
        ClusterManager.getInstance().removeClusterListener(this.myClusterListener);
        SiteManager.getInstance().removeSiteListener(this.mySiteListener);
    }

    class InnerPropertyPanel
    extends SrPropertyPanel {
        public InnerPropertyPanel(String panelName, boolean verticalScrool, boolean stickUpItems, boolean isRightToLeft) {
            super(panelName, verticalScrool, stickUpItems, isRightToLeft);
        }

        @Override
        public void onUpdateEvent(EventObject e) {
            SiteNode site;
            super.onUpdateEvent(e);
            if (e != null && e.getSource() == SrSelectSiteClusterVSwitchPanel.this.m_sitesCombo && (site = (SiteNode)SrSelectSiteClusterVSwitchPanel.this.m_sitesCombo.getSelectedItem()) != null) {
                SrSelectSiteClusterVSwitchPanel.this.m_clusterVSwitchCombo.removeAllItems();
                Object[] newItems = SrSelectSiteClusterVSwitchPanel.this.getClusterVSwitchList(site);
                for (int i = 0; i < newItems.length; ++i) {
                    SrSelectSiteClusterVSwitchPanel.this.m_clusterVSwitchCombo.addItem(newItems[i]);
                }
            }
        }
    }
}

