/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTreeModel;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.dr.ResourceSelectionEvent;
import com.sanrad.nms.client.event.dr.ResourceSelectionListener;
import com.sanrad.nms.client.event.storage.StorageManagerEvent;
import com.sanrad.nms.client.event.storage.StorageManagerListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.ResourceTableCellRenderer;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.SrResourceTreePanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableColumn;

public abstract class SrSelectResourceWizardPanel
extends SrDRWizardPanel
implements ResourceSelectionListener,
StorageManagerListener,
SubDirectAccessDeviceListener,
VolumeListener,
DirectAccessDeviceListener {
    private SrWizardPanel m_theCreateResourceStep;
    protected SrResourceTablePanel m_table;
    protected ClusterNode m_clusterNode;

    protected SrSelectResourceWizardPanel(ClusterNode cluster) {
        this(cluster, true);
    }

    protected SrSelectResourceWizardPanel(ClusterNode cluster, boolean aIncludeNewVolumeButton) {
        this.m_clusterNode = cluster;
        this.m_theCreateResourceStep = null;
        this.initComponents(aIncludeNewVolumeButton);
    }

    protected abstract String getPanelTitleDesc();

    protected abstract SrWizardPanel getCreateVolumePanel();

    public abstract SrResourceTableModel getResourceTableModel(ClusterNode var1, WizardContext var2);

    private void initComponents() {
        this.initComponents(true);
    }

    private void initComponents(boolean aIncludeNewVolumeButton) {
        SrPanel subMainPanel = new SrPanel(new BorderLayout());
        SrClientLabel descLabel = new SrClientLabel(this.getPanelTitleDesc());
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 10, 20, 40);
        constraints.fill = 1;
        descriptionPanel.add((Component)descLabel, constraints);
        subMainPanel.add((Component)descriptionPanel, "North");
        SrPanel tableTreePanel = new SrPanel(new GridBagLayout());
        this.m_table = new SrResourceTablePanel(SrResourceTableModel.getEmptyModel());
        this.m_table.addResourceSelectionListeners(this);
        SrResourceTreePanel tree = new SrResourceTreePanel();
        this.m_table.addResourceSelectionListeners((SrResourceTreeModel)tree.getTreeModel());
        constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 10, 0, 10);
        constraints.fill = 1;
        tableTreePanel.add((Component)this.m_table, constraints);
        tableTreePanel.add((Component)tree, constraints);
        subMainPanel.add((Component)tableTreePanel, "Center");
        this.add((Component)subMainPanel, "Center");
        if (aIncludeNewVolumeButton) {
            SrButton createVolumeBtt = new SrButton(new SrClientAction<Void, Void>(this.getCreateVolumeButtonString(), true, true, null, SrLicenseTreePath.GENERAL_PATH){

                @Override
                public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                    SrSelectResourceWizardPanel.this.wizardContext.setAttribute(SrSelectResourceWizardPanel.this.getContextKeyForSelectedResource(), null, SrSelectResourceWizardPanel.this);
                    SrSelectResourceWizardPanel.this.m_theCreateResourceStep = SrSelectResourceWizardPanel.this.getCreateVolumePanel();
                    SrSelectResourceWizardPanel.this.fireNextButtonAction();
                    return Collections.EMPTY_LIST;
                }

                @Override
                protected String derivedClientUpdateEnabled() {
                    return null;
                }
            });
            SrPanel bttPanel = new SrPanel(new FlowLayout(0, 10, 20));
            bttPanel.add(createVolumeBtt);
            this.add((Component)bttPanel, "South");
        }
    }

    protected String getCreateVolumeButtonString() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_WIZ_SELECT_RESOURCE_CREATE_VOLUME_BUTTON);
    }

    @Override
    public void display() {
        ((SrResourceTableModel)this.m_table.getTable().getModel()).initModel();
        VolumeManager.getInstance().addVolumeListener(this);
        StorageManager.getInstance().addStorageManagerListener(this);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this);
        this.setNextButtonEnabled(this.isRowSelected());
    }

    @Override
    public boolean hasNext() {
        return this.isRowSelected();
    }

    @Override
    public final WizardPanel next() {
        if (this.m_theCreateResourceStep != null) {
            SrWizardPanel nextStep = this.m_theCreateResourceStep;
            this.m_theCreateResourceStep = null;
            return nextStep;
        }
        this.wizardContext.setAttribute(this.getContextKeyForSelectedResource(), this.getSelectedVolume(), this);
        return this.doNext();
    }

    protected abstract WizardPanel doNext();

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this);
        StorageManager.getInstance().removeStorageManagerListener(this);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this);
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public void back() {
        this.wizardContext.setAttribute(this.getContextKeyForSelectedResource(), null, this);
        VolumeManager.getInstance().removeVolumeListener(this);
        StorageManager.getInstance().removeStorageManagerListener(this);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this);
    }

    private boolean isRowSelected() {
        boolean goNext = false;
        int selectedRow = this.m_table.getTable().getSelectedRow();
        if (selectedRow != -1) {
            goNext = true;
        }
        return goNext;
    }

    public boolean isTableEmpty() {
        return this.m_table.getTable().getRowCount() == 0;
    }

    public void setTableModel(SrResourceTableModel model) {
        this.m_table.setModel(model);
    }

    protected VolumeTreeNode getSelectedVolume() {
        int selectRow = this.m_table.getSelectedRow();
        if (selectRow >= 0) {
            return (VolumeTreeNode)this.m_table.getTable().getValueAt(selectRow, 0);
        }
        return null;
    }

    @Override
    public void onResourceSelection(ResourceSelectionEvent e) {
        boolean goNext = false;
        Vector nodes = e.getSelectionVector();
        if (!nodes.isEmpty()) {
            goNext = true;
        }
        this.setNextButtonEnabled(goNext);
    }

    protected abstract ContextKey getContextKeyForSelectedResource();

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        model.notifyVolumeChanged(parentNode);
        model.notifyVolumeChanged(childNode);
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        model.notifyVolumeChanged(childNode);
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeAliasChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeCreated(volume);
    }

    @Override
    public void volumeDeExposed(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeExposed(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeRemove(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeRemoved(volume);
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void volumeStatusChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    @Override
    public void addStorageData(StorageManagerEvent e) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        Object[] nodes = e.getStorageData();
        int i = nodes.length;
        while (i-- > 0) {
            VolumeTreeNode volume = (VolumeTreeNode)nodes[i];
            model.notifyVolumeCreated(volume);
        }
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeCreated(volume);
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeRemoved(volume);
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeCreated(volume);
    }

    @Override
    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    @Override
    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeRemoved(volume);
    }

    @Override
    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
        SrResourceTableModel model = (SrResourceTableModel)this.m_table.getTable().getModel();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        model.notifyVolumeChanged(volume);
    }

    public class SrResourceTablePanel
    extends SrTablePanel {
        private SrEventListenerManager m_listeners;
        SrEventListenerManager.Informer<ResourceSelectionListener, ResourceSelectionEvent> onResourceSelectionInformer;

        public SrResourceTablePanel(SrResourceTableModel model) {
            super(model);
            this.m_listeners = new SrEventListenerManager();
            this.onResourceSelectionInformer = new SrEventListenerManager.Informer<ResourceSelectionListener, ResourceSelectionEvent>(){

                @Override
                public void inform(ResourceSelectionListener listener, ResourceSelectionEvent event) {
                    listener.onResourceSelection(event);
                }
            };
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new ResourceTableCellRenderer());
        }

        @Override
        protected void rowSelectionChanged(int[] rowIndices) {
            Vector<Object> vec = new Vector<Object>();
            if (rowIndices.length > 0) {
                List<Object> row = this.getRow(rowIndices[0]);
                vec.addElement(row.get(0));
            }
            ResourceSelectionEvent event = new ResourceSelectionEvent(this, vec);
            this.m_listeners.fireEvent(ResourceSelectionListener.class, event, this.onResourceSelectionInformer);
        }

        public void removeResourceSelectionListeners(ResourceSelectionListener listener) {
            this.m_listeners.remove(listener);
        }

        public void addResourceSelectionListeners(ResourceSelectionListener listener) {
            this.m_listeners.add(listener);
        }
    }
}

